/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.owl2soml;

import com.github.jsonldjava.shaded.com.google.common.collect.Sets;
import com.ontotext.models.ErrorMessages;
import com.ontotext.models.Prefixes;
import com.ontotext.platform.owl2soml.Classes;
import com.ontotext.platform.owl2soml.Config;
import com.ontotext.platform.owl2soml.Constants;
import com.ontotext.platform.owl2soml.ConversionException;
import com.ontotext.platform.owl2soml.DataAccess;
import com.ontotext.platform.owl2soml.InputOntology;
import com.ontotext.platform.owl2soml.InvalidArgumentException;
import com.ontotext.platform.owl2soml.Message;
import com.ontotext.platform.owl2soml.MultiTypeDef;
import com.ontotext.platform.owl2soml.NamespaceMapping;
import com.ontotext.platform.owl2soml.Namespaces;
import com.ontotext.platform.owl2soml.Ontology;
import com.ontotext.platform.owl2soml.OntologySet;
import com.ontotext.platform.owl2soml.OwlRestrictionsInfo;
import com.ontotext.platform.owl2soml.Permissions;
import com.ontotext.platform.owl2soml.Properties;
import com.ontotext.platform.owl2soml.Role;
import com.ontotext.platform.owl2soml.RoleAction;
import com.ontotext.platform.owl2soml.Scalars;
import com.ontotext.platform.owl2soml.SomlOntology;
import com.ontotext.platform.owl2soml.Utils;
import com.ontotext.platform.owl2soml.memory.InMemoryModelDataAccess;
import com.ontotext.soaas.common.CollectionsUtil;
import java.io.InputStream;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class Owl2SomlConverter {
    private static final String LANG_FETCH = "fetch";
    private static final String LANG_IMPLICIT = "implicit";
    private static final String LANG_VALIDATE = "validate";
    private static final Set<String> LANG_KEYS = Set.of("fetch", "validate", "implicit");
    private static final String LITERAL = "literal";
    private static final String NO_VOC = "NONE";
    private static final Yaml YAML;
    private final Map<String, String> dataTypes;
    private final OntologySet ontologyDataset;
    private final List<Message> messages = new LinkedList<Message>();
    private final String lang;
    private final String stringMode;
    private final Scalars scalars = new Scalars();
    private final Namespaces namespaces = new Namespaces(this.scalars);
    private final DataAccess dataAccess;
    private final String label;
    private final String description;
    private Classes classes;
    private Properties properties;
    private Permissions permissions;
    private Config config;
    private Ontology ontology;
    private final boolean useDefaultPrefix;
    private Map<String, String> federatedServices;

    private Owl2SomlConverter(Builder builder) {
        this.label = builder.label;
        this.lang = builder.lang;
        this.description = builder.description;
        this.stringMode = Objects.toString(builder.stringMode, "stringOrLangString");
        this.dataTypes = Owl2SomlConverter.buildDataTypeMapping(this.stringMode);
        if (NO_VOC.equals(builder.vocPfx)) {
            this.useDefaultPrefix = true;
        } else {
            this.useDefaultPrefix = false;
            if (builder.vocPfx != null) {
                this.namespaces.getSpecialPrefixes().put("vocab_prefix", builder.vocPfx);
            }
        }
        if (builder.prefixes != null) {
            builder.prefixes.forEach(namespaceMapping -> this.namespaces.addNamespace(namespaceMapping.prefix(), namespaceMapping.namespace()));
        }
        this.dataAccess = Objects.requireNonNullElseGet(builder.dataAccess, InMemoryModelDataAccess::new).initialize(this.namespaces, this.messages);
        this.ontologyDataset = new OntologySet(builder.id, this.useDefaultPrefix, builder.ontologies, this.dataAccess, this.messages);
    }

    private static Map<String, String> buildDataTypeMapping(String stringMode) {
        if (stringMode == null || stringMode.equals("string")) {
            return new LinkedHashMap<String, String>(Constants.DATATYPES);
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(Constants.DATATYPES);
        map.put("rdfs:Literal", stringMode);
        map.put("rdf:PlainLiteral", stringMode);
        map.put("schema:Text", stringMode);
        map.put("rdf:langString", "langString");
        return map;
    }

    public List<String> retrieveGraphQlModels() throws ConversionException {
        if (this.ontology == null) {
            this.ontology = this.ontologyDataset.loadOntologies(this.namespaces);
        }
        return this.ontology.getGraphqlModelIds().stream().map(Value::stringValue).toList();
    }

    public List<String> retrieveOntologies() throws ConversionException {
        if (this.ontology == null) {
            this.ontology = this.ontologyDataset.loadOntologies(this.namespaces);
        }
        return this.ontology.getOntologyIds().stream().map(Value::stringValue).toList();
    }

    public Result convert() throws ConversionException {
        this.ontology = this.ontologyDataset.loadOntologies(this.namespaces);
        this.config = this.dataAccess.getConfig();
        this.classes = new Classes(this.ontology, this.namespaces, this.dataAccess, this.messages);
        this.classes.collect();
        this.classes.extractAdditionalClassData();
        this.addPreferredPrefixesFromClasses();
        this.properties = new Properties(this.ontology, this.namespaces, this.dataAccess, this.messages);
        this.properties.collect();
        this.extractAdditionalPropsData();
        this.addTypeNames();
        this.optimizePropertyNames();
        this.optimizePropertyRanges();
        this.optimizeUnionRanges();
        this.optimizePropertyCardinality();
        this.optimizeInverseOfProperties();
        this.optimizeInverseAliasProperties();
        this.optimizeClassHierarchy();
        this.superClassRangeSwap();
        this.addRangeChecks();
        this.optimizePrefixes();
        this.detectVocabularyPrefixIfNeeded();
        this.processFederatedServiceDefinitions();
        this.permissions = new Permissions(this.ontology, this.dataAccess, this.messages);
        this.permissions.collect();
        this.removeInvalidRbacRules();
        Object soml = this.buildSoml();
        String somlAsString = Utils.singleLinedEmptyBlocks(YAML.dump(soml));
        return new Result(somlAsString, this.messages);
    }

    private void detectVocabularyPrefixIfNeeded() {
        if (this.useDefaultPrefix || !this.namespaces.isNoVocabularyOption()) {
            return;
        }
        Function<Classes.Class, Stream> prefixCollector = type -> Stream.concat(Stream.of(type.getName()), type.resolveProperties().keySet().stream()).map(Utils::extractPrefix);
        Map prefixesRank = this.classes.getAllowedClasses().stream().flatMap(prefixCollector).filter(Objects::nonNull).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        prefixesRank.entrySet().stream().max(Map.Entry.comparingByValue()).filter(entry -> this.namespaces.getPrefixes().containsKey(entry.getKey())).map(Map.Entry::getKey).ifPresent(vocabPrefix -> {
            this.warn("voc.usingNoVoc", vocabPrefix, this.namespaces.getPrefixes().get(vocabPrefix));
            Optional oldVocabPrefix = this.namespaces.getSpecialPrefixes().getVocabPrefix();
            oldVocabPrefix.ifPresent(this.ontologyDataset.getExplicitPrefixes()::remove);
            this.namespaces.setVocabularyPrefix((String)vocabPrefix);
            UnaryOperator nameConverter = name -> StringUtils.removeStart((String)name, (String)(vocabPrefix + ":"));
            this.renameTypesAndProperties(nameConverter);
            oldVocabPrefix.ifPresent(oldVocab -> this.renameTypesAndProperties(name -> StringUtils.replaceOnce((String)name, (String)(oldVocab + ":"), (String)(vocabPrefix + ":"))));
        });
    }

    private void renameTypesAndProperties(UnaryOperator<String> nameConverter) {
        this.classes.renameAllClasses(type -> (String)nameConverter.apply(type.getName()));
        this.classes.getAllowedClasses().forEach(type -> this.renameClassProperties((Classes.Class)type, nameConverter));
    }

    private void renameClassProperties(Classes.Class type, UnaryOperator<String> nameConverter) {
        this.renameTypeName(type, nameConverter);
        type.renameAllProperties(prop -> this.renamePropertiesAndFields((Properties.Property)prop, nameConverter));
    }

    private String renamePropertiesAndFields(Properties.Property prop, UnaryOperator<String> nameConverter) {
        this.renameObjectPropertyRange(prop);
        this.renameInverseOfProperty(prop, nameConverter);
        return (String)nameConverter.apply(prop.getName());
    }

    private void renameTypeName(Classes.Class clazz, UnaryOperator<String> nameConverter) {
        Object typeName = clazz.getTypeName();
        if (Objects.nonNull(typeName)) {
            String newValue = this.namespaces.modelSafeProperty((String)nameConverter.apply(typeName.toString()));
            clazz.setTypeName(newValue);
        }
    }

    private void renameObjectPropertyRange(Properties.Property prop) {
        Classes.Class rangeClass;
        if (prop.isObjectPropertyKind() && Objects.nonNull(rangeClass = this.classes.get(prop.getRangeClass()))) {
            String newValue = this.namespaces.modelSafeType(rangeClass.getName(), (Resource)rangeClass.getIri());
            prop.setRange(newValue);
        }
    }

    private void renameInverseOfProperty(Properties.Property prop, UnaryOperator<String> nameConverter) {
        String inverseAlias = prop.getInverseAlias();
        if (Objects.nonNull(inverseAlias)) {
            String newValue = this.namespaces.modelSafeProperty((String)nameConverter.apply(inverseAlias));
            prop.setInverseAlias(newValue);
        }
    }

    private void processFederatedServiceDefinitions() {
        LinkedHashMap<String, String> services = new LinkedHashMap<String, String>();
        LinkedHashMap serviceCounter = new LinkedHashMap();
        for (Classes.Class type : this.classes.getAllowedClasses()) {
            if (type.getSparqlFederatedService() == null) continue;
            Value service = type.getSparqlFederatedService();
            if (type.getServiceName() != null) {
                services.put(type.getServiceName(), service.stringValue());
                continue;
            }
            if (service.isLiteral()) {
                type.setServiceName(service.stringValue());
                continue;
            }
            if (!service.isIRI()) continue;
            IRI serviceIRI = (IRI)service;
            if (!services.containsKey(serviceIRI.getLocalName())) {
                services.put(serviceIRI.getLocalName(), serviceIRI.stringValue());
                type.setServiceName(serviceIRI.getLocalName());
                continue;
            }
            if (serviceIRI.stringValue().equals(services.get(serviceIRI.getLocalName()))) {
                type.setServiceName(serviceIRI.getLocalName());
                continue;
            }
            services.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(serviceIRI.stringValue())).map(Map.Entry::getKey).findFirst().ifPresentOrElse(type::setServiceName, () -> {
                String newServiceKey = serviceIRI.getLocalName() + "_" + serviceCounter.computeIfAbsent(serviceIRI.getLocalName(), k -> new AtomicInteger()).incrementAndGet();
                services.put(newServiceKey, serviceIRI.stringValue());
                type.setServiceName(newServiceKey);
            });
        }
        if (!services.isEmpty()) {
            this.federatedServices = services;
        }
    }

    private void optimizeInverseAliasProperties() {
        for (Classes.Class allowedClass : this.classes.getAllowedClasses()) {
            for (Properties.Property property : allowedClass.resolveProperties().values()) {
                Classes.Class inverseClass;
                if (property.getInverseAlias() == null || (inverseClass = this.classes.get(property.getRangeClass())) == null || inverseClass.containsPropertyByName(property.getInverseAlias())) continue;
                IRI predicateIri = this.namespaces.iri(property.getInverseAlias());
                inverseClass.resolveProperties().values().stream().filter(prop -> predicateIri.equals((Object)prop.getRdfPropIri()) && Objects.equals(prop.getRangeClass(), allowedClass.getIri())).findFirst().ifPresent(prop -> property.setInverseAlias(prop.getName()));
            }
        }
    }

    private void optimizeClassHierarchy() {
        List<Classes.Class> toRemove = this.classes.values().stream().filter(this::isTypeRemovable).toList();
        for (Classes.Class removedType : toRemove) {
            String toReplace = removedType.getName();
            Classes.Class replaceWithType = removedType.getChildClass();
            String replacedWith = replaceWithType.getName();
            for (Classes.Class type : this.classes.values()) {
                if (type.getIri().equals((Object)removedType.getIri()) || type.getIri().equals((Object)replaceWithType.getIri())) continue;
                Owl2SomlConverter.findAndReplace(type.getParents(), parent -> parent.getName().equals(toReplace), replaceWithType);
                Owl2SomlConverter.findAndReplace(type.getParentIris(), Predicate.isEqual(removedType.getIri()), replaceWithType.getIri());
                if (!type.isUnion()) continue;
                Owl2SomlConverter.findAndReplace(type.getUnionOf(), member -> member.getName().equals(toReplace), replaceWithType);
            }
            this.properties.values().stream().filter(ref -> Objects.equals(toReplace, ref.getRange())).forEach(ref -> ref.setRange(replacedWith));
            this.properties.values().stream().flatMap(ref -> ref.getReferences().values().stream().flatMap(Collection::stream)).filter(ref -> Objects.equals(toReplace, ref.getRange())).forEach(ref -> ref.setRange(replacedWith));
            replaceWithType.removeParent(removedType);
            Owl2SomlConverter.findAndRemove(replaceWithType.getParentIris(), Predicate.isEqual(removedType.getIri()));
            replaceWithType.setSuperClass(null);
            if (!removedType.getChildren().isEmpty()) {
                replaceWithType.setAbstract();
                this.classes.createAbstractClassObject(replaceWithType);
            }
            removedType.setChildClass(null);
            removedType.setHidden();
        }
    }

    private boolean isTypeRemovable(Classes.Class current) {
        return current.isAbstract() && current.getName().endsWith("Interface") && current.getChildClass() != null && CollectionsUtil.isNullOrEmpty(current.resolveProperties().values()) && CollectionsUtil.isNullOrEmpty(current.getChildClass().resolveProperties().values()) && current.getChildren().stream().allMatch(child -> child.getChildren().isEmpty());
    }

    private static <E> boolean findAndReplace(Collection<E> collection, Predicate<E> filter, E newValue) {
        LinkedList<E> copy;
        if (collection instanceof List) {
            ListIterator<E> it = ((List)collection).listIterator();
            while (it.hasNext()) {
                if (!filter.test(it.next())) continue;
                it.set(newValue);
                return true;
            }
        } else if (!collection.isEmpty() && Owl2SomlConverter.findAndReplace(copy = new LinkedList<E>(collection), filter, newValue)) {
            collection.clear();
            collection.addAll(copy);
            return true;
        }
        return false;
    }

    private static <E> void findAndRemove(Collection<E> list, Predicate<E> filter) {
        if (list.stream().anyMatch(filter)) {
            Iterator<E> it = list.iterator();
            while (it.hasNext()) {
                if (!filter.test(it.next())) continue;
                it.remove();
                break;
            }
        }
    }

    private void addRangeChecks() {
        for (Classes.Class type : this.classes.values()) {
            Map<String, List<Properties.Property>> map = type.resolveProperties().values().stream().filter(prop -> prop.getRdfProp() != null).collect(Collectors.groupingBy(Properties.Property::getRdfProp));
            map.values().stream().filter(list -> list.size() > 1).flatMap(Collection::stream).filter(Properties.Property::isObjectPropertyKind).filter(Predicate.not(Properties.Property::isRangeIriOrString)).forEach(Properties.Property::setForceRangeCheck);
        }
    }

    private void superClassRangeSwap() {
        for (Classes.Class type : this.classes.values()) {
            for (Properties.Property property : type.resolveProperties().values()) {
                Classes.Class superClass;
                String rangeName = property.getRange();
                Classes.Class rangeClass = rangeName != null ? this.classes.get(rangeName) : null;
                if (rangeClass == null || (superClass = rangeClass.getSuperClass()) == null) continue;
                property.setRange(superClass.getName(), superClass.getIri());
            }
        }
    }

    private void optimizeUnionRanges() {
        for (Properties.Property property : this.properties.values()) {
            property.getReferences().values().stream().flatMap(Collection::stream).filter(ref -> ref.getRange() != null || property.getRange() != null).filter(ref -> {
                Classes.Class range = this.classes.get(Objects.requireNonNullElse(ref.getRange(), property.getRange()));
                if (range == null) {
                    return false;
                }
                return range.isUnion();
            }).forEach(ref -> this.tryOptimizePropertyUnion((Properties.Property)ref, property));
        }
    }

    private void tryOptimizePropertyUnion(Properties.Property reference, Properties.Property property) {
        Classes.Class parent;
        IRI commonParent;
        Classes.Class union = this.classes.get(Objects.requireNonNullElse(reference.getRange(), property.getRange()));
        if (union == null || !union.isUnion()) {
            return;
        }
        List<Classes.Class> unionOf = union.getUnionOf();
        String name = property.getName();
        if (unionOf.stream().allMatch(type -> type.containsPropertyByName(name)) && (commonParent = this.getFirstDefinedClass(unionOf.stream().map(Classes.Class::getIri).toList())) != null && Owl2SomlConverter.isCommonParent(unionOf, commonParent) && (parent = this.classes.get(commonParent)).containsPropertyByName(name)) {
            reference.setRange(parent.getName(), parent.getIri());
        }
    }

    private void optimizePropertyNames() {
        for (Properties.Property property : this.properties.values()) {
            Set<String> names;
            if (property.getReferences().isEmpty() || (names = property.getReferences().values().stream().flatMap(Collection::stream).map(Properties.Property::getName).filter(Objects::nonNull).collect(Collectors.toSet())).size() == 1 && names.contains(property.getName())) continue;
            this.optimizePropertyNames(property, names);
        }
    }

    private void optimizePropertyNames(Properties.Property property, Set<String> names) {
        if (names.size() > 1 && names.contains(property.getName())) {
            property.getReferences().values().stream().flatMap(Collection::stream).filter(ref -> !Objects.equals(ref.getName(), property.getName())).forEach(ref -> ref.mergePropertyFrom(property));
        } else if (!names.contains(property.getName())) {
            if (names.size() == 1) {
                property.setName(names.iterator().next());
            } else if (names.size() > 1) {
                property.getReferences().values().stream().flatMap(Collection::stream).forEach(ref -> ref.mergePropertyFrom(property));
                property.setHidden();
            }
        }
    }

    private void optimizePrefixes() {
        LinkedHashSet usedPrefixes = new LinkedHashSet();
        this.namespaces.getSpecialPrefixes().getVocabPrefix().ifPresent(usedPrefixes::add);
        this.namespaces.getSpecialPrefixes().getShapePrefix().ifPresent(usedPrefixes::add);
        for (Classes.Class allowedClass : this.classes.getAllowedClasses()) {
            Utils.addIfNotNull(usedPrefixes, Owl2SomlConverter.readPrefix(allowedClass.getName()));
            allowedClass.getTypes().forEach(type -> Utils.addIfNotNull(usedPrefixes, Owl2SomlConverter.readPrefix(type)));
            Utils.addIfNotNull(usedPrefixes, allowedClass.getPrefix());
            for (Properties.Property prop : allowedClass.resolveProperties().values()) {
                Properties.Property property = prop.getPrimary();
                Utils.addIfNotNull(usedPrefixes, Owl2SomlConverter.readPrefix(property.getName()));
                Utils.addIfNotNull(usedPrefixes, Owl2SomlConverter.readPrefix(property.getRange()));
                Utils.addIfNotNull(usedPrefixes, Owl2SomlConverter.readPrefix(property.getRdfProp()));
                if (property.getInverseOf() == null) continue;
                Utils.addIfNotNull(usedPrefixes, Owl2SomlConverter.readPrefix(property.getInverseOf().getName()));
            }
        }
        this.ontologyDataset.getExplicitPrefixes().keySet().removeIf(prefix -> !usedPrefixes.contains(prefix));
        Prefixes prefixes = this.namespaces.getPrefixes();
        usedPrefixes.stream().filter(Predicate.not(this.ontologyDataset.getExplicitPrefixes()::containsKey)).filter(arg_0 -> prefixes.containsKey(arg_0)).forEach(missingPrefix -> this.ontologyDataset.getExplicitPrefixes().put((String)missingPrefix, (String)prefixes.get(missingPrefix)));
    }

    private static String readPrefix(String value) {
        if (value == null) {
            return null;
        }
        int index = value.indexOf(58);
        if (index > 0) {
            return value.substring(0, index);
        }
        return null;
    }

    private void removeInvalidRbacRules() {
        LinkedHashSet rolesForRemoval = new LinkedHashSet();
        Map<String, Role> roles = this.permissions.getRbacRoles();
        roles.values().forEach(role -> {
            role.setActions(this.removeInvalidActions(role.getActions()));
            role.setNotActions(this.removeInvalidActions(role.getNotActions()));
            if (role.getActions().isEmpty() && role.getNotActions().isEmpty()) {
                rolesForRemoval.add(role.getName());
            }
        });
        rolesForRemoval.forEach(roles::remove);
        if (!rolesForRemoval.isEmpty()) {
            this.warn("roles.removed", String.join((CharSequence)", ", rolesForRemoval));
        }
    }

    private List<RoleAction> removeInvalidActions(List<RoleAction> actions) {
        ArrayList<RoleAction> result = new ArrayList<RoleAction>();
        actions.forEach(roleAction -> {
            IRI object = roleAction.getObject();
            IRI property = roleAction.getProperty();
            IRI action = roleAction.getAction();
            Classes.Class clazz = this.classes.get(object);
            if (this.isValidObject(object, clazz) && this.isValidProperty(property, clazz) && this.isValidAction(action)) {
                roleAction.setSomlRepresentation(this.createSomlRepresentation((RoleAction)roleAction));
                result.add((RoleAction)roleAction);
            }
        });
        return result;
    }

    private boolean isValidObject(IRI object, Classes.Class clazz) {
        return SomlOntology.ALL.equals((Object)object) || SomlOntology.NAMEABLE.equals((Object)object) || clazz != null;
    }

    private boolean isValidProperty(IRI property, Classes.Class clazz) {
        if (SomlOntology.ALL.equals((Object)property) || SomlOntology.ID.equals((Object)property) || SomlOntology.TYPE.equals((Object)property) || SomlOntology.NAME_PROP.equals((Object)property)) {
            return true;
        }
        Map<IRI, Properties.Property> clazzProperties = clazz.resolvePropertiesByIri();
        Properties.Property clazzProp = clazzProperties.get(property);
        return Objects.nonNull(clazzProp);
    }

    private boolean isValidAction(IRI action) {
        return SomlOntology.ALL.equals((Object)action) || SomlOntology.READ.equals((Object)action) || SomlOntology.WRITE.equals((Object)action) || SomlOntology.DELETE.equals((Object)action);
    }

    private String createSomlRepresentation(RoleAction roleAction) {
        String propertyString;
        IRI object = roleAction.getObject();
        String objectString = SomlOntology.ALL.equals((Object)object) ? "*" : (SomlOntology.NAMEABLE.equals((Object)object) ? SomlOntology.NAMEABLE.getLocalName() : this.classes.get(object).getName());
        IRI property = roleAction.getProperty();
        if (SomlOntology.ALL.equals((Object)property)) {
            propertyString = "*";
        } else if (SomlOntology.ID.equals((Object)property)) {
            propertyString = SomlOntology.ID.getLocalName();
        } else if (SomlOntology.TYPE.equals((Object)property)) {
            propertyString = SomlOntology.TYPE.getLocalName();
        } else if (SomlOntology.NAME_PROP.equals((Object)property)) {
            propertyString = SomlOntology.NAME_PROP.getLocalName();
        } else {
            Map<IRI, Properties.Property> objectProps = this.classes.get(object).resolvePropertiesByIri();
            propertyString = objectProps.get(property).getName();
        }
        IRI action = roleAction.getAction();
        String actionString = SomlOntology.ALL.equals((Object)action) ? "*" : roleAction.getAction().getLocalName();
        String filter = roleAction.getFilter();
        String result = objectString + "/" + propertyString + "/" + actionString;
        if (Objects.nonNull(filter)) {
            result = result + "/" + filter;
        }
        return result;
    }

    private void optimizeInverseOfProperties() {
        for (Classes.Class allowedClass : this.classes.getAllowedClasses()) {
            for (Properties.Property property : allowedClass.resolveProperties().values()) {
                this.optimizeInverseOf(allowedClass, property);
            }
        }
        this.cleanUpInvalidInverseOf();
    }

    private void optimizeInverseOf(Classes.Class allowedClass, Properties.Property property) {
        Classes.Class rangeType;
        Properties.Property primary = property.getPrimary();
        Properties.Property inverseOf = primary.getInverseOf();
        if (inverseOf == null || property.getInverseAlias() != null) {
            return;
        }
        if (inverseOf.getPrimary().getReferences().isEmpty()) {
            primary.setInverseOf(null);
            this.warnRemovedInverseOf(primary, inverseOf);
            return;
        }
        if (primary.isRangeIriOrString() && property.getRange() != null && primary.getReferences().values().stream().flatMap(Collection::stream).map(Properties.Property::getRange).distinct().count() == 1L) {
            primary.setRange(property.getRange(), property.getRangeClass());
        }
        if (!primary.isRangeIriOrString() && (rangeType = this.classes.get(primary.getRange())) != null && !rangeType.containsPropertyByName(inverseOf.getName()) && this.properties.contains(inverseOf.getIri())) {
            rangeType.addProperty(inverseOf.getPrimary().addReference(rangeType.getIri()));
        }
        if (inverseOf.getRange() != null && !inverseOf.isRangeIriOrString()) {
            Classes.Class inverse = this.classes.get(inverseOf.getRange());
            if (inverse != null && !this.classes.isTypeCompatibleWith(inverse, allowedClass.getName())) {
                this.removeInvalidInverseOf(allowedClass, primary, inverseOf);
                this.warnRemovedInverseOf(primary, inverseOf);
                primary.setInverseOf(null);
                return;
            }
        } else if (this.isInverseRangeSingleType(allowedClass, inverseOf)) {
            inverseOf.setRange(allowedClass.getName());
        }
        this.optimizeInverseOfProperty(allowedClass, property);
    }

    private boolean isInverseRangeSingleType(Classes.Class allowedClass, Properties.Property inverseOf) {
        return inverseOf.getPrimary().getReferences().values().stream().allMatch(props -> props.stream().anyMatch(prop -> this.classes.isTypeCompatibleWith(allowedClass, prop.getRange()) || this.classes.isTypeCompatibleWith(allowedClass, prop.getPrimary().getRange())));
    }

    private void removeInvalidInverseOf(Classes.Class allowedClass, Properties.Property primary, Properties.Property inverseOf) {
        Map<IRI, List<Properties.Property>> references = primary.getReferences();
        if (references.size() > 1) {
            references.entrySet().stream().filter(entry -> !((IRI)entry.getKey()).equals((Object)allowedClass.getIri()) && !allowedClass.hasShape((IRI)entry.getKey())).forEach(entry -> ((List)entry.getValue()).forEach(prop -> {
                Classes.Class rangeType = this.classes.get(Objects.toString(prop.getRange(), primary.getRange()));
                if (rangeType != null && !rangeType.containsPropertyByName(inverseOf.getName())) {
                    if (this.config.canCleanInvalidInverseOf()) {
                        this.warnRemovedInverseOf((Properties.Property)prop, inverseOf);
                    } else {
                        this.createInverseAliasIfNeeded((Properties.Property)prop, inverseOf);
                    }
                } else if (prop.getInverseOf() == null) {
                    prop.setInverseOf(inverseOf);
                }
            }));
        }
    }

    private void optimizeInverseOfProperty(Classes.Class allowedClass, Properties.Property property) {
        Properties.Property primary = property.getPrimary();
        Properties.Property inverseOf = primary.getInverseOf().getPrimary();
        if (inverseOf.isRangeIriOrString() && primary.getReferences().size() == 1) {
            inverseOf.setRange(allowedClass.getName(), allowedClass.getIri());
        }
        Classes.Class rangeClass = null;
        if (primary.getRange() != null) {
            rangeClass = this.classes.get(primary.getRange());
        }
        if (rangeClass != null && rangeClass.isShaclShape() && !rangeClass.resolveProperties().containsKey(inverseOf.getName())) {
            property.setInverseOf(null);
            primary.setInverseOf(null);
            this.warnRemovedInverseOf(primary, inverseOf);
        }
        if (rangeClass == null) {
            primary.setInverseOf(null);
            primary.getReferences().values().stream().flatMap(Collection::stream).forEach(ref -> this.createInverseAliasIfNeeded((Properties.Property)ref, inverseOf));
            if (inverseOf.getRange() != null && this.classes.get(inverseOf.getRange()) == null) {
                inverseOf.getPrimary().getReferences().values().stream().flatMap(Collection::stream).forEach(ref -> this.createInverseAliasIfNeeded((Properties.Property)ref, primary));
            }
        }
        if (inverseOf.isRangeIriOrString() && primary.getReferences().size() > 1) {
            if (this.config.canUseUnions()) {
                List<Classes.Class> domains = primary.getReferences().values().stream().flatMap(Collection::stream).map(prop -> prop.getDomain().getName()).distinct().map(this.classes::get).toList();
                Classes.Class union = this.classes.getOrCreateUnionOf(domains).orElseThrow();
                inverseOf.setRange(union.getName(), union.getIri());
                return;
            }
            if (this.config.canCleanInvalidInverseOf()) {
                primary.setInverseOf(null);
                inverseOf.setInverseOf(null);
                this.warnRemovedInverseOf(primary, inverseOf);
                return;
            }
            inverseOf.setRange(allowedClass.getName(), allowedClass.getIri());
        }
    }

    private void createInverseAliasIfNeeded(Properties.Property ref, Properties.Property inverseOf) {
        if (ref.getInverseAlias() != null || ref.getInverseOf() != null) {
            return;
        }
        Optional<Classes.Class> rangeTypeOpt = Stream.of(ref.getRange(), ref.getPrimary().getRange()).filter(Objects::nonNull).map(this.classes::get).filter(Objects::nonNull).findFirst();
        rangeTypeOpt.filter(rangeType -> !rangeType.containsPropertyByName(inverseOf.getName())).ifPresent(rangeType -> {
            Properties.Property inverseRef = inverseOf.getPrimary().addReference(rangeType.getIri());
            inverseRef.setInverseOf(null);
            inverseRef.setInverseAlias(ref.getName());
            inverseRef.setRange(ref.getDomain().getName(), ref.getDomain().getIri());
            rangeType.addProperty(inverseRef);
        });
        if (rangeTypeOpt.isEmpty()) {
            ref.setInverseOf(inverseOf);
        }
    }

    private void cleanUpInvalidInverseOf() {
        if (!this.config.canCleanInvalidInverseOf()) {
            return;
        }
        for (Classes.Class allowedClass : this.classes.getAllowedClasses()) {
            for (Properties.Property property : allowedClass.resolveProperties().values()) {
                this.cleanUpInvalidInverseOfInt(allowedClass, property);
            }
        }
    }

    private void cleanUpInvalidInverseOfInt(Classes.Class allowedClass, Properties.Property property) {
        Properties.Property inverseOf = property.getInverseOf();
        if (inverseOf == null) {
            inverseOf = property.getPrimary().getInverseOf();
        }
        if (inverseOf == null) {
            Classes.Class rangeType;
            if (property.getInverseAlias() != null && (rangeType = this.classes.get(property.getRange())) != null) {
                inverseOf = rangeType.resolveProperties().get(property.getInverseAlias());
            }
            if (inverseOf == null) {
                return;
            }
        }
        List<Classes.Class> domains = Owl2SomlConverter.getUnverseOfDomain(inverseOf);
        String primaryInverseRange = inverseOf.getPrimary().getRange();
        Classes.Class inverseRangeType = Optional.ofNullable(this.classes.get(inverseOf.getRange())).orElseGet(() -> this.classes.get(primaryInverseRange));
        boolean notCompatible = inverseRangeType == null || !this.classes.isTypeCompatibleWith(inverseRangeType, allowedClass.getName());
        boolean badDomain = domains.stream().noneMatch(domain -> this.classes.isTypeCompatibleWith((Classes.Class)domain, property.getActualRange()));
        if (notCompatible || badDomain) {
            this.removeInverseRelationsInt(property, inverseOf);
        }
    }

    private void removeInverseRelationsInt(Properties.Property property, Properties.Property inverseOf) {
        if (property.getInverseAlias() != null) {
            this.warnRemovedInverseAlias(property, inverseOf);
            property.setInverseAlias(null);
        }
        if (property.getInverseOf() != null) {
            property.setInverseOf(null);
            inverseOf.setInverseOf(null);
            this.warnRemovedInverseOf(property, inverseOf);
        }
    }

    @NotNull
    private static List<Classes.Class> getUnverseOfDomain(Properties.Property inverseOf) {
        List<Classes.Class> domains = inverseOf.getDomain() == null ? inverseOf.getReferences().values().stream().flatMap(Collection::stream).map(Properties.Property::getDomain).filter(Objects::nonNull).distinct().toList() : List.of(inverseOf.getDomain());
        return domains;
    }

    private void warnRemovedInverseOf(Properties.Property primary, Properties.Property inverseOf) {
        this.warn("property.inverseOf.removed", primary.getName(), inverseOf.getName(), primary.getRange());
    }

    private void warnRemovedInverseAlias(Properties.Property primary, Properties.Property inverseOf) {
        this.warn("property.inverseAlias.removed", primary.getDomain().getName(), primary.getName(), primary.getRange(), inverseOf.getName(), inverseOf.getRange());
    }

    private void addPreferredPrefixesFromClasses() {
        Map<String, String> explicitPrefixes = this.ontologyDataset.getExplicitPrefixes();
        this.classes.values().stream().filter(type -> type.getPrefix() != null).forEach(type -> type.getPreferredNamespace().ifPresent(namespace -> {
            String currentNamespace = (String)explicitPrefixes.get(type.getPrefix());
            if (currentNamespace == null) {
                explicitPrefixes.put(type.getPrefix(), (String)namespace);
            } else if (!currentNamespace.equals(namespace)) {
                this.messages.add(Message.warning("different.prefix.definitions", type.getName(), type.getPrefix(), namespace, currentNamespace));
            }
        }));
    }

    private void optimizePropertyCardinality() {
        this.properties.values().forEach(this::optimizePropertyCardinality);
    }

    private void optimizePropertyCardinality(Properties.Property property) {
        Map<IRI, List<Properties.Property>> references = property.getReferences();
        if (references.size() <= 1) {
            return;
        }
        if (references.values().stream().flatMap(Collection::stream).filter(ref -> ref != property).map(Properties.Property::getMax).distinct().count() <= 1L) {
            return;
        }
        List<Properties.Property> referenceCopy = references.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        referenceCopy.removeIf(prop -> !prop.getDomain().isAbstract() && prop.getDomain().getParents().isEmpty() && prop.getDomain().getSuperClass() == null);
        if (referenceCopy.isEmpty() || referenceCopy.size() == 1) {
            return;
        }
        if ("1".equals(Objects.toString(property.getMax(), "inf"))) {
            return;
        }
        this.optimizePropertyCardinality(property, referenceCopy);
    }

    private void optimizePropertyCardinality(Properties.Property property, List<Properties.Property> referenceCopy) {
        Map groupByParent = referenceCopy.stream().flatMap(prop -> {
            Stream.Builder<Classes.Class> builder = Stream.builder();
            if (prop.getDomain().getSuperClass() != null) {
                builder.add(prop.getDomain().getSuperClass());
            }
            if (!prop.getDomain().getParents().isEmpty()) {
                prop.getDomain().getParents().forEach(builder::add);
            }
            return builder.build().map(parent -> Pair.of((Object)parent, (Object)prop));
        }).collect(Collectors.groupingBy(Pair::getKey, Collectors.mapping(Pair::getValue, Collectors.toList())));
        Integer one = 1;
        groupByParent.forEach((parent, refs) -> {
            Set maxCardinality;
            Properties.Property parentProp = parent.resolveProperties().get(property.getName());
            if (parentProp != null && parentProp.getMax() == null && (maxCardinality = refs.stream().map(Properties.Property::getMax).collect(Collectors.toSet())).size() == 1 && maxCardinality.contains(one)) {
                parentProp.setMax(1);
                this.warn("property.cardinality.changeToSingle", parent.getName(), parentProp.getName());
            }
        });
    }

    private void optimizePropertyRanges() {
        this.properties.values().forEach(this::optimizePropertyRange);
    }

    private void optimizePropertyRange(Properties.Property property) {
        Map<IRI, List<Properties.Property>> references = property.getReferences();
        if (references.size() == 1) {
            return;
        }
        if (references.values().stream().flatMap(Collection::stream).anyMatch(ref -> ref != property) && property.isObjectPropertyKind()) {
            Map<IRI, List<Properties.Property>> groupByRangeTypeHierarchy = references.values().stream().flatMap(Collection::stream).collect(Collectors.groupingBy(ref -> ref.getDomain().getRoot().filter(domain -> domain.containsPropertyByName(ref.getName())).findFirst().or(() -> ref.getDomain().getRoot().findFirst()).map(Classes.Class::getIri).orElseThrow()));
            groupByRangeTypeHierarchy.values().forEach(propertiesSubset -> {
                LinkedHashSet ranges = new LinkedHashSet();
                Utils.addIfNotNull(ranges, property.getRange());
                propertiesSubset.forEach(ref -> Utils.addIfNotNull(ranges, ref.getRange()));
                if (ranges.isEmpty() || ranges.size() == 1 || ranges.stream().allMatch(Predicate.isEqual("iri"))) {
                    return;
                }
                List<Classes.Class> rangeList = ranges.stream().filter(range -> !"iri".equals(range)).map(range -> {
                    Classes.Class typeInst = this.classes.get(this.namespaces.iri((String)range));
                    if (typeInst == null) {
                        return this.classes.get((String)range);
                    }
                    return typeInst;
                }).filter(Objects::nonNull).toList();
                if (rangeList.isEmpty()) {
                    this.warn("property.conflicting.ranges", property.getName(), String.join((CharSequence)", ", ranges));
                    return;
                }
                this.optimizeRanges((List<Properties.Property>)propertiesSubset, rangeList);
            });
        }
    }

    private void optimizeRanges(List<Properties.Property> propertiesSubset, List<Classes.Class> rangeList) {
        Classes.Class superClass = this.pickCommonSuperClass(rangeList);
        assert (superClass != null) : "Could not resolve super class";
        IRI superType = superClass.getIri();
        if (rangeList.stream().allMatch(range -> range.getIri().equals((Object)superType) || range.hasParent(superType))) {
            Classes.Class superTypeClass = this.classes.get(superType);
            String superTypeName = superTypeClass.getName();
            propertiesSubset.forEach(ref -> {
                if (ref.isProtected()) {
                    return;
                }
                if (ref.getRange() != null && !"iri".equals(ref.getRange())) {
                    Classes.Class rangeType = this.classes.get(this.namespaces.iri(ref.getRange()));
                    if (rangeType != null && !rangeType.hasParent(superType)) {
                        ref.setRange(superTypeName, superTypeClass.getIri());
                    }
                } else {
                    ref.setRange(superTypeName, superTypeClass.getIri());
                }
            });
        }
    }

    private Classes.Class pickCommonSuperClass(List<Classes.Class> rangeList) {
        Classes.Class commonParent;
        if (rangeList.isEmpty()) {
            return null;
        }
        Classes.Class superClass = null;
        LinkedHashSet<Classes.Class> rangesCopy = new LinkedHashSet<Classes.Class>(rangeList);
        for (Classes.Class type : rangesCopy) {
            if (type.isRoot()) {
                superClass = type;
                break;
            }
            if (superClass != null && !superClass.hasParent(type.getIri())) continue;
            superClass = type;
        }
        if ((commonParent = Owl2SomlConverter.checkForCommonParent(rangeList, Objects.requireNonNull(superClass))) == null) {
            return superClass;
        }
        return commonParent;
    }

    private static Classes.Class checkForCommonParent(Collection<Classes.Class> collection, Classes.Class potentialParent) {
        if (Owl2SomlConverter.isCommonParent(collection, potentialParent.getIri())) {
            return potentialParent;
        }
        if (!potentialParent.getParents().isEmpty()) {
            for (Classes.Class parent : potentialParent.getParents()) {
                Classes.Class check = Owl2SomlConverter.checkForCommonParent(collection, parent);
                if (check == null) continue;
                return check;
            }
            return null;
        }
        if (potentialParent.getSuperClass() != null) {
            return Owl2SomlConverter.checkForCommonParent(collection, potentialParent.getSuperClass());
        }
        Constants.LOGGER.warn("Could not find common parent for {}", collection);
        return potentialParent;
    }

    private static boolean isCommonParent(Collection<Classes.Class> collection, IRI potentialParent) {
        return collection.stream().allMatch(ref -> ref.getIri().equals((Object)potentialParent) || ref.hasParent(potentialParent));
    }

    private Object buildSoml() throws ConversionException {
        LinkedHashMap<String, Object> soml = new LinkedHashMap<String, Object>();
        String id = this.ontologyDataset.getId();
        soml.put("id", "/soml/" + (id != null ? id : (String)this.namespaces.getSpecialPrefixes().getVocabPrefix().orElseThrow(ConversionException.genericException())));
        if (this.label != null) {
            soml.put("label", this.label);
        }
        if (this.description != null) {
            soml.put("description", this.description);
        }
        this.namespaces.getSpecialPrefixes().getOntologyIri().ifPresent(ontIriStr -> {
            IRI ontologyIri = this.namespaces.iri((String)ontIriStr);
            Map<String, Object> metadata = this.dataAccess.readOntologyMetadata(ontologyIri);
            soml.putAll(metadata);
            if (this.label != null) {
                soml.put("label", this.label);
            }
        });
        Object configSection = this.buildConfigSection();
        if (configSection != null) {
            soml.put("config", configSection);
        }
        soml.put("prefixes", this.ontologyDataset.getExplicitPrefixes());
        soml.put("specialPrefixes", this.namespaces.getSpecialPrefixes());
        this.scalars.toSomlTypes(this.getUsedRanges()).ifPresent(types -> soml.put("types", types));
        Map<String, Object> props = this.properties.toSomlProps();
        if (!props.isEmpty()) {
            soml.put("properties", props);
        }
        soml.put("objects", this.classes.toSomlObjects());
        Map<String, Role> roles = this.permissions.getRbacRoles();
        if (!roles.isEmpty()) {
            soml.put("rbac", this.permissions.toSomlPermissions());
        }
        return soml;
    }

    private Set<String> getUsedRanges() {
        return Stream.concat(this.properties.values().stream().filter(prop -> prop.isUsed() && !prop.isHidden()), this.classes.getUsedProperties()).map(Properties.Property::getRange).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private Object buildConfigSection() throws ConversionException {
        LinkedHashMap<String, Object> configSection = new LinkedHashMap<String, Object>();
        Object langConfig = this.getLangConfig();
        if (langConfig != null) {
            configSection.put("lang", langConfig);
        }
        if (this.federatedServices != null) {
            configSection.put("sparqlFederatedServices", this.federatedServices);
        }
        if (configSection.isEmpty()) {
            return null;
        }
        return configSection;
    }

    private Object getLangConfig() throws ConversionException {
        String[] parts;
        if (StringUtils.isBlank((CharSequence)this.lang)) {
            return null;
        }
        if (!this.lang.contains(" ")) {
            return this.lang;
        }
        LinkedHashMap<String, String> langConfig = new LinkedHashMap<String, String>();
        for (String part : parts = this.lang.split(",\\s+")) {
            String[] keyValue = part.split(":\\s+");
            if (keyValue.length != 2) {
                throw new ConversionException("arguments.invalidLangSpec", this.lang);
            }
            if (!LANG_KEYS.contains(keyValue[0])) {
                throw new ConversionException("arguments.unknownLangKey", String.join((CharSequence)", ", LANG_KEYS));
            }
            langConfig.put(keyValue[0], keyValue[1]);
        }
        return langConfig;
    }

    private void extractAdditionalPropsData() throws ConversionException {
        Iterator<Properties.Property> it = this.properties.values().iterator();
        while (it.hasNext()) {
            if (this.buildPropObject(it.next())) continue;
            it.remove();
        }
        this.addPropsToClassesBasedOnOwlRestrictions();
        this.properties.setInverseOf();
        this.validateAllClassProperties();
    }

    private void addTypeNames() {
        this.classes.values().forEach(this::resolveTypeName);
    }

    private void resolveTypeName(Classes.Class clazz) {
        HashSet propertyNameRepresentations = new HashSet();
        TreeSet typeNameProperties = new TreeSet();
        Map<String, Properties.Property> propertyMap = clazz.resolveProperties();
        propertyMap.values().forEach(prop -> {
            propertyNameRepresentations.add(prop.getName());
            propertyNameRepresentations.add(prop.getRdfProp());
            if (prop.isTypeName()) {
                typeNameProperties.add(prop.getRdfProp());
            }
        });
        TreeSet classTypeNames = new TreeSet();
        clazz.getShapes().stream().map(obj -> this.transformTypeName(obj.getTypeName())).filter(Objects::nonNull).forEach(classTypeNames::add);
        LinkedHashSet validClassTypeNames = new LinkedHashSet();
        classTypeNames.stream().filter(propertyNameRepresentations::contains).forEach(validClassTypeNames::add);
        if (!validClassTypeNames.isEmpty()) {
            clazz.setTypeName(validClassTypeNames.iterator().next());
        } else if (!typeNameProperties.isEmpty()) {
            clazz.setTypeName(typeNameProperties.iterator().next());
        } else if (!classTypeNames.isEmpty()) {
            clazz.setTypeName(classTypeNames.iterator().next());
            this.warn("class.name.with.undefined.property", clazz.getName(), clazz.getTypeName());
        }
        classTypeNames.forEach(name -> {
            Properties.Property property = (Properties.Property)propertyMap.get(name);
            if (Objects.nonNull(property)) {
                typeNameProperties.remove(property.getRdfProp());
            }
        });
        Sets.SetView allTypeNames = Sets.union(classTypeNames, typeNameProperties);
        if (allTypeNames.size() > 1) {
            this.warn("class.with.multiple.names", clazz.getName(), String.join((CharSequence)", ", (Iterable<? extends CharSequence>)allTypeNames), clazz.getTypeName());
        }
    }

    private String transformTypeName(Object typeName) {
        Object object = typeName;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IRI.class, Literal.class}, (Object)object, n)) {
            case -1 -> null;
            case 0 -> {
                IRI anIri = (IRI)object;
                yield this.namespaces.shortIri(anIri.stringValue());
            }
            case 1 -> {
                Literal literal = (Literal)object;
                yield literal.getLabel();
            }
            default -> typeName.toString();
        };
    }

    private boolean buildPropObject(Properties.Property prop) throws ConversionException {
        if (this.findRangeAndKind(prop)) {
            this.assignPropsToClassesBasedOnPropertyDomain(prop);
            return true;
        }
        return false;
    }

    private void validateAllClassProperties() throws ConversionException {
        for (Classes.Class clazz : this.classes.values()) {
            for (Properties.Property prop : clazz.resolveProperties().values()) {
                prop.validate(this.messages);
            }
        }
    }

    private boolean findRangeAndKind(Properties.Property prop) throws ConversionException {
        boolean isObjectProp = this.isObjectProp(prop);
        if (isObjectProp && this.ontology.isProtectedProperty(prop)) {
            prop.setAsProtected();
            return true;
        }
        if (prop.getRange() != null) {
            return true;
        }
        List<IRI> rangeClasses = this.findRangeClasses(prop).collect(Collectors.toList());
        if (!rangeClasses.isEmpty() && this.ontology.hasGraphQlSchema()) {
            if (rangeClasses.stream().allMatch(this.classes::isPrivate)) {
                prop.setHidden();
                this.setDefaultRangeAndKind(prop, isObjectProp);
                return false;
            }
        }
        rangeClasses.removeIf(this.classes::isPrivate);
        if (!rangeClasses.isEmpty() && this.ontology.hasGraphQlSchema()) {
            rangeClasses.removeIf(range -> !Utils.isDatatype((Resource)range) && !this.isTypeAllowed((Value)range));
            if (rangeClasses.isEmpty()) {
                prop.setInverseOf(null);
            }
        }
        if (rangeClasses.isEmpty()) {
            this.setDefaultRangeAndKind(prop, isObjectProp);
            return true;
        }
        return this.resolveRangeFromMultipleRanges(prop, rangeClasses, isObjectProp);
    }

    private boolean resolveRangeFromMultipleRanges(Properties.Property prop, List<IRI> rangeClasses, boolean isObjectProp) throws ConversionException {
        String kind = null;
        String actualRange = null;
        IRI range = this.getFirstDefinedClass(rangeClasses);
        this.warnMultipleRanges(prop, rangeClasses, range);
        String rangeDataType = this.getDataTypeOfRange(prop, (Value)range);
        Classes.Class rangeClass = this.getClassOfRange((Value)range, rangeDataType);
        String rangeClassName = null;
        if (rangeDataType != null) {
            kind = LITERAL;
            actualRange = rangeDataType;
        } else if (rangeClass != null) {
            kind = "object";
            actualRange = rangeClass.getName();
            rangeClassName = rangeClass.getName();
        }
        boolean isDataProp = this.isDataProp(prop);
        this.validatePropertyProperties(prop, isObjectProp, isDataProp, rangeDataType, rangeClassName);
        if (actualRange == null) {
            this.setDefaultRangeAndKind(prop, isObjectProp);
        } else {
            prop.setKind(kind);
            prop.setRange(actualRange);
            if (rangeClass != null) {
                prop.setRangeClass(rangeClass.getIri());
            }
        }
        return true;
    }

    private void warnMultipleRanges(Properties.Property prop, List<IRI> rangeClasses, IRI range) {
        if (rangeClasses.size() > 1) {
            Object[] objectArray = new Object[3];
            objectArray[0] = prop.getName();
            objectArray[1] = rangeClasses.stream().map(this.classes::getTypeName).toList();
            objectArray[2] = this.namespaces.gqlName(range.stringValue());
            this.warn("property.range.ambiguous", objectArray);
        }
    }

    private Classes.Class getClassOfRange(Value range, String rangeDataType) {
        if (rangeDataType == null && range instanceof IRI) {
            IRI iriRange = (IRI)range;
            Classes.Class clazz = this.getOrCreteClass(iriRange);
            if (clazz.getSuperClass() != null) {
                clazz = clazz.getSuperClass();
            }
            return clazz;
        }
        return null;
    }

    private String getDataTypeOfRange(Properties.Property prop, Value range) {
        if (range instanceof IRI && this.config.getIgnoredTypes().contains(range)) {
            this.warn("property.datatype.invalid", prop.getName(), this.shortIri(range.stringValue()));
            return null;
        }
        return this.dataTypes.get(this.shortIri(range.stringValue()));
    }

    private boolean isDataProp(Properties.Property prop) {
        return this.dataAccess.isDataProperty(prop.getIri());
    }

    private boolean isObjectProp(Properties.Property prop) {
        if (prop.isObjectPropertyKind()) {
            return true;
        }
        return this.dataAccess.isObjectProperty(prop.getIri());
    }

    private void setDefaultRangeAndKind(Properties.Property prop, boolean isObjectProp) {
        if (isObjectProp) {
            prop.setKind("object");
            prop.setRange("iri");
        } else {
            prop.setKind(LITERAL);
            prop.setRange(this.stringMode);
        }
    }

    private void validatePropertyProperties(Properties.Property prop, boolean isObjectProp, boolean isDataProp, String rangeDataType, String rangeClass) throws ConversionException {
        if (isDataProp && isObjectProp) {
            return;
        }
        if (isObjectProp && rangeDataType != null && !rangeDataType.equals("iri")) {
            throw new ConversionException("objectProperty.range.invalid", prop.getShortIri(), rangeDataType);
        }
        if (isDataProp && rangeClass != null) {
            throw new ConversionException("datatypeProperty.range.invalid", prop.getShortIri(), rangeClass);
        }
    }

    private Stream<IRI> findRangeClasses(Properties.Property prop) {
        if (prop.isShaclProperty()) {
            if (prop.isNodeRange()) {
                return this.resolveNode(prop.getNodeRange(), prop);
            }
            if (prop.getOrDef().isValid() && this.config.canUseUnions()) {
                List<IRI> unionMembers = this.createUnionForPropertyRange(prop);
                if (unionMembers != null) {
                    return unionMembers.stream();
                }
            } else if (prop.getAndDef().isValid()) {
                return this.getOrCreateMultiInheritanceTypeForPropertyRange(prop);
            }
        }
        List<Value> rangeClasses = this.dataAccess.findRangeClasses(prop.getIri());
        rangeClasses.removeIf(val -> !(val instanceof IRI) || this.config.getIgnoredTypes().contains(val));
        rangeClasses.forEach(range -> {
            if (Utils.isDatatype((Resource)((IRI)range))) {
                prop.getOrDef().addDataType((IRI)range);
            } else {
                prop.getOrDef().addClass((IRI)range);
            }
        });
        return rangeClasses.stream().map(IRI.class::cast);
    }

    @NotNull
    private Stream<IRI> getOrCreateMultiInheritanceTypeForPropertyRange(Properties.Property prop) {
        this.warnUnsupportedObjectAndLiteralSupertype(prop);
        List<Classes.Class> ranges = this.collectClassRanges(prop, prop.getAndDef());
        if (ranges.size() > 1) {
            return Stream.of(this.classes.getOrCreateMultiType(ranges).orElseThrow().getIri());
        }
        if (!ranges.isEmpty()) {
            return ranges.stream().map(Classes.Class::getIri);
        }
        return Stream.of(new IRI[0]);
    }

    @Nullable
    private List<IRI> createUnionForPropertyRange(Properties.Property prop) {
        List<Classes.Class> ranges = this.collectClassRanges(prop, prop.getOrDef());
        if (ranges.size() > 1) {
            this.warnUnsupportedObjectAndLiteralUnion(prop);
            return new ArrayList<IRI>(List.of(this.classes.getOrCreateUnionOf(ranges).orElseThrow().getIri()));
        }
        if (!ranges.isEmpty()) {
            this.warnUnsupportedObjectAndLiteralUnion(prop);
            return ranges.stream().map(Classes.Class::getIri).toList();
        }
        if (!prop.getOrDef().getDataTypes().isEmpty()) {
            return new ArrayList<IRI>(prop.getOrDef().getDataTypes());
        }
        return null;
    }

    @NotNull
    private List<Classes.Class> collectClassRanges(Properties.Property prop, MultiTypeDef typeDef) {
        return Stream.concat(typeDef.getClasses().stream(), prop.getOrDef().getNodes().stream().flatMap(resource -> this.resolveNode((Resource)resource, prop))).sorted(Comparator.comparing(Value::stringValue)).filter(Predicate.not(this.config.getIgnoredTypes()::contains)).filter(this.classes::isTypeAllowed).map(this.classes::getOrCreteClass).toList();
    }

    private Stream<IRI> resolveNode(Resource resource, Properties.Property property) {
        Classes.Class node = null;
        if (resource.isBNode()) {
            node = this.classes.readAnonymousClass(resource);
        } else if (resource.isIRI()) {
            node = this.classes.get((IRI)resource);
        }
        if (node == null) {
            this.warnUnknownNode(property, resource);
            return Stream.of(new IRI[0]);
        }
        return node.resolveTarget().stream();
    }

    private void warnUnsupportedObjectAndLiteralUnion(Properties.Property prop) {
        if (!prop.getOrDef().getDataTypes().isEmpty()) {
            Object[] objectArray = new Object[3];
            objectArray[0] = prop.getOrDef().getClasses().stream().map(Value::stringValue).map(this.namespaces::shortIri).toList();
            objectArray[1] = prop.getOrDef().getDataTypes().stream().map(Value::stringValue).map(this.namespaces::shortIri).toList();
            objectArray[2] = prop.getName();
            this.messages.add(Message.warning("property.unsupported.unions", objectArray));
        }
    }

    private void warnUnsupportedObjectAndLiteralSupertype(Properties.Property prop) {
        if (!prop.getOrDef().getDataTypes().isEmpty()) {
            Object[] objectArray = new Object[3];
            objectArray[0] = prop.getOrDef().getClasses().stream().map(Value::stringValue).map(this.namespaces::shortIri).toList();
            objectArray[1] = prop.getOrDef().getDataTypes().stream().map(Value::stringValue).map(this.namespaces::shortIri).toList();
            objectArray[2] = prop.getName();
            this.messages.add(Message.warning("property.unsupported.supertype", objectArray));
        }
    }

    private void warnUnknownNode(Properties.Property prop, Resource resource) {
        this.messages.add(Message.warning("property.node.reference.undefined", prop.getName(), prop.getIri(), resource));
    }

    private IRI getFirstDefinedClass(List<IRI> rangeClasses) {
        Optional<IRI> firstRangeClass;
        ArrayList<IRI> list = new ArrayList<IRI>(rangeClasses);
        list.sort(Comparator.comparing(Value::stringValue));
        if (list.size() > 1) {
            if (list.stream().allMatch(this.classes::isValidClass)) {
                List<Classes.Class> ranges = list.stream().map(this.classes::get).toList();
                if (this.dataAccess.getConfig().canUseUnions()) {
                    return this.classes.getOrCreateUnionOf(ranges).orElseThrow().getIri();
                }
                Classes.Class superClass = this.pickCommonSuperClass(ranges);
                if (superClass != null && Owl2SomlConverter.isCommonParent(ranges, superClass.getIri())) {
                    return superClass.getIri();
                }
            }
        }
        if ((firstRangeClass = list.stream().filter(this.classes::isValidClass).findFirst()).isPresent()) {
            return firstRangeClass.get();
        }
        Map datatypeToValue = list.stream().map(rangeClass -> Pair.of((Object)this.getDataType((IRI)rangeClass), (Object)rangeClass)).filter(pair -> pair.getLeft() != null).collect(Collectors.toMap(Pair::getLeft, Pair::getRight, (a, b) -> a, TreeMap::new));
        if (!datatypeToValue.isEmpty()) {
            if (datatypeToValue.size() > 1 && this.dataAccess.getConfig().canUseUnions()) {
                String dataTypeUnion = this.scalars.getOrCreateDataTypeUnion(new LinkedHashSet<IRI>(datatypeToValue.values()));
                IRI iri = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/semantic-object/scalars/", dataTypeUnion);
                this.dataTypes.putIfAbsent(this.shortIri(iri.stringValue()), dataTypeUnion);
                return iri;
            }
            return (IRI)datatypeToValue.values().iterator().next();
        }
        if (this.dataAccess.getConfig().canUseUnions()) {
            List<Classes.Class> ranges = list.stream().map(this.classes::getOrCreteClass).toList();
            return this.classes.getOrCreateUnionOf(ranges).orElseThrow().getIri();
        }
        return list.getFirst();
    }

    private String getDataType(IRI rangeClass) {
        return this.dataTypes.get(this.shortIri(rangeClass.stringValue()));
    }

    private void assignPropsToClassesBasedOnPropertyDomain(Properties.Property prop) {
        if (this.ontology.isPrivateProperty(prop)) {
            prop.setHidden();
            this.warn("private.property", prop.getShortIri());
            return;
        }
        if (prop.isShaclProperty()) {
            this.assignShaclPropertiesToDomains(prop);
            return;
        }
        List<Value> domains = this.dataAccess.findDomainClasses(prop.getIri(), this.ontology);
        for (Value domain : domains) {
            Classes.Class domainClass = this.getOrCreteClass((IRI)domain);
            if (domainClass.isShaclShape()) continue;
            if (domainClass.getSuperClass() != null) {
                domainClass = domainClass.getSuperClass();
            }
            Properties.Property property = prop.addReference(domainClass.getIri());
            property.mergePropertyFrom(prop);
            prop.setHidden();
            domainClass.addProperty(property);
        }
    }

    private void assignShaclPropertiesToDomains(Properties.Property prop) {
        for (IRI domain : this.dataAccess.resolveShaclPropertyDomain(prop.getIri(), this.ontology).toList()) {
            this.assignShaclPropertyToDomain(prop, domain);
        }
    }

    private void assignShaclPropertyToDomain(Properties.Property prop, IRI domain) {
        Classes.Class domainClass = this.getOrCreteClass(domain);
        if (domainClass.getSuperClass() != null) {
            domainClass = domainClass.getSuperClass();
        }
        if (prop.isComplexPath()) {
            if (this.checkShaclComplexPathPropertyName(prop, domainClass)) {
                return;
            }
            domainClass.addProperty(prop.addDirectReference(domainClass.getIri()));
        } else if (prop.isInversePath()) {
            if (this.checkShaclInverseProperty(prop, domainClass)) {
                return;
            }
            domainClass.addProperty(prop.addDirectReference(domainClass.getIri()));
        } else if (prop.getRdfProp() != null) {
            String rdfProp = prop.getRdfProp();
            Properties.Property newPropertyRef = prop.addReference(domainClass.getIri());
            newPropertyRef.setName(prop.getName());
            IRI iri = this.namespaces.iri(rdfProp);
            Properties.Property refProp = this.properties.getOrCreateProp(iri);
            refProp.setHidden();
            prop.setHidden();
            newPropertyRef.mergePropertyFrom(prop);
            newPropertyRef.mergePropertyFrom(refProp);
            domainClass.addProperty(newPropertyRef);
            if (this.ontology.isProtectedProperty(refProp) || this.ontology.isProtectedProperty(prop) || prop.isObjectPropertyKind() && prop.getRange() != null && !this.isTypeAllowed((Value)this.namespaces.iri(prop.getRange()))) {
                newPropertyRef.setAsProtected();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean checkShaclInverseProperty(Properties.Property prop, Classes.Class domainClass) {
        String inverseAlias = prop.getInverseAlias();
        IRI iri = this.namespaces.iri(inverseAlias);
        boolean inversePropertyInModel = this.properties.contains((Resource)iri);
        String inverseAliasPropName = inverseAlias;
        if (inversePropertyInModel) {
            Properties.Property inverseAliasProp = this.properties.getOrCreateProp(iri);
            prop.setInverseAlias(inverseAliasProp.getName());
            inverseAliasPropName = inverseAliasProp.getName();
        } else {
            prop.convertInverseAliasToSparqlTemplate();
        }
        if (prop.getName() != null) {
            this.tryFixShaclPropertyName(prop, domainClass);
            return false;
        }
        if (prop.getLabel() != null) {
            String tmpName = this.labelToName(prop.getLabel());
            if (domainClass.containsPropertyByName(tmpName)) {
                this.warn("property.duplicate.name", domainClass.getShortIri(), "^" + inverseAlias);
                return true;
            }
            prop.setName(tmpName);
        } else {
            prop.setName("inverseOf_" + inverseAliasPropName.replace(":", "_"));
        }
        this.warn("property.missing.graphqlName", domainClass.getShortIri(), "^" + inverseAlias, prop.getName());
        return false;
    }

    private String labelToName(String label) {
        return this.namespaces.propertyLabelToName(label);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean checkShaclComplexPathPropertyName(Properties.Property prop, Classes.Class domainClass) {
        if (prop.isInlineShaclProperty() && prop.getName() == null) {
            if (prop.getLabel() == null) {
                this.warn("property.missing.required.graphqlName", domainClass.getShortIri(), prop.getRdfProp());
                return true;
            }
            String tmpName = this.labelToName(prop.getLabel());
            if (domainClass.containsPropertyByName(tmpName)) {
                this.warn("property.duplicate.name", domainClass.getShortIri(), prop.getRdfProp());
                return true;
            }
            prop.setName(tmpName);
            this.warn("property.missing.graphqlName", domainClass.getShortIri(), prop.getRdfProp(), prop.getName());
        }
        this.tryFixShaclPropertyName(prop, domainClass);
        return false;
    }

    private void tryFixShaclPropertyName(Properties.Property property, Classes.Class domainClass) {
        String name = this.namespaces.convertShaclPropertyName(property.getIri(), (Resource)domainClass.getIri());
        if (name == null) {
            return;
        }
        if (!domainClass.containsPropertyByName(name)) {
            property.setName(name);
        }
    }

    private boolean isTypeAllowed(Value type) {
        return this.classes.isTypeAllowed(type);
    }

    private void addPropsToClassesBasedOnOwlRestrictions() throws ConversionException {
        for (Classes.Class clazz : this.classes.values()) {
            IRI classIri = clazz.getIri();
            List<OwlRestrictionsInfo> owlRestrictions = this.dataAccess.getOwlRestrictions(classIri);
            for (OwlRestrictionsInfo owlRestriction : owlRestrictions) {
                this.processClassRestrictionPropertyTriple(owlRestriction);
            }
        }
    }

    private void processClassRestrictionPropertyTriple(OwlRestrictionsInfo info) throws ConversionException {
        Properties.Property prop;
        IRI classIri = info.getTypeIri();
        IRI onProperty = info.getPropertyIri();
        if (info.isAtLeastOneValueRequired()) {
            this.processClassRestrictionPropertyTripleObjectReference(classIri, onProperty);
        }
        if (info.getPossibleClassRanges() != null) {
            info.getPossibleClassRanges().forEach(range -> this.setPropRangeBasedOnOwlRestrictions(classIri, onProperty, (IRI)range));
        }
        if (info.getPossibleDatatypeRanges() != null) {
            info.getPossibleDatatypeRanges().forEach(range -> this.setPropDataRangeBasedOnOwlRestrictions(classIri, onProperty, (IRI)range));
        }
        if (info.getPossibleRanges() != null) {
            this.setPropRangeBasedOnOwlRestrictions(classIri, onProperty, info.getPossibleRanges());
        }
        if (info.getMaxCardinality() != null) {
            prop = this.getOrCreateProperty(classIri, onProperty);
            info.getMaxCardinality().forEach(prop::setMax);
        }
        if (info.getMinCardinality() != null) {
            prop = this.getOrCreateProperty(classIri, onProperty);
            info.getMinCardinality().forEach(prop::setMin);
        }
    }

    private Properties.Property getOrCreateProperty(IRI classIri, IRI prop) {
        Classes.Class domainClass = this.classes.get(classIri);
        if (domainClass.getSuperClass() != null) {
            domainClass = domainClass.getSuperClass();
        }
        return domainClass.getOrAddProperty(prop, domain -> this.properties.getOrCreateProp(prop).addReference((IRI)domain));
    }

    private void processClassRestrictionPropertyTripleObjectReference(IRI classIri, IRI onProperty) {
        Properties.Property newProperty;
        if (Utils.iriIsNotDatatype((Resource)classIri) && (newProperty = this.getOrCreateProperty(classIri, onProperty)) != null) {
            newProperty.setMin(1);
        }
    }

    private void setPropRangeBasedOnOwlRestrictions(IRI classIri, IRI onProperty, IRI rangeClassIri) {
        if (Utils.iriIsNotDatatype((Resource)rangeClassIri)) {
            if (this.classes.isPrivate((Value)rangeClassIri)) {
                return;
            }
            String rangeClassName = this.getOrCreteClass(rangeClassIri).getName();
            Properties.Property newProperty = this.getOrCreateProperty(classIri, onProperty);
            this.setRangeIfNeeded(newProperty, this.classes.get(rangeClassName));
        } else {
            this.setPropDataRangeBasedOnOwlRestrictions(classIri, onProperty, rangeClassIri);
        }
    }

    private void setPropRangeBasedOnOwlRestrictions(IRI classIri, IRI onProperty, List<IRI> ranges) throws ConversionException {
        if (ranges.isEmpty()) {
            return;
        }
        if (ranges.size() == 1) {
            this.setPropRangeBasedOnOwlRestrictions(classIri, onProperty, ranges.getFirst());
            return;
        }
        if (ranges.stream().allMatch(Utils::iriIsNotDatatype)) {
            List<IRI> allowedRanges = ranges.stream().filter(this::isTypeAllowed).toList();
            Properties.Property property = this.getOrCreateProperty(classIri, onProperty);
            this.resolveRangeFromMultipleRanges(property, allowedRanges, this.isObjectProp(property));
        } else if (ranges.stream().allMatch(Utils::isDatatype)) {
            String unionType = this.scalars.getOrCreateDataTypeUnion(new HashSet<IRI>(ranges));
            this.dataTypes.putIfAbsent(this.shortIri("http://www.ontotext.com/semantic-object/scalars/" + unionType), unionType);
            Properties.Property property = this.getOrCreateProperty(classIri, onProperty);
            property.setRange(unionType);
        }
    }

    private void setPropDataRangeBasedOnOwlRestrictions(IRI classIri, IRI onProperty, IRI rangeDatatype) {
        if (Utils.iriIsNotDatatype((Resource)rangeDatatype)) {
            return;
        }
        Properties.Property newProperty = this.getOrCreateProperty(classIri, onProperty);
        newProperty.setRange(this.getDataTypeOfRange(newProperty, (Value)rangeDatatype));
    }

    private void setRangeIfNeeded(Properties.Property newProperty, Classes.Class rangeClass) {
        if (rangeClass.getSuperClass() != null) {
            rangeClass = rangeClass.getSuperClass();
        }
        newProperty.setRange(rangeClass.getName());
    }

    private Classes.Class getOrCreteClass(IRI classIri) {
        return this.classes.getOrCreteClass(classIri);
    }

    private String shortIri(String iri) {
        return this.namespaces.shortIri(iri);
    }

    private void warn(String template, Object ... args) {
        this.messages.add(Message.warning(template, args));
    }

    static {
        DumperOptions options = new DumperOptions();
        options.setIndent(2);
        options.setPrettyFlow(true);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setIndicatorIndent(2);
        options.setIndentWithIndicator(true);
        options.setDefaultScalarStyle(DumperOptions.ScalarStyle.PLAIN);
        options.setSplitLines(false);
        YAML = new Yaml(options);
    }

    public static class Builder {
        private final List<InputOntology> ontologies = new LinkedList<InputOntology>();
        private String vocPfx;
        private String id;
        private String label;
        private String description;
        private String lang;
        private String stringMode;
        private DataAccess dataAccess;
        private List<NamespaceMapping> prefixes;

        public Owl2SomlConverter build() {
            if (this.ontologies.isEmpty()) {
                this.closeDataAccessIfNeeded();
                throw new InvalidArgumentException(ErrorMessages.get((String)"arguments.ontologies.missing"));
            }
            if (Owl2SomlConverter.NO_VOC.equals(this.vocPfx) && this.id == null) {
                this.closeDataAccessIfNeeded();
                throw new InvalidArgumentException(ErrorMessages.get((String)"arguments.missingIdWithNoneVoc"));
            }
            if (this.stringMode != null && !Constants.STRING_TYPES.contains(this.stringMode)) {
                this.closeDataAccessIfNeeded();
                throw new InvalidArgumentException(ErrorMessages.get((String)"arguments.invalidStringMode", (Object[])new Object[]{Constants.STRING_TYPES.stream().collect(Collectors.joining("', '", "'", "'")), this.stringMode}));
            }
            if (StringUtils.isNotBlank((CharSequence)this.lang) && "string".equals(this.stringMode)) {
                this.closeDataAccessIfNeeded();
                throw new InvalidArgumentException(ErrorMessages.get((String)"arguments.invalidUseOfLangArg"));
            }
            if (this.ontologies.stream().anyMatch(ont -> ont.getOntologyId() != null) && this.dataAccess == null) {
                this.closeDataAccessIfNeeded();
                throw new InvalidArgumentException(ErrorMessages.get((String)"arguments.externalDataAccess"));
            }
            return new Owl2SomlConverter(this);
        }

        private void closeDataAccessIfNeeded() {
            if (this.dataAccess != null) {
                this.dataAccess.close();
            }
        }

        public Builder ontology(Model ontology) {
            this.ontologies.add(new InputOntology(ontology));
            return this;
        }

        public Builder ontology(IRI ontologyGraph) {
            this.ontologies.add(new InputOntology(ontologyGraph));
            return this;
        }

        public Builder ontology(String resourceName, InputStream inputStream) {
            this.ontologies.add(new InputOntology(resourceName, inputStream));
            return this;
        }

        public Builder vocPfx(String vocPfx) {
            this.vocPfx = vocPfx;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder stringMode(String stringMode) {
            this.stringMode = stringMode;
            return this;
        }

        public Builder lang(String lang) {
            this.lang = lang;
            return this;
        }

        public Builder withDataAccess(DataAccess dataAccess) {
            this.dataAccess = dataAccess;
            return this;
        }

        public Builder addPrefixes(List<NamespaceMapping> prefixes) {
            this.prefixes = prefixes;
            return this;
        }
    }

    public static class Result {
        private final String schema;
        private final List<Message> messages;

        Result(String schema, List<Message> messages) {
            this.schema = schema;
            this.messages = messages;
        }

        public String getSchema() {
            return this.schema;
        }

        public List<Message> getMessages() {
            return this.messages;
        }
    }
}

