/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.owl2soml;

import com.ontotext.platform.owl2soml.DataAccess;
import com.ontotext.platform.owl2soml.GraphQlSchema;
import com.ontotext.platform.owl2soml.Message;
import com.ontotext.platform.owl2soml.OntologyMetadata;
import com.ontotext.platform.owl2soml.Properties;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Ontology
implements Comparable<Ontology> {
    protected final DataAccess dataAccess;
    protected final List<Message> messages;
    protected List<IRI> ontologyIds;
    protected List<IRI> graphqlModelIds;
    protected IRI graphqlModelId;
    protected IRI ontologyId;
    protected GraphQlSchema graphQlSchema;
    protected IRI storedContext;
    protected Map<IRI, Ontology> importedOntologies = new LinkedHashMap<IRI, Ontology>();

    protected Ontology(DataAccess dataAccess, List<Message> messages) {
        this.dataAccess = dataAccess;
        this.messages = messages;
    }

    @Nullable
    public IRI getStoredContext() {
        return this.storedContext;
    }

    public void setStoredContext(IRI storedContext) {
        this.storedContext = storedContext;
    }

    public abstract OntologyMetadata readMetadata();

    protected void setRelatedOntologies(List<Ontology> other) {
        Set<IRI> ontologies = Stream.of(this.graphqlModelId, this.ontologyId).filter(Objects::nonNull).collect(Collectors.toSet());
        if (ontologies.isEmpty()) {
            return;
        }
        this.dataAccess.getImportedOntologies(ontologies).forEach(imprt -> {
            for (Ontology ontology : other) {
                if (ontology == this || !ontology.getOntologyIds().contains(imprt)) continue;
                ontology.addImportedOntology((IRI)imprt, ontology);
            }
        });
    }

    public Map<IRI, String> resolveGraphQlIdentities() {
        if (this.graphqlModelIds == null) {
            return Map.of();
        }
        return this.graphqlModelIds.stream().collect(Collectors.toMap(Function.identity(), IRI::getLocalName));
    }

    public List<IRI> getOntologyIds() {
        return Objects.requireNonNullElse(this.ontologyIds, List.of());
    }

    public void setOntologyIds(List<IRI> ontologyIds) {
        this.ontologyIds = ontologyIds;
    }

    public List<IRI> getGraphqlModelIds() {
        return Objects.requireNonNullElse(this.graphqlModelIds, List.of());
    }

    public void setGraphqlModelIds(List<IRI> graphqlModelIds) {
        this.graphqlModelIds = graphqlModelIds;
    }

    public IRI getOntologyId() {
        return this.ontologyId;
    }

    public void setOntologyId(IRI ontologyId) {
        this.ontologyId = ontologyId;
    }

    public IRI getGraphqlModelId() {
        return this.graphqlModelId;
    }

    public void setGraphqlModelId(IRI graphqlModelId) {
        this.graphqlModelId = graphqlModelId;
    }

    public Stream<Namespace> getNamespaces() {
        return this.dataAccess.getNamespaces(this);
    }

    protected Optional<String> getOntologyName() {
        if (this.graphqlModelId != null) {
            return this.dataAccess.getGraphQlName(this.graphqlModelId);
        }
        return Optional.empty();
    }

    public void addImportedOntology(IRI iri, Ontology ontology) {
        this.importedOntologies.put(iri, ontology);
    }

    public boolean hasGraphQlSchema() {
        return this.graphqlModelId != null;
    }

    @NotNull
    public GraphQlSchema getGraphQlSchema() {
        if (this.graphQlSchema == null) {
            if (this.hasGraphQlSchema()) {
                this.dataAccess.loadGraphQlModel(this.graphqlModelId, this);
            } else {
                this.graphQlSchema = new GraphQlSchema();
            }
        }
        return this.graphQlSchema;
    }

    public void setGraphQlSchema(GraphQlSchema graphQlSchema) {
        this.graphQlSchema = graphQlSchema;
    }

    public boolean isTypeAllowed(Value type) {
        return this.hasGraphQlSchema() && this.isAllowed(type) || !this.hasGraphQlSchema() && !this.isPrivate(type);
    }

    private boolean isAllowed(Value value) {
        return (this.isPublic(value) || this.isProtected(value)) && !this.isPrivate(value);
    }

    public boolean isPrivate(Value value) {
        return value instanceof IRI && this.graphQlSchema.getPrivateShapes().contains(value);
    }

    private boolean isProtected(Value value) {
        return value instanceof IRI && (this.graphQlSchema.getProtectedShapes().contains(value) || this.graphQlSchema.getProtectedClasses().contains(value));
    }

    private boolean isPublic(Value value) {
        return value instanceof IRI && (this.graphQlSchema.getPublicShapes().contains(value) || this.graphQlSchema.getPublicClasses().contains(value));
    }

    protected boolean hasSingleOwlDefinition() {
        return this.ontologyId != null;
    }

    protected boolean hasOwlDefinition() {
        return !this.getOntologyIds().isEmpty();
    }

    @Override
    public int compareTo(Ontology other) {
        return new CompareToBuilder().append((Object)this.ontologyId, (Object)other.ontologyId, Comparator.comparing(Value::stringValue)).append((Object)this.graphqlModelId, (Object)other.graphqlModelId, Comparator.comparing(Value::stringValue)).append(this.ontologyIds, other.ontologyIds, Comparator.comparing(Object::toString)).append((Object)this.graphqlModelId, (Object)other.graphqlModelId, Comparator.comparing(Object::toString)).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Ontology)) {
            return false;
        }
        Ontology ontology = (Ontology)obj;
        return Objects.equals(this.ontologyIds, ontology.ontologyIds) && Objects.equals(this.graphqlModelIds, ontology.graphqlModelIds) && Objects.equals(this.ontologyId, ontology.ontologyId) && Objects.equals(this.graphqlModelId, ontology.graphqlModelId);
    }

    public int hashCode() {
        return Objects.hash(this.ontologyIds, this.graphqlModelIds, this.ontologyId, this.graphqlModelId);
    }

    public Ontology useFirstOntology() {
        if (this.ontologyId != null) {
            return this;
        }
        if (this.getOntologyIds().size() > 1) {
            this.messages.add(Message.warning("ontologies.ambiguous", this.getOntologyIds().getFirst().stringValue()));
        }
        if (this.ontologyIds != null && !this.ontologyIds.isEmpty()) {
            this.ontologyId = this.getOntologyIds().getFirst();
        }
        return this;
    }

    public boolean match(Literal id) {
        return this.graphqlModelIds != null && this.graphqlModelIds.stream().anyMatch(gqlId -> this.dataAccess.getGraphQlName((IRI)gqlId).filter(Predicate.isEqual(id.stringValue())).isPresent());
    }

    public Ontology selectGraphqlModel(Literal id) {
        if (this.graphqlModelId == null) {
            for (IRI iri : this.graphqlModelIds) {
                if (!this.dataAccess.getGraphQlName(iri).filter(Predicate.isEqual(id.stringValue())).isPresent()) continue;
                this.graphqlModelId = iri;
                break;
            }
        }
        this.resolveOntologyByGraphQlModel();
        return this;
    }

    Ontology selectOntology(IRI id) {
        if (this.graphqlModelId == null && this.graphqlModelIds != null && this.graphqlModelIds.contains(id)) {
            this.graphqlModelId = id;
        }
        if (this.ontologyId == null && this.ontologyIds != null && this.ontologyIds.contains(id)) {
            this.ontologyId = id;
        }
        this.resolveOntologyByGraphQlModel();
        return this;
    }

    public void resolveOntologyByGraphQlModel() {
        if (this.graphqlModelId != null) {
            List<IRI> referencedOntologies;
            if (this.ontologyId == null) {
                Optional<IRI> definedBy = this.dataAccess.getDefinedBy(this.graphqlModelId, this.storedContext);
                definedBy.ifPresent(ontology -> {
                    this.ontologyId = ontology;
                });
            }
            if (!(referencedOntologies = this.dataAccess.getPublicReferencedOntologies(this.graphqlModelId)).isEmpty()) {
                this.ontologyIds = referencedOntologies;
            }
        }
    }

    public List<IRI> getOntologyImports() {
        LinkedHashSet<IRI> iris = new LinkedHashSet<IRI>();
        if (this.graphqlModelId != null) {
            iris.add(this.graphqlModelId);
        }
        if (this.ontologyId != null) {
            iris.add(this.ontologyId);
        }
        if (iris.isEmpty() && this.ontologyIds != null) {
            iris.addAll(this.ontologyIds);
        }
        return this.dataAccess.getImportedOntologies(iris);
    }

    boolean isPrivateProperty(Properties.Property property) {
        return this.isPrivateProperty(property.getIri()) || this.isPrivateProperty(property.getShaclIri());
    }

    boolean isPrivateProperty(Resource property) {
        if (!(property instanceof IRI)) {
            return false;
        }
        Set<Object> privateProperties = this.hasGraphQlSchema() ? this.getGraphQlSchema().getPrivateProperties() : Set.of();
        return privateProperties.contains(property);
    }

    public boolean isProtectedProperty(Properties.Property property) {
        return this.isProtectedProperty(property.getIri()) || this.isProtectedProperty(property.getShaclIri());
    }

    public boolean isProtectedProperty(Resource property) {
        if (!(property instanceof IRI)) {
            return false;
        }
        Set<Object> protectedProperties = this.hasGraphQlSchema() ? this.getGraphQlSchema().getProtectedProperties() : Set.of();
        return protectedProperties.contains(property);
    }

    public abstract Ontology createAllowAllOntology();

    public DataAccess getDataAccess() {
        return this.dataAccess;
    }

    public boolean isEmpty() {
        return this.ontologyId == null && this.getOntologyIds().isEmpty() && this.getGraphqlModelIds().isEmpty();
    }

    public List<Message> getMessages() {
        return this.messages;
    }
}

