/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.owl2soml;

import com.ontotext.platform.owl2soml.Classes;
import com.ontotext.platform.owl2soml.Config;
import com.ontotext.platform.owl2soml.GraphQlSchema;
import com.ontotext.platform.owl2soml.GraphQlSchemaShape;
import com.ontotext.platform.owl2soml.Message;
import com.ontotext.platform.owl2soml.Namespaces;
import com.ontotext.platform.owl2soml.Ontology;
import com.ontotext.platform.owl2soml.OwlRestrictionsInfo;
import com.ontotext.platform.owl2soml.PrefixNamespaceResponse;
import com.ontotext.platform.owl2soml.Properties;
import com.ontotext.platform.owl2soml.PropertyInverseInfo;
import com.ontotext.platform.owl2soml.Role;
import java.io.Closeable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.jetbrains.annotations.Nullable;

public interface DataAccess
extends Closeable {
    public DataAccess initialize(Namespaces var1, List<Message> var2);

    public void configureWith(Ontology var1);

    public void readOntologyMetadata(Ontology var1);

    public Map<String, Object> readOntologyMetadata(IRI var1);

    public void loadConfigurations();

    public void loadModelConfigurations(Ontology var1);

    public Optional<Pair<Value, Value>> extractIriAndPrefixFromVann(IRI var1, IRI var2);

    @Override
    public void close();

    public Config getConfig();

    public Set<IRI> findAlternativeConfigurationsOf(@Nullable IRI var1, Set<IRI> var2);

    public boolean isConfigurationEnabled(@Nullable IRI var1, IRI var2);

    public Optional<Value> getConfiguration(@Nullable IRI var1, IRI var2);

    public Set<IRI> getCustomDataTypes();

    public Optional<String> getGraphQlName(IRI var1);

    public List<IRI> getPublicReferencedOntologies(IRI var1);

    public List<IRI> getImportedOntologies(Set<IRI> var1);

    public Stream<Namespace> getNamespaces(Ontology var1);

    public void loadGraphQlModel(IRI var1, Ontology var2);

    public Set<IRI> findAllExplicitClasses(GraphQlSchema var1, Ontology var2);

    public boolean isDeactivated(Resource var1);

    public Set<IRI> getDeactivatedShapes();

    public Stream<IRI> findReferencedShaclNodes(Set<IRI> var1);

    public Stream<IRI> findReferencedShaclTypes(Set<IRI> var1);

    public void readClassMetadata(Classes.Class var1, Ontology var2);

    public void readAnonymousClassMetadata(Classes.AnonymousClass var1, Ontology var2);

    public Optional<Boolean> isInterfaceType(Resource var1);

    public Optional<String> getLabel(Resource var1);

    public Optional<String> getDescription(Resource var1);

    public String gqlTypeName(Resource var1);

    public String gqlPropertyName(Resource var1);

    public Optional<IRI> getInverseOf(Resource var1);

    public List<PropertyInverseInfo> getPropertyInverseInfos(Resource var1);

    default public void materializeInverseRelations(Collection<Properties.Property> properties) {
    }

    default public void materializeInverseRelations(Resource property, Resource inverse) {
    }

    public Set<Resource> findAllExplicitProperties();

    public Map<String, Map<String, Role>> findRbacRoles(IRI var1);

    public void readPropertyName(Properties.Property var1);

    public void readPropertyMetadata(Properties.Property var1, Ontology var2);

    public void readShaclPropertyMetadata(Properties.Property var1, Resource var2, Ontology var3);

    public boolean isDataProperty(Resource var1);

    public boolean isObjectProperty(Resource var1);

    public List<Value> findRangeClasses(Resource var1);

    public List<Value> findDomainClasses(Resource var1, Ontology var2);

    public Stream<IRI> resolveShaclPropertyDomain(Resource var1, Ontology var2);

    public List<OwlRestrictionsInfo> getOwlRestrictions(IRI var1);

    public Map<IRI, Set<IRI>> getTargetClassToShapes(Collection<IRI> var1);

    public Optional<Value> extractIriAndPrefixFromSwc(IRI var1, IRI var2);

    public Optional<String> extractBaseIri(IRI var1, IRI var2, IRI var3);

    public Optional<Pair<String, String>> getDefaultPrefix(IRI var1, IRI var2, IRI var3);

    public List<Pair<String, String>> getDeclaredPrefixes(List<IRI> var1, IRI var2);

    public Optional<IRI> getDefinedBy(IRI var1, IRI var2);

    public Collection<GraphQlSchemaShape> getGraphQlSchemaShapes();

    public List<PrefixNamespaceResponse> getPossiblePrefixes(String var1);

    public boolean isContext(IRI var1);

    public boolean isOntology(IRI var1);

    public Optional<Value> readOntologyId(IRI var1);
}

