/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.owl2soml;

import com.ontotext.platform.owl2soml.Config;
import com.ontotext.platform.owl2soml.DataAccess;
import com.ontotext.platform.owl2soml.Message;
import com.ontotext.platform.owl2soml.Namespaces;
import com.ontotext.platform.owl2soml.Ontology;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;

public abstract class BaseDataAccess
implements DataAccess {
    public static final String DOT_DELIMITER = ". ";
    public static final String COMMA_DELIMITER = ", ";
    public static final Pattern IRI_PATH_SEPARATOR_PATTERN = Pattern.compile("[+?*/^|$]");
    public static final ValueFactory vf = SimpleValueFactory.getInstance();
    public static final Literal TRUE = vf.createLiteral(true);
    protected Namespaces namespaces;
    protected List<Message> messages;
    protected Config config;

    @Override
    public DataAccess initialize(Namespaces namespaces, List<Message> messages) {
        this.namespaces = namespaces;
        this.messages = messages;
        return this;
    }

    @Override
    public void loadConfigurations() {
        this.getConfig();
        this.config.loadConfigurations(null);
    }

    @Override
    public void loadModelConfigurations(Ontology ontology) {
        if (ontology.getGraphqlModelId() != null) {
            this.config.loadConfigurations(ontology.getGraphqlModelId());
        }
    }

    @Override
    public Config getConfig() {
        if (this.config == null) {
            this.config = new Config(this);
        }
        return this.config;
    }
}

