/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.ogc.gml.v_3_1_1.jts;

import jakarta.xml.bind.JAXBElement;
import net.opengis.gml.v_3_1_1.DirectPositionType;
import net.opengis.gml.v_3_1_1.PointPropertyType;
import net.opengis.gml.v_3_1_1.PointType;
import org.jvnet.ogc.gml.v_3_1_1.ObjectFactoryInterface;
import org.jvnet.ogc.gml.v_3_1_1.jts.AbstractJTSToGML311Converter;
import org.jvnet.ogc.gml.v_3_1_1.jts.JTSToGML311CoordinateConverter;
import org.jvnet.ogc.gml.v_3_1_1.jts.JTSToGML311SRSReferenceGroupConverterInterface;
import org.locationtech.jts.geom.Point;

public class JTSToGML311PointConverter
extends AbstractJTSToGML311Converter<PointType, PointPropertyType, Point> {
    private final JTSToGML311CoordinateConverter coordinateConverter;

    public JTSToGML311PointConverter(ObjectFactoryInterface objectFactoryInterface, JTSToGML311SRSReferenceGroupConverterInterface jTSToGML311SRSReferenceGroupConverterInterface, JTSToGML311CoordinateConverter jTSToGML311CoordinateConverter) {
        super(objectFactoryInterface, jTSToGML311SRSReferenceGroupConverterInterface);
        this.coordinateConverter = jTSToGML311CoordinateConverter;
    }

    @Override
    protected PointType doCreateGeometryType(Point point) {
        PointType pointType = this.getObjectFactory().createPointType();
        if (!point.isEmpty()) {
            DirectPositionType directPositionType = this.coordinateConverter.convertCoordinate(point.getCoordinate());
            pointType.setPos(directPositionType);
        }
        return pointType;
    }

    @Override
    public PointPropertyType createPropertyType(Point point) {
        PointPropertyType pointPropertyType = this.getObjectFactory().createPointPropertyType();
        pointPropertyType.setPoint((PointType)this.createGeometryType(point));
        return pointPropertyType;
    }

    @Override
    public JAXBElement<PointType> createElement(Point point) {
        return this.getObjectFactory().createPoint((PointType)this.createGeometryType(point));
    }
}

