/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.ogc.gml.v_3_1_1.jts;

import jakarta.xml.bind.JAXBElement;
import net.opengis.gml.v_3_1_1.AbstractRingPropertyType;
import net.opengis.gml.v_3_1_1.DirectPositionType;
import net.opengis.gml.v_3_1_1.LinearRingType;
import org.jvnet.ogc.gml.v_3_1_1.ObjectFactoryInterface;
import org.jvnet.ogc.gml.v_3_1_1.jts.AbstractJTSToGML311Converter;
import org.jvnet.ogc.gml.v_3_1_1.jts.JTSToGML311CoordinateConverter;
import org.jvnet.ogc.gml.v_3_1_1.jts.JTSToGML311SRSReferenceGroupConverterInterface;
import org.locationtech.jts.geom.LinearRing;

public class JTSToGML311LinearRingConverter
extends AbstractJTSToGML311Converter<LinearRingType, AbstractRingPropertyType, LinearRing> {
    private final JTSToGML311CoordinateConverter coordinateConverter;

    public JTSToGML311LinearRingConverter(ObjectFactoryInterface objectFactoryInterface, JTSToGML311SRSReferenceGroupConverterInterface jTSToGML311SRSReferenceGroupConverterInterface, JTSToGML311CoordinateConverter jTSToGML311CoordinateConverter) {
        super(objectFactoryInterface, jTSToGML311SRSReferenceGroupConverterInterface);
        this.coordinateConverter = jTSToGML311CoordinateConverter;
    }

    @Override
    protected LinearRingType doCreateGeometryType(LinearRing linearRing) {
        LinearRingType linearRingType = this.getObjectFactory().createLinearRingType();
        for (DirectPositionType directPositionType : this.coordinateConverter.convertCoordinates(linearRing.getCoordinates())) {
            JAXBElement<DirectPositionType> jAXBElement = this.getObjectFactory().createPos(directPositionType);
            linearRingType.getPosOrPointPropertyOrPointRep().add(jAXBElement);
        }
        return linearRingType;
    }

    @Override
    public AbstractRingPropertyType createPropertyType(LinearRing linearRing) {
        AbstractRingPropertyType abstractRingPropertyType = this.getObjectFactory().createAbstractRingPropertyType();
        abstractRingPropertyType.setRing(this.getObjectFactory().createLinearRing((LinearRingType)this.createGeometryType(linearRing)));
        return abstractRingPropertyType;
    }

    @Override
    public JAXBElement<LinearRingType> createElement(LinearRing linearRing) {
        return this.getObjectFactory().createLinearRing((LinearRingType)this.createGeometryType(linearRing));
    }
}

