/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.ogc.gml.v_3_1_1.jts;

import java.text.MessageFormat;
import java.text.ParseException;
import net.opengis.gml.v_3_1_1.AbstractGeometryType;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.ogc.gml.v_3_1_1.jts.ConversionFailedException;
import org.jvnet.ogc.gml.v_3_1_1.jts.GML311ToJTSSRIDConverterInterface;
import org.locationtech.jts.geom.Geometry;

public class GML311ToJTSSRIDConverter
implements GML311ToJTSSRIDConverterInterface {
    private final String[] patterns;

    public GML311ToJTSSRIDConverter(String[] stringArray) {
        this.patterns = stringArray;
    }

    @Override
    public void convert(ObjectLocator objectLocator, AbstractGeometryType abstractGeometryType, Geometry geometry) throws ConversionFailedException {
        if (abstractGeometryType == null) {
            throw new IllegalArgumentException("The validated object is null");
        }
        if (geometry == null) {
            throw new IllegalArgumentException("The validated object is null");
        }
        String string = abstractGeometryType.getSrsName();
        if (string != null) {
            for (String string2 : this.patterns) {
                try {
                    MessageFormat messageFormat = new MessageFormat(string2);
                    Object[] objectArray = messageFormat.parse(string);
                    if (objectArray.length <= 0) continue;
                    geometry.setSRID(((Number)objectArray[0]).intValue());
                    if (geometry.getUserData() != null) continue;
                    geometry.setUserData((Object)string);
                    return;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (geometry.getUserData() != null) {
                throw new ConversionFailedException(objectLocator, MessageFormat.format("Could not parse SRS name [{0}].", string));
            }
            geometry.setUserData((Object)string);
        }
    }
}

