/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.ogc.gml.v_3_1_1.jts;

import net.opengis.gml.v_3_1_1.PointPropertyType;
import net.opengis.gml.v_3_1_1.PointType;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.ogc.gml.v_3_1_1.jts.AbstractGML311ToJTSConverter;
import org.jvnet.ogc.gml.v_3_1_1.jts.ConversionFailedException;
import org.jvnet.ogc.gml.v_3_1_1.jts.GML311ToJTSCoordinateConverter;
import org.jvnet.ogc.gml.v_3_1_1.jts.GML311ToJTSSRIDConverterInterface;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;

public class GML311ToJTSPointConverter
extends AbstractGML311ToJTSConverter<PointType, PointPropertyType, Point> {
    private final GML311ToJTSCoordinateConverter coordinateConverter;

    public GML311ToJTSPointConverter(GeometryFactory geometryFactory, GML311ToJTSSRIDConverterInterface gML311ToJTSSRIDConverterInterface, GML311ToJTSCoordinateConverter gML311ToJTSCoordinateConverter) {
        super(geometryFactory, gML311ToJTSSRIDConverterInterface);
        this.coordinateConverter = gML311ToJTSCoordinateConverter;
    }

    @Override
    protected Point doCreateGeometry(ObjectLocator objectLocator, PointType pointType) throws ConversionFailedException {
        if (pointType.isSetPos()) {
            return this.getGeometryFactory().createPoint(this.coordinateConverter.createCoordinate((ObjectLocator)objectLocator.property("pos", (Object)pointType.getPos()), pointType.getPos()));
        }
        if (pointType.isSetCoordinates()) {
            Coordinate[] coordinateArray = this.coordinateConverter.createCoordinates((ObjectLocator)objectLocator.property("coordinates", (Object)pointType.getCoordinates()), pointType.getCoordinates());
            if (coordinateArray.length != 1) {
                throw new ConversionFailedException((ObjectLocator)objectLocator.property("coordinates", (Object)pointType.getCoordinates()), "Expected exactly one coordinate.");
            }
            return this.getGeometryFactory().createPoint(coordinateArray[0]);
        }
        if (pointType.isSetCoord()) {
            return this.getGeometryFactory().createPoint(this.coordinateConverter.createCoordinate((ObjectLocator)objectLocator.property("coord", (Object)pointType.getCoord()), pointType.getCoord()));
        }
        throw new ConversionFailedException(objectLocator, "Either [pos], [coordinates] or [coord] elements are expected.");
    }

    @Override
    public Point createGeometry(ObjectLocator objectLocator, PointPropertyType pointPropertyType) throws ConversionFailedException {
        if (pointPropertyType.isSetPoint()) {
            return (Point)this.createGeometry((ObjectLocator)objectLocator.property("point", (Object)pointPropertyType.getPoint()), pointPropertyType.getPoint());
        }
        throw new ConversionFailedException(objectLocator, "Expected [Point] element.");
    }
}

