/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.ogc.gml.v_3_1_1.jts;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import net.opengis.gml.v_3_1_1.CoordType;
import net.opengis.gml.v_3_1_1.CoordinatesType;
import net.opengis.gml.v_3_1_1.DirectPositionListType;
import net.opengis.gml.v_3_1_1.DirectPositionType;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.ogc.gml.v_3_1_1.jts.ConversionFailedException;
import org.locationtech.jts.geom.Coordinate;

public class GML311ToJTSCoordinateConverter {
    public Coordinate createCoordinate(ObjectLocator objectLocator, DirectPositionType directPositionType) throws ConversionFailedException {
        List list = directPositionType.getValue();
        int n = list.size();
        if (n == 2) {
            double d = (Double)list.get(0);
            double d2 = (Double)list.get(1);
            return new Coordinate(d, d2);
        }
        if (n == 3) {
            double d = (Double)list.get(0);
            double d3 = (Double)list.get(1);
            double d4 = (Double)list.get(2);
            return new Coordinate(d, d3, d4);
        }
        throw new ConversionFailedException((ObjectLocator)objectLocator.property("value", (Object)list), "Direct position type is expected to have 2 or 3 items.");
    }

    public Coordinate[] createCoordinates(ObjectLocator objectLocator, DirectPositionListType directPositionListType) throws ConversionFailedException {
        int n;
        int n2 = n = directPositionListType.isSetSrsDimension() ? directPositionListType.getSrsDimension().intValue() : 2;
        if (n < 2 || n > 3) {
            throw new ConversionFailedException((ObjectLocator)objectLocator.property("srsDimension", (Object)n), "Only two- or three-dimensional coordinates are supported.");
        }
        List list = directPositionListType.getValue();
        if (list.size() % n != 0) {
            throw new ConversionFailedException((ObjectLocator)objectLocator.property("value", (Object)list), "Wrong number of entries in the list.");
        }
        Coordinate[] coordinateArray = new Coordinate[list.size() / n];
        for (int i = 0; i < list.size() / n; ++i) {
            if (n == 2) {
                coordinateArray[i] = new Coordinate(((Double)list.get(i * n)).doubleValue(), ((Double)list.get(i * n + 1)).doubleValue());
                continue;
            }
            if (n != 3) continue;
            coordinateArray[i] = new Coordinate(((Double)list.get(i * n)).doubleValue(), ((Double)list.get(i * n + 1)).doubleValue(), ((Double)list.get(i * n + 2)).doubleValue());
        }
        return coordinateArray;
    }

    public Coordinate createCoordinate(ObjectLocator objectLocator, CoordType coordType) throws ConversionFailedException {
        if (coordType.isSetX() && coordType.isSetY() && !coordType.isSetZ()) {
            return new Coordinate(coordType.getX().doubleValue(), coordType.getY().doubleValue());
        }
        if (coordType.isSetX() && coordType.isSetY() && !coordType.isSetZ()) {
            return new Coordinate(coordType.getX().doubleValue(), coordType.getY().doubleValue(), coordType.getZ().doubleValue());
        }
        throw new ConversionFailedException(objectLocator, "Either X, Y or X, Y, Z values are required.");
    }

    public Coordinate[] createCoordinates(ObjectLocator objectLocator, CoordinatesType coordinatesType) throws ConversionFailedException {
        Coordinate[] coordinateArray = this.createCoordinates(objectLocator, coordinatesType.getValue(), coordinatesType.getDecimal(), coordinatesType.getCs(), coordinatesType.getTs());
        return coordinateArray;
    }

    public Coordinate[] createCoordinates(ObjectLocator objectLocator, String string, String string2, String string3, String string4) throws ConversionFailedException {
        String string5 = string4 == null ? " " : string4;
        String[] stringArray = string.split(Pattern.quote(string5));
        List<String> list = Arrays.asList(stringArray);
        list.removeAll(Collections.singletonList(""));
        Coordinate[] coordinateArray = new Coordinate[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            coordinateArray[i] = this.createCoordinate((ObjectLocator)objectLocator.item(i, (Object)list.get(i)), list.get(i), string2, string3);
        }
        return coordinateArray;
    }

    public Coordinate createCoordinate(ObjectLocator objectLocator, String string, String string2, String string3) throws ConversionFailedException {
        String string4 = string3 == null ? "," : string3;
        String[] stringArray = string.split(Pattern.quote(string4));
        List<String> list = Arrays.asList(stringArray);
        list.removeAll(Collections.singletonList(""));
        double[] dArray = new double[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            dArray[i] = this.createCoordinateComponent((ObjectLocator)objectLocator.item(i, (Object)list.get(i)), list.get(i), string2);
        }
        if (dArray.length == 2) {
            return new Coordinate(dArray[0], dArray[1]);
        }
        if (dArray.length == 3) {
            return new Coordinate(dArray[0], dArray[1], dArray[2]);
        }
        throw new ConversionFailedException(objectLocator, "Expected two or three coordinates.");
    }

    public double createCoordinateComponent(ObjectLocator objectLocator, String string, String string2) throws ConversionFailedException {
        String string3 = string2 == null ? "." : string2;
        try {
            return Double.parseDouble(string.replace(string3, "."));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConversionFailedException(objectLocator, (Throwable)numberFormatException);
        }
    }
}

