/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.injection.impl;

import com.google.inject.Injector;
import com.google.inject.Module;
import it.unibz.inf.ontop.exception.InvalidOntopConfigurationException;
import it.unibz.inf.ontop.injection.OntopReformulationSQLSettings;
import it.unibz.inf.ontop.injection.OntopReformulationSettings;
import it.unibz.inf.ontop.injection.OntopStandaloneSQLSettings;
import it.unibz.inf.ontop.injection.OntopSystemSQLConfiguration;
import it.unibz.inf.ontop.injection.OntopSystemSQLSettings;
import it.unibz.inf.ontop.injection.OntopSystemSettings;
import it.unibz.inf.ontop.injection.impl.OntopAbstractModule;
import it.unibz.inf.ontop.injection.impl.OntopReformulationSQLConfigurationImpl;
import it.unibz.inf.ontop.injection.impl.OntopSQLCredentialConfigurationImpl;
import it.unibz.inf.ontop.injection.impl.OntopSystemModule;
import it.unibz.inf.ontop.injection.impl.OntopSystemPostModule;
import it.unibz.inf.ontop.injection.impl.OntopSystemSQLModule;
import it.unibz.inf.ontop.injection.impl.OntopSystemSQLSettingsImpl;
import it.unibz.inf.ontop.injection.impl.SpecificationLoader;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class OntopSystemSQLConfigurationImpl
extends OntopReformulationSQLConfigurationImpl
implements OntopSystemSQLConfiguration {
    private final OntopSystemSQLSettings settings;

    OntopSystemSQLConfigurationImpl(OntopSystemSQLSettings settings, OntopSystemSQLOptions options, SpecificationLoader specificationLoader) {
        super((OntopReformulationSQLSettings)settings, options.sqlTranslationOptions, specificationLoader);
        this.settings = settings;
    }

    OntopSystemSQLConfigurationImpl(OntopSystemSQLSettings settings, OntopSystemSQLOptions options) {
        super((OntopReformulationSQLSettings)settings, options.sqlTranslationOptions);
        this.settings = settings;
    }

    OntopSystemSQLConfigurationImpl(OntopStandaloneSQLSettings settings, OntopSystemSQLOptions options, SpecificationLoader specificationLoader, Supplier<Injector> injectorSupplier) {
        super((OntopReformulationSQLSettings)settings, options.sqlTranslationOptions, specificationLoader, injectorSupplier);
        this.settings = settings;
    }

    OntopSystemSQLConfigurationImpl(OntopSystemSQLSettings settings, OntopSystemSQLOptions options, Supplier<Injector> injectorSupplier) {
        super((OntopReformulationSQLSettings)settings, options.sqlTranslationOptions, injectorSupplier);
        this.settings = settings;
    }

    @Override
    public OntopSystemSQLSettings getSettings() {
        return this.settings;
    }

    protected Stream<Module> buildGuiceModules() {
        return Stream.concat(super.buildGuiceModules(), Stream.of(new OntopAbstractModule[]{new OntopSystemModule((OntopSystemSettings)this.settings), new OntopSystemSQLModule(this.settings), new OntopSystemPostModule((OntopReformulationSettings)this.settings)}));
    }

    public static class BuilderImpl
    extends OntopSystemSQLBuilderMixin<BuilderImpl> {
        @Override
        public OntopSystemSQLConfiguration build() {
            if (!this.isOBDASpecificationAssigned()) {
                throw new InvalidOntopConfigurationException("An OBDA specification must be assigned to directly instantiate such a OntopReformulationSQLConfiguration");
            }
            OntopSystemSQLSettingsImpl settings = new OntopSystemSQLSettingsImpl(this.generateProperties());
            OntopSystemSQLOptions options = this.generateSystemSQLOptions();
            return new OntopSystemSQLConfigurationImpl(settings, options);
        }

        protected BuilderImpl self() {
            return this;
        }
    }

    protected static abstract class OntopSystemSQLBuilderMixin<B extends OntopSystemSQLConfiguration.Builder<B>>
    extends OntopReformulationSQLConfigurationImpl.OntopReformulationSQLBuilderMixin<B>
    implements OntopSystemSQLConfiguration.Builder<B> {
        private final OntopSQLCredentialConfigurationImpl.DefaultOntopSQLCredentialBuilderFragment<B> sqlBuilderFragment = new OntopSQLCredentialConfigurationImpl.DefaultOntopSQLCredentialBuilderFragment<B>(){

            protected B self() {
                return (OntopSystemSQLConfiguration.Builder)this.self();
            }
        };

        OntopSystemSQLBuilderMixin() {
        }

        protected Properties generateProperties() {
            Properties properties = super.generateProperties();
            properties.putAll((Map<?, ?>)this.sqlBuilderFragment.generateProperties());
            return properties;
        }

        public B jdbcUser(String username) {
            return (B)((OntopSystemSQLConfiguration.Builder)this.sqlBuilderFragment.jdbcUser(username));
        }

        public B jdbcPassword(String password) {
            return (B)((OntopSystemSQLConfiguration.Builder)this.sqlBuilderFragment.jdbcPassword(password));
        }

        protected final OntopSystemSQLOptions generateSystemSQLOptions() {
            OntopReformulationSQLConfigurationImpl.OntopReformulationSQLOptions reformulationOptions = this.generateSQLReformulationOptions();
            return new OntopSystemSQLOptions(reformulationOptions, this.sqlBuilderFragment.generateSQLCredentialOptions(reformulationOptions.sqlOptions));
        }
    }

    static class OntopSystemSQLOptions {
        final OntopReformulationSQLConfigurationImpl.OntopReformulationSQLOptions sqlTranslationOptions;
        final OntopSQLCredentialConfigurationImpl.OntopSQLCredentialOptions sqlOptions;

        OntopSystemSQLOptions(OntopReformulationSQLConfigurationImpl.OntopReformulationSQLOptions sqlTranslationOptions, OntopSQLCredentialConfigurationImpl.OntopSQLCredentialOptions ontopSQLCredentialOptions) {
            this.sqlTranslationOptions = sqlTranslationOptions;
            this.sqlOptions = ontopSQLCredentialOptions;
        }
    }
}

