/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.injection.impl;

import com.google.inject.Injector;
import com.google.inject.Module;
import it.unibz.inf.ontop.answering.reformulation.QueryReformulator;
import it.unibz.inf.ontop.exception.OBDASpecificationException;
import it.unibz.inf.ontop.injection.OntopMappingSQLAllSettings;
import it.unibz.inf.ontop.injection.OntopStandaloneSQLConfiguration;
import it.unibz.inf.ontop.injection.OntopStandaloneSQLSettings;
import it.unibz.inf.ontop.injection.impl.DefaultOntopSystemBuilderFragment;
import it.unibz.inf.ontop.injection.impl.OntopMappingSQLAllConfigurationImpl;
import it.unibz.inf.ontop.injection.impl.OntopReformulationConfigurationImpl;
import it.unibz.inf.ontop.injection.impl.OntopReformulationSQLConfigurationImpl;
import it.unibz.inf.ontop.injection.impl.OntopSQLCredentialConfigurationImpl;
import it.unibz.inf.ontop.injection.impl.OntopStandaloneSQLSettingsImpl;
import it.unibz.inf.ontop.injection.impl.OntopSystemSQLConfigurationImpl;
import it.unibz.inf.ontop.query.KGQueryFactory;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class OntopStandaloneSQLConfigurationImpl
extends OntopMappingSQLAllConfigurationImpl
implements OntopStandaloneSQLConfiguration {
    private final OntopStandaloneSQLSettings settings;
    private final OntopSystemSQLConfigurationImpl systemConfiguration;

    OntopStandaloneSQLConfigurationImpl(OntopStandaloneSQLSettings settings, OntopStandaloneSQLOptions options) {
        super((OntopMappingSQLAllSettings)settings, options.mappingOptions);
        this.settings = settings;
        this.systemConfiguration = new OntopSystemSQLConfigurationImpl(settings, options.systemOptions, () -> ((OntopStandaloneSQLConfigurationImpl)this).loadOBDASpecification(), () -> ((OntopStandaloneSQLConfigurationImpl)this).getInjector());
    }

    OntopStandaloneSQLConfigurationImpl(OntopStandaloneSQLSettings settings, OntopStandaloneSQLOptions options, Supplier<Injector> injectorSupplier) {
        super((OntopMappingSQLAllSettings)settings, options.mappingOptions, injectorSupplier);
        this.settings = settings;
        this.systemConfiguration = new OntopSystemSQLConfigurationImpl(settings, options.systemOptions, () -> ((OntopStandaloneSQLConfigurationImpl)this).loadOBDASpecification(), injectorSupplier);
    }

    @Override
    public OntopStandaloneSQLSettings getSettings() {
        return this.settings;
    }

    public QueryReformulator loadQueryReformulator() throws OBDASpecificationException {
        return this.systemConfiguration.loadQueryReformulator();
    }

    public KGQueryFactory getKGQueryFactory() {
        return (KGQueryFactory)this.getInjector().getInstance(KGQueryFactory.class);
    }

    protected Stream<Module> buildGuiceModules() {
        return Stream.concat(super.buildGuiceModules(), this.systemConfiguration.buildGuiceModules());
    }

    public static final class BuilderImpl
    extends OntopStandaloneSQLBuilderMixin<BuilderImpl> {
        @Override
        public OntopStandaloneSQLConfiguration build() {
            OntopStandaloneSQLSettingsImpl settings = new OntopStandaloneSQLSettingsImpl(this.generateProperties(), this.isR2rml());
            OntopStandaloneSQLOptions options = this.generateStandaloneSQLOptions();
            return new OntopStandaloneSQLConfigurationImpl(settings, options);
        }

        protected BuilderImpl self() {
            return this;
        }
    }

    protected static abstract class OntopStandaloneSQLBuilderMixin<B extends OntopStandaloneSQLConfiguration.Builder<B>>
    extends OntopMappingSQLAllConfigurationImpl.OntopMappingSQLAllBuilderMixin<B>
    implements OntopStandaloneSQLConfiguration.Builder<B> {
        private final OntopReformulationSQLConfigurationImpl.DefaultOntopReformulationSQLBuilderFragment<B> sqlTranslationFragmentBuilder = new OntopReformulationSQLConfigurationImpl.DefaultOntopReformulationSQLBuilderFragment();
        private final OntopReformulationConfigurationImpl.DefaultOntopReformulationBuilderFragment<B> translationFragmentBuilder = new OntopReformulationConfigurationImpl.DefaultOntopReformulationBuilderFragment<B>(){

            protected B self() {
                return (OntopStandaloneSQLConfiguration.Builder)this.self();
            }
        };
        private final DefaultOntopSystemBuilderFragment<B> systemFragmentBuilder = new DefaultOntopSystemBuilderFragment<B>(){

            protected B self() {
                return (OntopStandaloneSQLConfiguration.Builder)this.self();
            }
        };

        OntopStandaloneSQLBuilderMixin() {
        }

        public B enableExistentialReasoning(boolean enable) {
            return (B)((OntopStandaloneSQLConfiguration.Builder)this.translationFragmentBuilder.enableExistentialReasoning(enable));
        }

        public B keepPermanentDBConnection(boolean keep) {
            return (B)((OntopStandaloneSQLConfiguration.Builder)this.systemFragmentBuilder.keepPermanentDBConnection(keep));
        }

        protected Properties generateProperties() {
            Properties p = super.generateProperties();
            p.putAll((Map<?, ?>)this.systemFragmentBuilder.generateProperties());
            p.putAll((Map<?, ?>)this.sqlTranslationFragmentBuilder.generateProperties());
            p.putAll((Map<?, ?>)this.translationFragmentBuilder.generateProperties());
            return p;
        }

        protected final OntopStandaloneSQLOptions generateStandaloneSQLOptions() {
            OntopMappingSQLAllConfigurationImpl.OntopMappingSQLAllOptions sqlMappingOptions = this.generateMappingSQLAllOptions();
            OntopReformulationConfigurationImpl.OntopReformulationOptions translationOptions = this.translationFragmentBuilder.generateReformulationOptions(sqlMappingOptions.mappingSQLOptions.mappingOptions.queryOptions);
            OntopSQLCredentialConfigurationImpl.OntopSQLCredentialOptions sqlOptions = sqlMappingOptions.mappingSQLOptions.sqlOptions;
            OntopReformulationSQLConfigurationImpl.OntopReformulationSQLOptions sqlTranslationOptions = this.sqlTranslationFragmentBuilder.generateSQLReformulationOptions(translationOptions, sqlOptions.sqlCoreOptions);
            OntopSystemSQLConfigurationImpl.OntopSystemSQLOptions systemSQLOptions = new OntopSystemSQLConfigurationImpl.OntopSystemSQLOptions(sqlTranslationOptions, sqlOptions);
            return new OntopStandaloneSQLOptions(systemSQLOptions, sqlMappingOptions);
        }
    }

    static class OntopStandaloneSQLOptions {
        final OntopSystemSQLConfigurationImpl.OntopSystemSQLOptions systemOptions;
        final OntopMappingSQLAllConfigurationImpl.OntopMappingSQLAllOptions mappingOptions;

        OntopStandaloneSQLOptions(OntopSystemSQLConfigurationImpl.OntopSystemSQLOptions systemOptions, OntopMappingSQLAllConfigurationImpl.OntopMappingSQLAllOptions mappingOptions) {
            this.systemOptions = systemOptions;
            this.mappingOptions = mappingOptions;
        }
    }
}

