/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch.snapshot.AzureRepository;
import co.elastic.clients.elasticsearch.snapshot.GcsRepository;
import co.elastic.clients.elasticsearch.snapshot.ReadOnlyUrlRepository;
import co.elastic.clients.elasticsearch.snapshot.RepositoryVariant;
import co.elastic.clients.elasticsearch.snapshot.S3Repository;
import co.elastic.clients.elasticsearch.snapshot.SharedFileSystemRepository;
import co.elastic.clients.elasticsearch.snapshot.SourceOnlyRepository;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.OpenTaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Repository
implements OpenTaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    @Nullable
    private final String _customKind;
    public static final JsonpDeserializer<Repository> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Repository::setupRepositoryDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public Repository(RepositoryVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._repositoryKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
        this._customKind = null;
    }

    private Repository(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
        this._customKind = builder._customKind;
    }

    public static Repository of(Function<Builder, ObjectBuilder<Repository>> fn) {
        return fn.apply(new Builder()).build();
    }

    public Repository(String kind, JsonData value) {
        this._kind = Kind._Custom;
        this._value = value;
        this._customKind = kind;
    }

    public boolean isAzure() {
        return this._kind == Kind.Azure;
    }

    public AzureRepository azure() {
        return (AzureRepository)TaggedUnionUtils.get(this, Kind.Azure);
    }

    public boolean isGcs() {
        return this._kind == Kind.Gcs;
    }

    public GcsRepository gcs() {
        return (GcsRepository)TaggedUnionUtils.get(this, Kind.Gcs);
    }

    public boolean isUrl() {
        return this._kind == Kind.Url;
    }

    public ReadOnlyUrlRepository url() {
        return (ReadOnlyUrlRepository)TaggedUnionUtils.get(this, Kind.Url);
    }

    public boolean isS3() {
        return this._kind == Kind.S3;
    }

    public S3Repository s3() {
        return (S3Repository)TaggedUnionUtils.get(this, Kind.S3);
    }

    public boolean isFs() {
        return this._kind == Kind.Fs;
    }

    public SharedFileSystemRepository fs() {
        return (SharedFileSystemRepository)TaggedUnionUtils.get(this, Kind.Fs);
    }

    public boolean isSource() {
        return this._kind == Kind.Source;
    }

    public SourceOnlyRepository source() {
        return (SourceOnlyRepository)TaggedUnionUtils.get(this, Kind.Source);
    }

    public boolean _isCustom() {
        return this._kind == Kind._Custom;
    }

    @Override
    @Nullable
    public final String _customKind() {
        return this._customKind;
    }

    public JsonData _custom() {
        return (JsonData)TaggedUnionUtils.get(this, Kind._Custom);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        mapper.serialize(this._value, generator);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupRepositoryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::azure, AzureRepository._DESERIALIZER, "azure");
        op.add(Builder::gcs, GcsRepository._DESERIALIZER, "gcs");
        op.add(Builder::url, ReadOnlyUrlRepository._DESERIALIZER, "url");
        op.add(Builder::s3, S3Repository._DESERIALIZER, "s3");
        op.add(Builder::fs, SharedFileSystemRepository._DESERIALIZER, "fs");
        op.add(Builder::source, SourceOnlyRepository._DESERIALIZER, "source");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            JsonpUtils.ensureCustomVariantsAllowed(parser, mapper);
            builder._custom((String)name, JsonData._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper));
        });
        op.setTypeProperty("type", null);
    }

    public static enum Kind implements JsonEnum
    {
        Azure("azure"),
        Gcs("gcs"),
        Url("url"),
        S3("s3"),
        Fs("fs"),
        Source("source"),
        _Custom(null);

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Repository> {
        private Kind _kind;
        private Object _value;
        private String _customKind;

        @Override
        protected Builder self() {
            return this;
        }

        public ObjectBuilder<Repository> azure(AzureRepository v) {
            this._kind = Kind.Azure;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Repository> azure(Function<AzureRepository.Builder, ObjectBuilder<AzureRepository>> fn) {
            return this.azure(fn.apply(new AzureRepository.Builder()).build());
        }

        public ObjectBuilder<Repository> gcs(GcsRepository v) {
            this._kind = Kind.Gcs;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Repository> gcs(Function<GcsRepository.Builder, ObjectBuilder<GcsRepository>> fn) {
            return this.gcs(fn.apply(new GcsRepository.Builder()).build());
        }

        public ObjectBuilder<Repository> url(ReadOnlyUrlRepository v) {
            this._kind = Kind.Url;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Repository> url(Function<ReadOnlyUrlRepository.Builder, ObjectBuilder<ReadOnlyUrlRepository>> fn) {
            return this.url(fn.apply(new ReadOnlyUrlRepository.Builder()).build());
        }

        public ObjectBuilder<Repository> s3(S3Repository v) {
            this._kind = Kind.S3;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Repository> s3(Function<S3Repository.Builder, ObjectBuilder<S3Repository>> fn) {
            return this.s3(fn.apply(new S3Repository.Builder()).build());
        }

        public ObjectBuilder<Repository> fs(SharedFileSystemRepository v) {
            this._kind = Kind.Fs;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Repository> fs(Function<SharedFileSystemRepository.Builder, ObjectBuilder<SharedFileSystemRepository>> fn) {
            return this.fs(fn.apply(new SharedFileSystemRepository.Builder()).build());
        }

        public ObjectBuilder<Repository> source(SourceOnlyRepository v) {
            this._kind = Kind.Source;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Repository> source(Function<SourceOnlyRepository.Builder, ObjectBuilder<SourceOnlyRepository>> fn) {
            return this.source(fn.apply(new SourceOnlyRepository.Builder()).build());
        }

        public ObjectBuilder<Repository> _custom(String name, Object data) {
            this._kind = Kind._Custom;
            this._customKind = name;
            this._value = JsonData.of(data);
            return this;
        }

        @Override
        public Repository build() {
            this._checkSingleUse();
            return new Repository(this);
        }
    }
}

