/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.InferenceConfigClassification;
import co.elastic.clients.elasticsearch.ingest.InferenceConfigRegression;
import co.elastic.clients.elasticsearch.ingest.InferenceConfigVariant;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class InferenceConfig
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<InferenceConfig> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InferenceConfig::setupInferenceConfigDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public InferenceConfig(InferenceConfigVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._inferenceConfigKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private InferenceConfig(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static InferenceConfig of(Function<Builder, ObjectBuilder<InferenceConfig>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isRegression() {
        return this._kind == Kind.Regression;
    }

    public InferenceConfigRegression regression() {
        return (InferenceConfigRegression)TaggedUnionUtils.get(this, Kind.Regression);
    }

    public boolean isClassification() {
        return this._kind == Kind.Classification;
    }

    public InferenceConfigClassification classification() {
        return (InferenceConfigClassification)TaggedUnionUtils.get(this, Kind.Classification);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupInferenceConfigDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::regression, InferenceConfigRegression._DESERIALIZER, "regression");
        op.add(Builder::classification, InferenceConfigClassification._DESERIALIZER, "classification");
    }

    public static enum Kind implements JsonEnum
    {
        Regression("regression"),
        Classification("classification");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<InferenceConfig> {
        private Kind _kind;
        private Object _value;

        @Override
        protected Builder self() {
            return this;
        }

        public ObjectBuilder<InferenceConfig> regression(InferenceConfigRegression v) {
            this._kind = Kind.Regression;
            this._value = v;
            return this;
        }

        public ObjectBuilder<InferenceConfig> regression(Function<InferenceConfigRegression.Builder, ObjectBuilder<InferenceConfigRegression>> fn) {
            return this.regression(fn.apply(new InferenceConfigRegression.Builder()).build());
        }

        public ObjectBuilder<InferenceConfig> classification(InferenceConfigClassification v) {
            this._kind = Kind.Classification;
            this._value = v;
            return this;
        }

        public ObjectBuilder<InferenceConfig> classification(Function<InferenceConfigClassification.Builder, ObjectBuilder<InferenceConfigClassification>> fn) {
            return this.classification(fn.apply(new InferenceConfigClassification.Builder()).build());
        }

        @Override
        public InferenceConfig build() {
            this._checkSingleUse();
            return new InferenceConfig(this);
        }
    }
}

