/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.inference.GoogleVertexAIServiceSettings;
import co.elastic.clients.elasticsearch.inference.GoogleVertexAIServiceType;
import co.elastic.clients.elasticsearch.inference.GoogleVertexAITaskSettings;
import co.elastic.clients.elasticsearch.inference.GoogleVertexAITaskType;
import co.elastic.clients.elasticsearch.inference.InferenceChunkingSettings;
import co.elastic.clients.elasticsearch.inference.PutGooglevertexaiResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutGooglevertexaiRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final InferenceChunkingSettings chunkingSettings;
    private final String googlevertexaiInferenceId;
    private final GoogleVertexAIServiceType service;
    private final GoogleVertexAIServiceSettings serviceSettings;
    @Nullable
    private final GoogleVertexAITaskSettings taskSettings;
    private final GoogleVertexAITaskType taskType;
    public static final JsonpDeserializer<PutGooglevertexaiRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutGooglevertexaiRequest::setupPutGooglevertexaiRequestDeserializer);
    public static final Endpoint<PutGooglevertexaiRequest, PutGooglevertexaiResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutGooglevertexaiRequest, PutGooglevertexaiResponse>("es/inference.put_googlevertexai", request -> "PUT", request -> {
        boolean _taskType = true;
        int _googlevertexaiInferenceId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_inference");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.taskType.jsonValue(), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.googlevertexaiInferenceId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _taskType = true;
        int _googlevertexaiInferenceId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            params.put("taskType", request.taskType.jsonValue());
            params.put("googlevertexaiInferenceId", request.googlevertexaiInferenceId);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, PutGooglevertexaiResponse._DESERIALIZER);

    private PutGooglevertexaiRequest(Builder builder) {
        this.chunkingSettings = builder.chunkingSettings;
        this.googlevertexaiInferenceId = ApiTypeHelper.requireNonNull(builder.googlevertexaiInferenceId, this, "googlevertexaiInferenceId");
        this.service = ApiTypeHelper.requireNonNull(builder.service, this, "service");
        this.serviceSettings = ApiTypeHelper.requireNonNull(builder.serviceSettings, this, "serviceSettings");
        this.taskSettings = builder.taskSettings;
        this.taskType = ApiTypeHelper.requireNonNull(builder.taskType, this, "taskType");
    }

    public static PutGooglevertexaiRequest of(Function<Builder, ObjectBuilder<PutGooglevertexaiRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final InferenceChunkingSettings chunkingSettings() {
        return this.chunkingSettings;
    }

    public final String googlevertexaiInferenceId() {
        return this.googlevertexaiInferenceId;
    }

    public final GoogleVertexAIServiceType service() {
        return this.service;
    }

    public final GoogleVertexAIServiceSettings serviceSettings() {
        return this.serviceSettings;
    }

    @Nullable
    public final GoogleVertexAITaskSettings taskSettings() {
        return this.taskSettings;
    }

    public final GoogleVertexAITaskType taskType() {
        return this.taskType;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.chunkingSettings != null) {
            generator.writeKey("chunking_settings");
            this.chunkingSettings.serialize(generator, mapper);
        }
        generator.writeKey("service");
        this.service.serialize(generator, mapper);
        generator.writeKey("service_settings");
        this.serviceSettings.serialize(generator, mapper);
        if (this.taskSettings != null) {
            generator.writeKey("task_settings");
            this.taskSettings.serialize(generator, mapper);
        }
    }

    protected static void setupPutGooglevertexaiRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::chunkingSettings, InferenceChunkingSettings._DESERIALIZER, "chunking_settings");
        op.add(Builder::service, GoogleVertexAIServiceType._DESERIALIZER, "service");
        op.add(Builder::serviceSettings, GoogleVertexAIServiceSettings._DESERIALIZER, "service_settings");
        op.add(Builder::taskSettings, GoogleVertexAITaskSettings._DESERIALIZER, "task_settings");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutGooglevertexaiRequest> {
        @Nullable
        private InferenceChunkingSettings chunkingSettings;
        private String googlevertexaiInferenceId;
        private GoogleVertexAIServiceType service;
        private GoogleVertexAIServiceSettings serviceSettings;
        @Nullable
        private GoogleVertexAITaskSettings taskSettings;
        private GoogleVertexAITaskType taskType;

        public final Builder chunkingSettings(@Nullable InferenceChunkingSettings value) {
            this.chunkingSettings = value;
            return this;
        }

        public final Builder chunkingSettings(Function<InferenceChunkingSettings.Builder, ObjectBuilder<InferenceChunkingSettings>> fn) {
            return this.chunkingSettings(fn.apply(new InferenceChunkingSettings.Builder()).build());
        }

        public final Builder googlevertexaiInferenceId(String value) {
            this.googlevertexaiInferenceId = value;
            return this;
        }

        public final Builder service(GoogleVertexAIServiceType value) {
            this.service = value;
            return this;
        }

        public final Builder serviceSettings(GoogleVertexAIServiceSettings value) {
            this.serviceSettings = value;
            return this;
        }

        public final Builder serviceSettings(Function<GoogleVertexAIServiceSettings.Builder, ObjectBuilder<GoogleVertexAIServiceSettings>> fn) {
            return this.serviceSettings(fn.apply(new GoogleVertexAIServiceSettings.Builder()).build());
        }

        public final Builder taskSettings(@Nullable GoogleVertexAITaskSettings value) {
            this.taskSettings = value;
            return this;
        }

        public final Builder taskSettings(Function<GoogleVertexAITaskSettings.Builder, ObjectBuilder<GoogleVertexAITaskSettings>> fn) {
            return this.taskSettings(fn.apply(new GoogleVertexAITaskSettings.Builder()).build());
        }

        public final Builder taskType(GoogleVertexAITaskType value) {
            this.taskType = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutGooglevertexaiRequest build() {
            this._checkSingleUse();
            return new PutGooglevertexaiRequest(this);
        }
    }
}

