/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class AnthropicTaskSettings
implements JsonpSerializable {
    private final int maxTokens;
    @Nullable
    private final Float temperature;
    @Nullable
    private final Integer topK;
    @Nullable
    private final Float topP;
    public static final JsonpDeserializer<AnthropicTaskSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AnthropicTaskSettings::setupAnthropicTaskSettingsDeserializer);

    private AnthropicTaskSettings(Builder builder) {
        this.maxTokens = ApiTypeHelper.requireNonNull(builder.maxTokens, (Object)this, "maxTokens", 0);
        this.temperature = builder.temperature;
        this.topK = builder.topK;
        this.topP = builder.topP;
    }

    public static AnthropicTaskSettings of(Function<Builder, ObjectBuilder<AnthropicTaskSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int maxTokens() {
        return this.maxTokens;
    }

    @Nullable
    public final Float temperature() {
        return this.temperature;
    }

    @Nullable
    public final Integer topK() {
        return this.topK;
    }

    @Nullable
    public final Float topP() {
        return this.topP;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("max_tokens");
        generator.write(this.maxTokens);
        if (this.temperature != null) {
            generator.writeKey("temperature");
            generator.write((double)this.temperature.floatValue());
        }
        if (this.topK != null) {
            generator.writeKey("top_k");
            generator.write(this.topK.intValue());
        }
        if (this.topP != null) {
            generator.writeKey("top_p");
            generator.write((double)this.topP.floatValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupAnthropicTaskSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::maxTokens, JsonpDeserializer.integerDeserializer(), "max_tokens");
        op.add(Builder::temperature, JsonpDeserializer.floatDeserializer(), "temperature");
        op.add(Builder::topK, JsonpDeserializer.integerDeserializer(), "top_k");
        op.add(Builder::topP, JsonpDeserializer.floatDeserializer(), "top_p");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<AnthropicTaskSettings> {
        private Integer maxTokens;
        @Nullable
        private Float temperature;
        @Nullable
        private Integer topK;
        @Nullable
        private Float topP;

        public final Builder maxTokens(int value) {
            this.maxTokens = value;
            return this;
        }

        public final Builder temperature(@Nullable Float value) {
            this.temperature = value;
            return this;
        }

        public final Builder topK(@Nullable Integer value) {
            this.topK = value;
            return this;
        }

        public final Builder topP(@Nullable Float value) {
            this.topP = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AnthropicTaskSettings build() {
            this._checkSingleUse();
            return new AnthropicTaskSettings(this);
        }
    }
}

