/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.indices.UpdateAliasesResponse;
import co.elastic.clients.elasticsearch.indices.update_aliases.Action;
import co.elastic.clients.elasticsearch.indices.update_aliases.ActionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class UpdateAliasesRequest
extends RequestBase
implements JsonpSerializable {
    private final List<Action> actions;
    @Nullable
    private final Time masterTimeout;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<UpdateAliasesRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UpdateAliasesRequest::setupUpdateAliasesRequestDeserializer);
    public static final Endpoint<UpdateAliasesRequest, UpdateAliasesResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<UpdateAliasesRequest, UpdateAliasesResponse>("es/indices.update_aliases", request -> "POST", request -> "/_aliases", request -> Collections.emptyMap(), request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, UpdateAliasesResponse._DESERIALIZER);

    private UpdateAliasesRequest(Builder builder) {
        this.actions = ApiTypeHelper.unmodifiable(builder.actions);
        this.masterTimeout = builder.masterTimeout;
        this.timeout = builder.timeout;
    }

    public static UpdateAliasesRequest of(Function<Builder, ObjectBuilder<UpdateAliasesRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<Action> actions() {
        return this.actions;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.actions)) {
            generator.writeKey("actions");
            generator.writeStartArray();
            for (Action item0 : this.actions) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupUpdateAliasesRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::actions, JsonpDeserializer.arrayDeserializer(Action._DESERIALIZER), "actions");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<UpdateAliasesRequest> {
        @Nullable
        private List<Action> actions;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private Time timeout;

        public final Builder actions(List<Action> list) {
            this.actions = Builder._listAddAll(this.actions, list);
            return this;
        }

        public final Builder actions(Action value, Action ... values) {
            this.actions = Builder._listAdd(this.actions, value, values);
            return this;
        }

        public final Builder actions(ActionVariant value, ActionVariant ... values) {
            this.actions = Builder._listAdd(this.actions, value._toAction(), new Action[0]);
            for (ActionVariant v : values) {
                Builder._listAdd(this.actions, v._toAction(), new Action[0]);
            }
            return this;
        }

        public final Builder actions(Function<Action.Builder, ObjectBuilder<Action>> fn) {
            return this.actions(fn.apply(new Action.Builder()).build(), new Action[0]);
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UpdateAliasesRequest build() {
            this._checkSingleUse();
            return new UpdateAliasesRequest(this);
        }
    }
}

