/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class CCSUsageTimeValue
implements JsonpSerializable {
    private final long max;
    private final long avg;
    private final long p90;
    public static final JsonpDeserializer<CCSUsageTimeValue> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CCSUsageTimeValue::setupCCSUsageTimeValueDeserializer);

    private CCSUsageTimeValue(Builder builder) {
        this.max = ApiTypeHelper.requireNonNull(builder.max, (Object)this, "max", 0L);
        this.avg = ApiTypeHelper.requireNonNull(builder.avg, (Object)this, "avg", 0L);
        this.p90 = ApiTypeHelper.requireNonNull(builder.p90, (Object)this, "p90", 0L);
    }

    public static CCSUsageTimeValue of(Function<Builder, ObjectBuilder<CCSUsageTimeValue>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long max() {
        return this.max;
    }

    public final long avg() {
        return this.avg;
    }

    public final long p90() {
        return this.p90;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("max");
        generator.write(this.max);
        generator.writeKey("avg");
        generator.write(this.avg);
        generator.writeKey("p90");
        generator.write(this.p90);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupCCSUsageTimeValueDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::max, JsonpDeserializer.longDeserializer(), "max");
        op.add(Builder::avg, JsonpDeserializer.longDeserializer(), "avg");
        op.add(Builder::p90, JsonpDeserializer.longDeserializer(), "p90");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<CCSUsageTimeValue> {
        private Long max;
        private Long avg;
        private Long p90;

        public final Builder max(long value) {
            this.max = value;
            return this;
        }

        public final Builder avg(long value) {
            this.avg = value;
            return this;
        }

        public final Builder p90(long value) {
            this.p90 = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CCSUsageTimeValue build() {
            this._checkSingleUse();
            return new CCSUsageTimeValue(this);
        }
    }
}

