/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.elasticsearch.cat.thread_pool.ThreadPoolRecord;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class ThreadPoolResponse
implements JsonpSerializable {
    private final List<ThreadPoolRecord> threadPools;
    public static final JsonpDeserializer<ThreadPoolResponse> _DESERIALIZER = ThreadPoolResponse.createThreadPoolResponseDeserializer();

    private ThreadPoolResponse(Builder builder) {
        this.threadPools = ApiTypeHelper.unmodifiableRequired(builder.threadPools, (Object)this, "threadPools");
    }

    public static ThreadPoolResponse of(Function<Builder, ObjectBuilder<ThreadPoolResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<ThreadPoolRecord> threadPools() {
        return this.threadPools;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartArray();
        for (ThreadPoolRecord item0 : this.threadPools) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static JsonpDeserializer<ThreadPoolResponse> createThreadPoolResponseDeserializer() {
        JsonpDeserializer<List<ThreadPoolRecord>> valueDeserializer = JsonpDeserializer.arrayDeserializer(ThreadPoolRecord._DESERIALIZER);
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().threadPools((List)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ThreadPoolResponse> {
        private List<ThreadPoolRecord> threadPools;

        public final Builder threadPools(List<ThreadPoolRecord> list) {
            this.threadPools = Builder._listAddAll(this.threadPools, list);
            return this;
        }

        public final Builder threadPools(ThreadPoolRecord value, ThreadPoolRecord ... values) {
            this.threadPools = Builder._listAdd(this.threadPools, value, values);
            return this;
        }

        public final Builder threadPools(Function<ThreadPoolRecord.Builder, ObjectBuilder<ThreadPoolRecord>> fn) {
            return this.threadPools(fn.apply(new ThreadPoolRecord.Builder()).build(), new ThreadPoolRecord[0]);
        }

        @Override
        public Builder withJson(JsonParser parser, JsonpMapper mapper) {
            List<ThreadPoolRecord> value = JsonpDeserializer.arrayDeserializer(ThreadPoolRecord._DESERIALIZER).deserialize(parser, mapper);
            return this.threadPools(value);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ThreadPoolResponse build() {
            this._checkSingleUse();
            return new ThreadPoolResponse(this);
        }
    }
}

