/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.elasticsearch.cat.repositories.RepositoriesRecord;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class RepositoriesResponse
implements JsonpSerializable {
    private final List<RepositoriesRecord> repositories;
    public static final JsonpDeserializer<RepositoriesResponse> _DESERIALIZER = RepositoriesResponse.createRepositoriesResponseDeserializer();

    private RepositoriesResponse(Builder builder) {
        this.repositories = ApiTypeHelper.unmodifiableRequired(builder.repositories, (Object)this, "repositories");
    }

    public static RepositoriesResponse of(Function<Builder, ObjectBuilder<RepositoriesResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<RepositoriesRecord> repositories() {
        return this.repositories;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartArray();
        for (RepositoriesRecord item0 : this.repositories) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static JsonpDeserializer<RepositoriesResponse> createRepositoriesResponseDeserializer() {
        JsonpDeserializer<List<RepositoriesRecord>> valueDeserializer = JsonpDeserializer.arrayDeserializer(RepositoriesRecord._DESERIALIZER);
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().repositories((List)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RepositoriesResponse> {
        private List<RepositoriesRecord> repositories;

        public final Builder repositories(List<RepositoriesRecord> list) {
            this.repositories = Builder._listAddAll(this.repositories, list);
            return this;
        }

        public final Builder repositories(RepositoriesRecord value, RepositoriesRecord ... values) {
            this.repositories = Builder._listAdd(this.repositories, value, values);
            return this;
        }

        public final Builder repositories(Function<RepositoriesRecord.Builder, ObjectBuilder<RepositoriesRecord>> fn) {
            return this.repositories(fn.apply(new RepositoriesRecord.Builder()).build(), new RepositoriesRecord[0]);
        }

        @Override
        public Builder withJson(JsonParser parser, JsonpMapper mapper) {
            List<RepositoriesRecord> value = JsonpDeserializer.arrayDeserializer(RepositoriesRecord._DESERIALIZER).deserialize(parser, mapper);
            return this.repositories(value);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RepositoriesResponse build() {
            this._checkSingleUse();
            return new RepositoriesResponse(this);
        }
    }
}

