/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class PluginStats
implements JsonpSerializable {
    private final String classname;
    private final String description;
    private final String elasticsearchVersion;
    private final List<String> extendedPlugins;
    private final boolean hasNativeController;
    private final String javaVersion;
    private final String name;
    private final String version;
    private final boolean licensed;
    public static final JsonpDeserializer<PluginStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PluginStats::setupPluginStatsDeserializer);

    private PluginStats(Builder builder) {
        this.classname = ApiTypeHelper.requireNonNull(builder.classname, this, "classname");
        this.description = ApiTypeHelper.requireNonNull(builder.description, this, "description");
        this.elasticsearchVersion = ApiTypeHelper.requireNonNull(builder.elasticsearchVersion, this, "elasticsearchVersion");
        this.extendedPlugins = ApiTypeHelper.unmodifiableRequired(builder.extendedPlugins, (Object)this, "extendedPlugins");
        this.hasNativeController = ApiTypeHelper.requireNonNull(builder.hasNativeController, (Object)this, "hasNativeController", false);
        this.javaVersion = ApiTypeHelper.requireNonNull(builder.javaVersion, this, "javaVersion");
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.version = ApiTypeHelper.requireNonNull(builder.version, this, "version");
        this.licensed = ApiTypeHelper.requireNonNull(builder.licensed, (Object)this, "licensed", false);
    }

    public static PluginStats of(Function<Builder, ObjectBuilder<PluginStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String classname() {
        return this.classname;
    }

    public final String description() {
        return this.description;
    }

    public final String elasticsearchVersion() {
        return this.elasticsearchVersion;
    }

    public final List<String> extendedPlugins() {
        return this.extendedPlugins;
    }

    public final boolean hasNativeController() {
        return this.hasNativeController;
    }

    public final String javaVersion() {
        return this.javaVersion;
    }

    public final String name() {
        return this.name;
    }

    public final String version() {
        return this.version;
    }

    public final boolean licensed() {
        return this.licensed;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("classname");
        generator.write(this.classname);
        generator.writeKey("description");
        generator.write(this.description);
        generator.writeKey("elasticsearch_version");
        generator.write(this.elasticsearchVersion);
        if (ApiTypeHelper.isDefined(this.extendedPlugins)) {
            generator.writeKey("extended_plugins");
            generator.writeStartArray();
            for (String item0 : this.extendedPlugins) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("has_native_controller");
        generator.write(this.hasNativeController);
        generator.writeKey("java_version");
        generator.write(this.javaVersion);
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("version");
        generator.write(this.version);
        generator.writeKey("licensed");
        generator.write(this.licensed);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupPluginStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::classname, JsonpDeserializer.stringDeserializer(), "classname");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::elasticsearchVersion, JsonpDeserializer.stringDeserializer(), "elasticsearch_version");
        op.add(Builder::extendedPlugins, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "extended_plugins");
        op.add(Builder::hasNativeController, JsonpDeserializer.booleanDeserializer(), "has_native_controller");
        op.add(Builder::javaVersion, JsonpDeserializer.stringDeserializer(), "java_version");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version");
        op.add(Builder::licensed, JsonpDeserializer.booleanDeserializer(), "licensed");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<PluginStats> {
        private String classname;
        private String description;
        private String elasticsearchVersion;
        private List<String> extendedPlugins;
        private Boolean hasNativeController;
        private String javaVersion;
        private String name;
        private String version;
        private Boolean licensed;

        public final Builder classname(String value) {
            this.classname = value;
            return this;
        }

        public final Builder description(String value) {
            this.description = value;
            return this;
        }

        public final Builder elasticsearchVersion(String value) {
            this.elasticsearchVersion = value;
            return this;
        }

        public final Builder extendedPlugins(List<String> list) {
            this.extendedPlugins = Builder._listAddAll(this.extendedPlugins, list);
            return this;
        }

        public final Builder extendedPlugins(String value, String ... values) {
            this.extendedPlugins = Builder._listAdd(this.extendedPlugins, value, values);
            return this;
        }

        public final Builder hasNativeController(boolean value) {
            this.hasNativeController = value;
            return this;
        }

        public final Builder javaVersion(String value) {
            this.javaVersion = value;
            return this;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder version(String value) {
            this.version = value;
            return this;
        }

        public final Builder licensed(boolean value) {
            this.licensed = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PluginStats build() {
            this._checkSingleUse();
            return new PluginStats(this);
        }
    }
}

