/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.sparql;

import com.ontotext.forest.sparql.GraphDBLoadBalancedRepositoryConnection;
import com.ontotext.forest.sparql.GraphQLSparqlConnectionFactory;
import com.ontotext.raft.repository.ClusterRepositoryManager;
import com.ontotext.sparql.SparqlEndpoint;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBalancedGraphQLSparqlConnectionFactory
extends GraphQLSparqlConnectionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final boolean forWriting;
    private final ExecutorService executorService = Executors.newCachedThreadPool();

    public LoadBalancedGraphQLSparqlConnectionFactory(Supplier<RepositoryManager> repositoryManagerSupplier, boolean forWriting) {
        super(repositoryManagerSupplier);
        this.forWriting = forWriting;
    }

    @Override
    protected RepositoryConnection getRepositoryConnection(Repository repository, SparqlEndpoint info) {
        RepositoryConnection repositoryConnection = super.getRepositoryConnection(repository, info);
        RepositoryManager repositoryManager = this.createRepositoryManager(null);
        if (repositoryManager instanceof ClusterRepositoryManager) {
            ClusterRepositoryManager clusterRepositoryManager = (ClusterRepositoryManager)repositoryManager;
            if (!this.forWriting) {
                return new GraphDBLoadBalancedRepositoryConnection(info.getRepository(), repository, repositoryConnection, clusterRepositoryManager.getLoadBalancer(), this.executorService);
            }
        }
        return repositoryConnection;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }
}

