/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.sparql;

import com.ontotext.forest.sparql.GraphQLRepositoryConnection;
import com.ontotext.sparql.AbstractSparqlConnectionFactory;
import com.ontotext.sparql.SparqlEndpoint;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLSparqlConnectionFactory
extends AbstractSparqlConnectionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Supplier<RepositoryManager> repositoryManagerSupplier;
    private ExecutorService executorService = Executors.newCachedThreadPool();

    public GraphQLSparqlConnectionFactory(Supplier<RepositoryManager> repositoryManagerSupplier) {
        this.repositoryManagerSupplier = repositoryManagerSupplier;
    }

    protected RepositoryManager createRepositoryManager(SparqlEndpoint sparqlEndpoint) {
        return this.repositoryManagerSupplier.get();
    }

    protected RepositoryConnection getRepositoryConnection(Repository repository, SparqlEndpoint info) {
        return new GraphQLRepositoryConnection(repository, super.getRepositoryConnection(repository, info));
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    public void reload(SparqlEndpoint endpoint) {
        throw new UnsupportedOperationException("Connection factory does not support reload");
    }
}

