/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.graphql.controller.responses;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.ontotext.forest.graphql.controller.responses.ResponseMapper;
import com.ontotext.forest.graphql.controller.responses.ResponseMessage;
import com.ontotext.models.InvalidSchemaException;
import com.ontotext.models.extensions.Severity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonPropertyOrder(value={"schema", "content"})
public class InvalidSchemaResponse<T> {
    @JsonProperty
    private final List<T> content;
    @JsonProperty
    private final String schema;

    private InvalidSchemaResponse(List<T> content, String schema) {
        this.content = content;
        this.schema = schema;
    }

    public int hashCode() {
        return super.hashCode() + Objects.hashCode(this.schema);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InvalidSchemaResponse other = (InvalidSchemaResponse)obj;
        return Objects.equals(this.schema, other.schema);
    }

    public static class Builder {
        private final String schema;
        private List<ResponseMessage> responseMessages;

        public Builder(String schema) {
            this.schema = schema;
            this.responseMessages = new ArrayList<ResponseMessage>();
        }

        public Builder addMessages(InvalidSchemaException ise) {
            this.responseMessages.addAll(ise.getErrorMessages(ResponseMapper.toErrorResponse()));
            this.responseMessages.addAll(ise.getWarningMessages(ResponseMapper.toWarningResponse()));
            return this;
        }

        public Builder addMessages(Collection<String> messages, Severity type) {
            messages.forEach(message -> this.responseMessages.add(ResponseMapper.transform(message, type)));
            return this;
        }

        public InvalidSchemaResponse<ResponseMessage> build() {
            return new InvalidSchemaResponse<ResponseMessage>(this.responseMessages, this.schema);
        }
    }
}

