/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.graphql.controller;

import com.ontotext.forest.core.proxy.ProxyToRemoteSesame;
import com.ontotext.forest.core.semantic.LocationType;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.semantic.SemanticLocation;
import com.ontotext.forest.graphql.GraphQLService;
import com.ontotext.forest.graphql.cluster.GraphQLManagementService;
import com.ontotext.forest.graphql.controller.ExtendedMediaType;
import com.ontotext.forest.graphql.controller.requests.GraphQLSchemaCreateRequest;
import com.ontotext.forest.graphql.controller.requests.UpdateEndpointRequest;
import com.ontotext.forest.graphql.controller.responses.ConfigOption;
import com.ontotext.forest.graphql.controller.responses.GraphQLEndpoint;
import com.ontotext.forest.graphql.controller.responses.GraphQLEndpointReport;
import com.ontotext.forest.graphql.controller.responses.ImportResponse;
import com.ontotext.graphdb.graphql.config.SimpleGraphQLSchemaCreateRequest;
import com.ontotext.platform.owl2soml.GraphQlSchemaShape;
import com.ontotext.platform.owl2soml.PrefixNamespaceResponse;
import com.ontotext.soaas.common.ErrorCode;
import com.ontotext.soaas.common.exceptions.BadRequestException;
import com.ontotext.validator.data.ValidationJob;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.runtime.SwitchBootstraps;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.IRI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/rest/repositories"})
@Tag(name="GraphQL management", description="Manage the available GraphQL models")
public class GraphQLManagementController {
    private static final HttpHeaders YAML_HEADER = new HttpHeaders();
    public static final HttpHeaders JSON_HEADER = new HttpHeaders();
    private final SemanticDataManagement semanticDataManagement;
    private final ProxyToRemoteSesame proxyToRemoteSesame;
    private final GraphQLManagementService serviceEndpoint;

    @Autowired
    public GraphQLManagementController(SemanticDataManagement semanticDataManagement, ProxyToRemoteSesame proxyToRemoteSesame, GraphQLManagementService serviceEndpoint) {
        this.semanticDataManagement = semanticDataManagement;
        this.proxyToRemoteSesame = proxyToRemoteSesame;
        this.serviceEndpoint = serviceEndpoint;
    }

    @Hidden
    @Operation(summary="Scan repository for GraphQL schema shapes", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=GraphQlSchemaShape.class)))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="404", description="Not Found", content={@Content}), @ApiResponse(responseCode="409", description="Conflict", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="412", description="Precondition Failed", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @GetMapping(path={"{targetRepo}/graphql/manage/graphql_shapes"}, produces={"application/json"})
    public ResponseEntity<?> getGraphQlSchemaShapes(@Parameter(description="Target repository", required=true) @PathVariable(value="targetRepo") String repository, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws Exception {
        return (ResponseEntity)this.proxyToRemoteSesame.proxyToRemoteIfNeeded(servletRequest, servletResponse, repository, this.semanticDataManagement, () -> new ResponseEntity(Map.of("shapes", this.serviceEndpoint.getGraphQlSchemaShapes(repository)), (MultiValueMap)JSON_HEADER, (HttpStatusCode)HttpStatus.OK));
    }

    @Hidden
    @Operation(summary="List all GraphQL endpoints with detailed information", description="Retrieves a list of all available GraphQL endpoints for the specified repository, including metadata such as labels, descriptions, last modified timestamps, object and property counts, and status flags.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=GraphQLEndpoint.class)))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="404", description="Not Found", content={@Content}), @ApiResponse(responseCode="409", description="Conflict", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="412", description="Precondition Failed", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @GetMapping(path={"{repository}/graphql/manage/list"}, produces={"application/json"})
    public ResponseEntity<?> listGraphQlEndpoints(@Parameter(description="Target repository", required=true) @PathVariable(value="repository") String repository, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws Exception {
        return (ResponseEntity)this.proxyToRemoteSesame.proxyToRemoteIfNeeded(servletRequest, servletResponse, repository, this.semanticDataManagement, () -> new ResponseEntity(Map.of("endpoints", this.serviceEndpoint.getAllEndpoints(repository)), (MultiValueMap)JSON_HEADER, (HttpStatusCode)HttpStatus.OK));
    }

    @Hidden
    @Operation(summary="Retrieves the configuration options for schema generation settings \n        of a specific GraphQL endpoint within a repository.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ConfigOption.class)))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="404", description="Not Found", content={@Content}), @ApiResponse(responseCode="409", description="Conflict", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="412", description="Precondition Failed", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @GetMapping(path={"{targetRepo}/graphql/manage/endpoints/{endpointId}/config"}, produces={"application/json"})
    public ResponseEntity<?> getEndpointOptions(@Parameter(description="Target repository", required=true) @PathVariable(value="targetRepo") String targetRepo, @PathVariable(value="endpointId") String endpointId, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws Exception {
        return (ResponseEntity)this.proxyToRemoteSesame.proxyToRemoteIfNeeded(servletRequest, servletResponse, targetRepo, this.semanticDataManagement, () -> new ResponseEntity(Map.of("configs", this.serviceEndpoint.getEndpointOptions(targetRepo, endpointId)), (MultiValueMap)JSON_HEADER, (HttpStatusCode)HttpStatus.OK));
    }

    @Hidden
    @Operation(summary="Get Available Options for Schema Generation Config", description="Retrieves the available configuration options for schema generation settings.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ConfigOption.class)))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="404", description="Not Found", content={@Content}), @ApiResponse(responseCode="409", description="Conflict", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="412", description="Precondition Failed", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @GetMapping(path={"/graphql/manage/generate/config"}, produces={"application/json"})
    public ResponseEntity<?> getSchemaGenerationOptions(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws Exception {
        SemanticLocation semanticLocation = this.semanticDataManagement.getLocationFromHeaderOrThrow();
        if (semanticLocation.getLocationType() == LocationType.GDB) {
            return (ResponseEntity)this.proxyToRemoteSesame.proxyToRemoteIfNeeded(servletRequest, servletResponse, semanticLocation, () -> new ResponseEntity(Map.of("configs", this.serviceEndpoint.getSchemaGenerationOptions()), (MultiValueMap)JSON_HEADER, (HttpStatusCode)HttpStatus.OK));
        }
        return ResponseEntity.badRequest().body((Object)"This feature is supported only for attached remote locations of GraphDB type");
    }

    @Hidden
    @Operation(summary="Get List of Possible Prefixes", description="Retrieves a list of possible prefixes for the specified repository. The prefixes are aggregated from both the repository's defined namespaces and the GraphQL schema shapes associated with the repository.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=PrefixNamespaceResponse.class)))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="404", description="Not Found", content={@Content}), @ApiResponse(responseCode="409", description="Conflict", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="412", description="Precondition Failed", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @GetMapping(path={"{targetRepo}/graphql/manage/prefixes"}, produces={"application/json"})
    public ResponseEntity<?> getPossiblePrefixes(@Parameter(description="Target repository", required=true) @PathVariable(value="targetRepo") String targetRepo, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws Exception {
        return (ResponseEntity)this.proxyToRemoteSesame.proxyToRemoteIfNeeded(servletRequest, servletResponse, targetRepo, this.semanticDataManagement, () -> new ResponseEntity(Map.of("prefixes", this.serviceEndpoint.getPossiblePrefixes(targetRepo)), (MultiValueMap)JSON_HEADER, (HttpStatusCode)HttpStatus.OK));
    }

    @Hidden
    @Operation(summary="Retrieves the set of SHACL shape graphs associated with the specified repository", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=IRI.class)))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="404", description="Not Found", content={@Content}), @ApiResponse(responseCode="409", description="Conflict", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="412", description="Precondition Failed", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @GetMapping(path={"{targetRepo}/graphql/manage/shacl_graphs"}, produces={"application/json"})
    public ResponseEntity<?> getShaclGraphs(@Parameter(description="Target repository", required=true) @PathVariable(value="targetRepo") String targetRepo, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws Exception {
        return (ResponseEntity)this.proxyToRemoteSesame.proxyToRemoteIfNeeded(servletRequest, servletResponse, targetRepo, this.semanticDataManagement, () -> new ResponseEntity(Map.of("shacl_graphs", this.serviceEndpoint.getShaclGraphsForRepository(targetRepo)), (MultiValueMap)JSON_HEADER, (HttpStatusCode)HttpStatus.OK));
    }

    @Operation(summary="Retrieve a detailed GraphQL Endpoints Report for repository", description="Fetches a report containing validation messages and other metadata for a GraphQL endpoint for the given repository.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=GraphQLEndpointReport.class)))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="404", description="Not Found", content={@Content}), @ApiResponse(responseCode="409", description="Conflict", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="412", description="Precondition Failed", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @GetMapping(path={"{targetRepo}/graphql/manage/endpoints"}, produces={"application/json"})
    public ResponseEntity<?> getAllEndpointsReport(@Parameter(description="Target repository", required=true) @PathVariable(value="targetRepo") String targetRepo, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws Exception {
        return (ResponseEntity)this.proxyToRemoteSesame.proxyToRemoteIfNeeded(servletRequest, servletResponse, targetRepo, this.semanticDataManagement, () -> new ResponseEntity(this.serviceEndpoint.getAllEndpointsReport(targetRepo), (MultiValueMap)JSON_HEADER, (HttpStatusCode)HttpStatus.OK));
    }

    @Operation(summary="Retrieve a detailed GraphQL Endpoint Report", description="Fetches a report containing validation messages and other metadata for a specific GraphQL endpoint based on the given repository and schema ID.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=GraphQLEndpointReport.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="404", description="Not Found", content={@Content}), @ApiResponse(responseCode="409", description="Conflict", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="412", description="Precondition Failed", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @GetMapping(path={"{targetRepo}/graphql/manage/endpoints/{endpointId}"}, produces={"application/json"})
    public ResponseEntity<?> getEndpointReport(@Parameter(description="Target repository", required=true) @PathVariable(value="targetRepo") String targetRepo, @Parameter(description="Schema identifier", required=true) @PathVariable(value="endpointId") String endpoint, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws Exception {
        return (ResponseEntity)this.proxyToRemoteSesame.proxyToRemoteIfNeeded(servletRequest, servletResponse, targetRepo, this.semanticDataManagement, () -> new ResponseEntity((Object)this.serviceEndpoint.getEndpointReport(targetRepo, endpoint), (MultiValueMap)JSON_HEADER, (HttpStatusCode)HttpStatus.OK));
    }

    @Operation(summary="Generate a GraphQL schema using data from specified named graphs", description="This endpoint generates a GraphQL schema based on the provided named graphs within the source repository.", requestBody=@RequestBody(description="JSON payload containing the source repository, a list of named graphs, and optional configuration settings for GraphQL schema generation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=SimpleGraphQLSchemaCreateRequest.class, example="        {\n          \"fromRepo\": \"my-repository\",\n          \"namedGraphs\": [\n            \"http://example.org/graph1\"\n          ],\n          \"id\": \"swapi\",\n          \"label\": \"Star Wars API\",\n          \"description\": \"GraphQL API for Star Wars data\",\n          \"vocabPrefix\": \"voc\",\n          \"config\": {\n            \"langFetch\": \"en\",\n            \"langValidate\": \"en\",\n            \"langImplicit\": \"en\",\n            \"stringMode\": \"default\",\n            \"readShaclPropertyLabels\": true,\n            \"includeDeactivatedShapes\": false,\n            \"cleanInvalidInverseOf\": true,\n            \"useUnions\": true,\n            \"defaultMaxCardinality\": 1,\n            \"forceInterfaceTypes\": false,\n            \"removeUnknownRanges\": true,\n            \"readRBACRules\": true\n          }\n        }\n"))}), responses={@ApiResponse(responseCode="201", description="Created", content={@Content(mediaType="application/json", schema=@Schema(implementation=GraphQLEndpointReport.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="404", description="Not Found", content={@Content}), @ApiResponse(responseCode="409", description="Conflict", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="412", description="Precondition Failed", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="500", description="Internal Server Error", content={@Content})})
    @PostMapping(path={"{targetRepo}/graphql/manage/generate/owl_shacl"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<?> generateNewSchemaOwlShacl(@Parameter(description="Target repository") @PathVariable(value="targetRepo") String repository, @org.springframework.web.bind.annotation.RequestBody SimpleGraphQLSchemaCreateRequest createRequest, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws Exception {
        return (ResponseEntity)this.proxyToRemoteSesame.proxyToRemoteIfNeeded(servletRequest, servletResponse, repository, this.semanticDataManagement, () -> {
            if (StringUtils.isBlank((CharSequence)createRequest.getId()) && StringUtils.isBlank((CharSequence)createRequest.getVocabPrefix())) {
                throw new BadRequestException("A valid schema `id` or `vocPfx` must be included to uniquely identify the schema.", ErrorCode.MISSING_REQUIRED_SCHEMA_PARAMETERS);
            }
            return new ResponseEntity((Object)this.serviceEndpoint.createNewEndpoint(repository, createRequest), (MultiValueMap)JSON_HEADER, (HttpStatusCode)HttpStatus.CREATED);
        });
    }

    @Operation(summary="Generate a GraphQL schemas based on GraphQL model shapes", description="This endpoint generates a GraphQL schema based on the provided shapes within the source repository.", responses={@ApiResponse(responseCode="201", description="Created", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=GraphQLEndpointReport.class)))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="404", description="Not Found", content={@Content}), @ApiResponse(responseCode="409", description="Conflict", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="412", description="Precondition Failed", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @PostMapping(path={"{targetRepo}/graphql/manage/generate/graphql_shapes"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<?> generateNewSchemaGraphQLShapes(@Parameter(description="Target repository") @PathVariable(value="targetRepo") String repository, @RequestBody(description="The request body containing the source repository, a list of shape identifiers, and schema generation configurations.") @org.springframework.web.bind.annotation.RequestBody GraphQLSchemaCreateRequest createRequest, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws Exception {
        return (ResponseEntity)this.proxyToRemoteSesame.proxyToRemoteIfNeeded(servletRequest, servletResponse, repository, this.semanticDataManagement, () -> new ResponseEntity(this.serviceEndpoint.createNewEndpoints(repository, createRequest), (MultiValueMap)JSON_HEADER, (HttpStatusCode)HttpStatus.CREATED));
    }

    @Hidden
    @Operation(summary="Confirm and resolve issues for a GraphQL endpoint schema", description="This action indicates that the user has reviewed and accepted the schema validation results, resolving any outstanding issues.", responses={@ApiResponse(responseCode="204", description="No Content", content={@Content}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="404", description="Not Found", content={@Content}), @ApiResponse(responseCode="409", description="Conflict", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="412", description="Precondition Failed", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @PatchMapping(path={"{targetRepo}/graphql/manage/endpoints/{endpointId}/messages"})
    public ResponseEntity<?> confirmEndpointReport(@Parameter(description="Target repository", required=true) @PathVariable(value="targetRepo") String targetRepo, @Parameter(description="Schema identifier", required=true) @PathVariable(value="endpointId") String endpoint, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws Exception {
        return (ResponseEntity)this.proxyToRemoteSesame.proxyToRemoteIfNeeded(servletRequest, servletResponse, targetRepo, this.semanticDataManagement, () -> {
            this.serviceEndpoint.confirmEndpointReport(targetRepo, endpoint);
            return ResponseEntity.noContent().build();
        });
    }

    @Operation(summary="Delete schema from repository", responses={@ApiResponse(responseCode="204", description="No Content", content={@Content}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="404", description="Not Found", content={@Content}), @ApiResponse(responseCode="409", description="Conflict", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="412", description="Precondition Failed", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @DeleteMapping(path={"{repository}/graphql/manage/endpoints/{endpoint}"}, produces={"application/json"})
    public ResponseEntity<?> delete(@Parameter(description="Target repository", required=true) @PathVariable(value="repository") String repository, @Parameter(description="Schema identifier", required=true) @PathVariable String endpoint, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws Exception {
        return (ResponseEntity)this.proxyToRemoteSesame.proxyToRemoteIfNeeded(servletRequest, servletResponse, repository, this.semanticDataManagement, () -> {
            this.serviceEndpoint.deleteSchema(repository, endpoint);
            return ResponseEntity.noContent().build();
        });
    }

    @Operation(summary="Edit an existing GraphQL endpoint", description="Updates the GraphQL endpoint in the specified target repository. The request body should include the source repository, a list of shape identifiers, and schema generation configurations.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=GraphQLEndpointReport.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="404", description="Not Found", content={@Content}), @ApiResponse(responseCode="409", description="Conflict", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="412", description="Precondition Failed", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @PostMapping(path={"{targetRepo}/graphql/manage/endpoints/{endpointId}"}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity<?> editEndpoint(@Parameter(description="Target repository") @PathVariable(value="targetRepo") String targetRepo, @Parameter(description="Schema identifier", required=true) @PathVariable String endpointId, @RequestBody(description="Represents an update request for a GraphQL endpoint, including activation status, default flag, metadata, and configuration options.") @org.springframework.web.bind.annotation.RequestBody UpdateEndpointRequest updateRequest, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws Exception {
        return (ResponseEntity)this.proxyToRemoteSesame.proxyWithBodyToRemoteIfNeeded((Object)updateRequest, servletRequest, servletResponse, targetRepo, this.semanticDataManagement, () -> new ResponseEntity((Object)this.serviceEndpoint.editEndpoint(targetRepo, endpointId, updateRequest), (MultiValueMap)JSON_HEADER, (HttpStatusCode)HttpStatus.OK));
    }

    @Operation(summary="Export GraphQL endpoint definition", description="Exports the GraphQL endpoint definition for the specified endpoint in the target repository as a YAML file.", responses={@ApiResponse(responseCode="200", description="Successful export", content={@Content(mediaType="text/yaml", schema=@Schema(type="string", format="binary"))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="404", description="Not Found", content={@Content}), @ApiResponse(responseCode="409", description="Conflict", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="412", description="Precondition Failed", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @GetMapping(path={"{targetRepo}/graphql/manage/endpoints/{endpointId}/export"}, produces={"text/yaml", "text/x-yaml", "text/yml", "application/x-yaml", "application/x-yml", "application/yaml", "application/yml"})
    public ResponseEntity<?> exportSchema(@Parameter(description="Target repository", required=true) @PathVariable(value="targetRepo") String targetRepo, @Parameter(description="Schema identifier", required=true) @PathVariable(value="endpointId") String endpointId, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws Exception {
        return (ResponseEntity)this.proxyToRemoteSesame.proxyToRemoteIfNeeded(servletRequest, servletResponse, targetRepo, this.semanticDataManagement, () -> ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(ExtendedMediaType.YAML).header("Content-Disposition", new String[]{"attachment; filename=\"" + GraphQLService.toYamlFilename(endpointId) + "\""})).body((Object)this.serviceEndpoint.exportSchemaAsYaml(targetRepo, endpointId)));
    }

    @Operation(summary="Export all GraphQL endpoint definitions", description="Exports all GraphQL endpoint definitions from the specified target repository as a ZIP file.", responses={@ApiResponse(responseCode="200", description="Successful export", content={@Content(mediaType="application/zip", schema=@Schema(type="string", format="binary"))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="404", description="Not Found", content={@Content}), @ApiResponse(responseCode="409", description="Conflict", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="412", description="Precondition Failed", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @GetMapping(path={"{targetRepo}/graphql/manage/endpoints/export"}, produces={"application/zip"})
    public ResponseEntity<?> exportAllSchemas(@Parameter(description="Target repository", required=true) @PathVariable(value="targetRepo") String targetRepo, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws Exception {
        return (ResponseEntity)this.proxyToRemoteSesame.proxyToRemoteIfNeeded(servletRequest, servletResponse, targetRepo, this.semanticDataManagement, () -> ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.APPLICATION_OCTET_STREAM).header("Content-Disposition", new String[]{"attachment; filename=\"" + this.getExportFileName(targetRepo) + "\""})).body((Object)this.serviceEndpoint.exportAllSchemasAsZip(targetRepo)));
    }

    @Operation(summary="Import GraphQL endpoint definitions", description="     Imports GraphQL endpoint definitions into the target repository. \n     The request body format depends on the `Content-Type` header:\n     - `multipart/form-data`: Accepts multiple YAML or Zip archives files as `MultipartFile[]`.\n     - `application/x-yaml, `application/yaml`: Accepts a single YAML schema as a raw file.\n     - `application/zip`: Accepts a ZIP archive containing multiple YAML schema files.\n ", requestBody=@RequestBody(content={@Content(mediaType="text/yaml", schema=@Schema(type="string", format="binary", description="YAML file content")), @Content(mediaType="text/x-yaml", schema=@Schema(type="string", format="binary", description="YAML file content")), @Content(mediaType="text/yml", schema=@Schema(type="string", format="binary", description="YAML file content")), @Content(mediaType="application/x-yaml", schema=@Schema(type="string", format="binary", description="YAML file content")), @Content(mediaType="application/x-yml", schema=@Schema(type="string", format="binary", description="YAML file content")), @Content(mediaType="application/yaml", schema=@Schema(type="string", format="binary", description="YAML file content")), @Content(mediaType="application/yml", schema=@Schema(type="string", format="binary", description="YAML file content")), @Content(mediaType="application/zip", schema=@Schema(type="string", format="binary", description="ZIP file containing schemas"))}), responses={@ApiResponse(responseCode="201", description="Import successful", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ImportResponse.class)))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="404", description="Not Found", content={@Content}), @ApiResponse(responseCode="409", description="Conflict", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="412", description="Precondition Failed", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="415", description="Unsupported media type")})
    @PostMapping(path={"{targetRepo}/graphql/manage/endpoints/import"}, produces={"application/json"}, consumes={"text/yaml", "text/x-yaml", "text/yml", "application/x-yaml", "application/x-yml", "application/yaml", "application/yml", "application/zip"})
    public ResponseEntity<?> importSchema(@Parameter(description="Target repository") @PathVariable(value="targetRepo") String targetRepo, @org.springframework.web.bind.annotation.RequestBody byte[] importFile, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws Exception {
        return (ResponseEntity)this.proxyToRemoteSesame.proxyWithBodyToRemoteIfNeeded((Object)importFile, servletRequest, servletResponse, targetRepo, this.semanticDataManagement, () -> {
            String contentType;
            String selector0$temp = contentType = servletRequest.getContentType();
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"text/yaml", "text/x-yaml", "text/yml", "application/x-yaml", "application/x-yml", "application/yaml", "application/yml", "application/zip"}, (Object)selector0$temp, index$1)) {
                case 0, 1, 2, 3, 4, 5, 6 -> new ResponseEntity((Object)this.serviceEndpoint.importYamlSchema(targetRepo, importFile), (MultiValueMap)JSON_HEADER, (HttpStatusCode)HttpStatus.CREATED);
                case 7 -> new ResponseEntity((Object)this.serviceEndpoint.importSchemasFromZip(targetRepo, importFile), (MultiValueMap)JSON_HEADER, (HttpStatusCode)HttpStatus.CREATED);
                default -> throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNSUPPORTED_MEDIA_TYPE, "Unsupported content type: " + contentType);
            };
        });
    }

    @PostMapping(path={"{targetRepo}/graphql/manage/endpoints/import"}, produces={"application/json"}, consumes={"multipart/form-data"})
    public ResponseEntity<?> importSchema(@Parameter(description="Target repository") @PathVariable(value="targetRepo") String targetRepo, @RequestBody(description="The files to upload") @org.springframework.web.bind.annotation.RequestBody MultipartFile[] importFiles, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws Exception {
        return (ResponseEntity)this.proxyToRemoteSesame.proxyWithBodyToRemoteIfNeeded((Object)importFiles, servletRequest, servletResponse, targetRepo, this.semanticDataManagement, () -> new ResponseEntity(this.serviceEndpoint.importMultipartFiles(targetRepo, importFiles), (MultiValueMap)JSON_HEADER, (HttpStatusCode)HttpStatus.CREATED));
    }

    @Operation(summary="Validate GraphQL Endpoint without saving it", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=GraphQLEndpointReport.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="409", description="Conflict", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="412", description="Precondition Failed", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @PostMapping(path={"/graphql/manage/validate"}, consumes={"text/yaml"}, produces={"application/json"})
    public ResponseEntity<?> validate(@RequestBody(description="SOML to validate") @org.springframework.web.bind.annotation.RequestBody String schema, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws Exception {
        SemanticLocation semanticLocation = this.semanticDataManagement.getLocationFromHeaderOrThrow();
        if (semanticLocation.getLocationType() == LocationType.GDB) {
            return (ResponseEntity)this.proxyToRemoteSesame.proxyWithBodyToRemoteIfNeeded((Object)schema, servletRequest, servletResponse, semanticLocation, () -> new ResponseEntity((Object)this.serviceEndpoint.validateGraphQLSchema(schema), (MultiValueMap)JSON_HEADER, (HttpStatusCode)HttpStatus.OK));
        }
        return ResponseEntity.badRequest().body((Object)"This feature is supported only for attached remote locations of GraphDB type");
    }

    @Operation(summary="Validate Endpoint definition data", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ValidationJob.class, example="        {\n          \"id\": \"job-12345\",\n          \"schemaId\": \"schema-abc123\",\n          \"repository\": \"my-repository\",\n          \"createdOn\": \"2025-04-01T10:00:00Z\",\n          \"completedOn\": \"2025-04-02T15:30:00Z\",\n          \"canceledOn\": null,\n          \"totalTasks\": 100,\n          \"remainingTasks\": 20,\n          \"infoTasks\": 50,\n          \"warningTasks\": 25,\n          \"failedTasks\": 5\n        }\n"))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="404", description="Not Found", content={@Content}), @ApiResponse(responseCode="409", description="Conflict", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="412", description="Precondition Failed", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @GetMapping(path={"{repository}/graphql/manage/endpoints/{endpointId}/validate"}, produces={"application/json"})
    public ResponseEntity<?> validateAgainstDataNow(@Parameter(description="Target repository", required=true) @PathVariable(value="repository") String repository, @Parameter(description="Schema identifier", required=true) @PathVariable(value="endpointId") String endpointId, @Parameter(description="Fetch tasks", schema=@Schema(type="string", defaultValue="true", allowableValues={"true", "false", "failed"})) @RequestParam(name="all", required=false, defaultValue="true") String fetchTasks, @Parameter(description="Object types to validate", array=@ArraySchema(uniqueItems=true, schema=@Schema(type="string"))) @RequestParam(name="type", required=false) Set<String> types, @Parameter(description="Properties to validate", array=@ArraySchema(uniqueItems=true, schema=@Schema(type="string"))) @RequestParam(name="property", required=false) Set<String> properties, @Parameter(description="Validations to run", array=@ArraySchema(uniqueItems=true, schema=@Schema(type="string", allowableValues={"maxCardinalityAdvice", "objectPropertyRangeMismatch", "propertyMaxCardinality", "propertyMinCardinality", "scalarPropertyMismatch", "typeValidation"}))) @RequestParam(name="validation", required=false) Set<String> validations, @Parameter(description="Invalid data limit to fetch", schema=@Schema(implementation=Long.class, defaultValue="1000")) @RequestParam(name="dataLimit", required=false, defaultValue="1000") Long limit, @Parameter(description="Offset of the invalid data to fetch", schema=@Schema(implementation=Long.class, defaultValue="0")) @RequestParam(name="dataOffset", required=false, defaultValue="0") Long offset, @Parameter(description="Validation timeout in seconds", schema=@Schema(implementation=Integer.class, defaultValue="300")) @RequestParam(name="timeout", required=false, defaultValue="300") Integer timeout, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws Exception {
        return (ResponseEntity)this.proxyToRemoteSesame.proxyToRemoteIfNeeded(servletRequest, servletResponse, repository, this.semanticDataManagement, () -> new ResponseEntity((Object)this.serviceEndpoint.validateSchema(repository, validations, endpointId, fetchTasks, types, properties, limit, offset, timeout), (MultiValueMap)JSON_HEADER, (HttpStatusCode)HttpStatus.OK));
    }

    private String getExportFileName(String repository) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss");
        return repository + "-schemas-" + LocalDateTime.now().format(formatter) + ".zip";
    }

    static {
        YAML_HEADER.setContentType(ExtendedMediaType.YAML);
        JSON_HEADER.setContentType(ExtendedMediaType.APPLICATION_JSON);
    }
}

