/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.graphql.cluster;

import com.github.jsonldjava.utils.JsonUtils;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.semantic.SemanticLocation;
import com.ontotext.forest.core.util.PropertyChangedEvent;
import com.ontotext.forest.graphql.GraphDBGraphQLRequestContext;
import com.ontotext.forest.graphql.GraphQLService;
import com.ontotext.forest.graphql.cluster.GraphQLLoadBalancer;
import com.ontotext.forest.graphql.controller.responses.GraphQLEndpoint;
import com.ontotext.graphdb.raft.grpc.Data;
import com.ontotext.graphdb.raft.grpc.GraphQLQuery;
import com.ontotext.graphdb.raft.observe.RaftObserver;
import com.ontotext.graphdb.replicationcluster.LocalConsistency;
import com.ontotext.graphdb.statistics.StatisticsListener;
import com.ontotext.graphdb.statistics.models.GraphQL;
import com.ontotext.metamodel.storage.SomlStoreException;
import com.ontotext.metamodel.storage.UnreachableStoreException;
import com.ontotext.raft.GraphDBReplicationCluster;
import com.ontotext.raft.evaluate.ClosableClusterQueryIterator;
import com.ontotext.raft.repository.ClusterRepositoryManager;
import com.ontotext.soaas.common.ErrorCode;
import com.ontotext.soaas.common.concurrent.Timer;
import com.ontotext.soaas.common.exceptions.BadRequestException;
import com.ontotext.soaas.common.exceptions.PlatformConfigurationException;
import com.ontotext.soaas.common.exceptions.PlatformQueryExecutionException;
import com.ontotext.soaas.common.exceptions.QueryEvaluationException;
import com.ontotext.soaas.common.logging.Loggers;
import com.ontotext.soaas.query.service.GraphQlQueryRequest;
import com.ontotext.soaas.query.service.QueryService;
import com.ontotext.soaas.query.service.RequestConfig;
import com.ontotext.trree.OwlimSchemaRepository;
import com.ontotext.trree.monitorRepository.MonitorRepository;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Pattern;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.commons.io.IOUtils;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;

@Component
public class LoadBalancedGraphQLServiceEndpoint
implements ApplicationListener<PropertyChangedEvent> {
    private static final Logger logger = Loggers.graphqlLogger();
    private static final Pattern MUTATION_NO_OP_PATTERN = Pattern.compile("\\bmutation\\b(?:\\s+\\w+)?(?:\\s*\\([^)]*\\))?\\s*\\{", 34);
    private final GraphQLService serviceEndpoint;
    private final SemanticDataManagement semanticDataManagement;
    private boolean serverInitialized;
    private final CountDownLatch initLatch = new CountDownLatch(1);
    private volatile Boolean hasCluster;
    private GraphQLLoadBalancer loadBalancer;

    @Autowired
    public LoadBalancedGraphQLServiceEndpoint(GraphQLService serviceEndpoint, SemanticDataManagement semanticDataManagement) {
        this.serviceEndpoint = serviceEndpoint;
        this.semanticDataManagement = semanticDataManagement;
    }

    public List<GraphQLEndpoint> getActiveEndpoints(String repository) throws UnreachableStoreException {
        this.waitServerInit();
        return this.serviceEndpoint.getActiveEndpoints(repository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluateQuery(String repository, String schemaId, GraphQlQueryRequest queryRequest, RequestConfig config, HttpServletResponse servletResponse) throws SomlStoreException {
        this.waitServerInit();
        this.serviceEndpoint.ensureEndpointIsActive(repository, schemaId);
        Timer timer = Timer.start();
        if (schemaId != null) {
            logger.debug("[{}/{}] Incoming query: {}", new Object[]{repository, schemaId, queryRequest});
        } else {
            logger.debug("[{}]Incoming query: {}", (Object)repository, (Object)queryRequest);
        }
        boolean isMutation = LoadBalancedGraphQLServiceEndpoint.isMutation(queryRequest);
        GraphDBGraphQLRequestContext.setGraphqlRequest(queryRequest.toString());
        if (!this.isClusterEnabled() || isMutation) {
            if (this.loadBalancer != null) {
                this.loadBalancer.incrementQueryCount();
            }
            try {
                this.handleRequestLocally(repository, schemaId, queryRequest, config, servletResponse, isMutation);
            }
            finally {
                if (this.loadBalancer != null) {
                    this.loadBalancer.decrementQueryCount();
                }
            }
        } else {
            this.loadBalanceRequest(repository, schemaId, queryRequest, config, servletResponse);
        }
        logger.debug("Query processed in: {} ms.", (Object)timer.getDuration());
    }

    private void waitServerInit() {
        if (!this.serverInitialized) {
            try {
                logger.warn("Waiting for server to be initialized..");
                this.initLatch.await();
                logger.warn("done");
            }
            catch (InterruptedException ie) {
                throw new IllegalStateException(ie);
            }
        }
    }

    private synchronized boolean isClusterEnabled() {
        if (this.hasCluster == null) {
            this.hasCluster = this.semanticDataManagement.isClusterExisting();
            if (this.hasCluster.booleanValue() && this.loadBalancer == null) {
                this.loadBalancer = this.createClusterLoadBalancer();
            }
        }
        return this.hasCluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBalanceRequest(String repository, String schemaId, GraphQlQueryRequest queryRequest, RequestConfig config, HttpServletResponse servletResponse) {
        ServletOutputStream outputStream;
        GraphQLQuery.Builder builder = this.buildGraphQLQueryRequest(repository, schemaId, queryRequest, config);
        Iterator<Data> iterator = null;
        try {
            iterator = this.loadBalancer.evaluateQuery(builder.build(), LocalConsistency.LAST_COMMITTED);
        }
        catch (RuntimeException re) {
            logger.error("Could not evaluate query on other node. Handling it locally", (Throwable)re);
        }
        if (iterator == null) {
            this.loadBalancer.incrementQueryCount();
            try {
                this.handleRequestLocally(repository, schemaId, queryRequest, config, servletResponse, false);
            }
            finally {
                this.loadBalancer.decrementQueryCount();
            }
            return;
        }
        LoadBalancedGraphQLServiceEndpoint.addHeadersToResponse(config, servletResponse);
        try {
            outputStream = servletResponse.getOutputStream();
        }
        catch (IOException ioe) {
            this.incrementFailedQueryStatistics(repository, false);
            logger.error("Response stream already used: {}", (Object)ioe.getMessage());
            return;
        }
        try {
            Timer timer = Timer.start();
            if (iterator instanceof ClosableClusterQueryIterator) {
                try (ClosableClusterQueryIterator closableResultIterator = (ClosableClusterQueryIterator)iterator;){
                    this.iterateQueryResult((Iterator<Data>)closableResultIterator, (OutputStream)outputStream);
                }
            } else {
                this.iterateQueryResult(iterator, (OutputStream)outputStream);
            }
            logger.debug("Response send to client in {} ms.", (Object)timer.getDuration());
        }
        catch (Exception ioe) {
            this.incrementFailedQueryStatistics(repository, false);
            try {
                servletResponse.sendError(500, ioe.getMessage());
            }
            catch (IOException nestedEx) {
                ioe.addSuppressed(nestedEx);
                logger.error("Unable to write response to client", (Throwable)ioe);
            }
        }
    }

    private void iterateQueryResult(Iterator<Data> resultIterator, OutputStream out) throws IOException {
        while (resultIterator.hasNext()) {
            Data data = resultIterator.next();
            if (!data.getError().isEmpty()) {
                throw new org.eclipse.rdf4j.query.QueryEvaluationException(data.getError());
            }
            if (!data.getWarn().isEmpty()) {
                logger.warn(data.getWarn());
            }
            out.write(data.getData().toByteArray());
        }
    }

    @NotNull
    private GraphQLQuery.Builder buildGraphQLQueryRequest(String repository, String schemaId, GraphQlQueryRequest queryRequest, RequestConfig config) {
        GraphQLQuery.Builder builder = GraphQLQuery.newBuilder().setRepository(repository).setMime(config.getAcceptType());
        if (schemaId != null) {
            builder.setSchema(schemaId);
        }
        builder.setQuery(queryRequest.getQuery());
        queryRequest.getOperationName().ifPresent(arg_0 -> ((GraphQLQuery.Builder)builder).setOperationName(arg_0));
        queryRequest.getVariables().ifPresent(vars -> {
            try {
                String variablesString = JsonUtils.toString((Object)vars);
                builder.setVariables(variablesString);
            }
            catch (IOException ioe) {
                logger.warn("Cannot serialize variables!", (Throwable)ioe);
                throw new QueryEvaluationException("Cannot serialize variables!", ErrorCode.INVALID_VARIABLES);
            }
        });
        return builder;
    }

    public static boolean isMutation(GraphQlQueryRequest queryRequest) {
        Pattern mutationCheckPattern = queryRequest.getOperationName().map(opName -> Pattern.compile("\\bmutation\\b\\s+" + Pattern.quote(opName), 2)).orElse(MUTATION_NO_OP_PATTERN);
        return mutationCheckPattern.matcher(queryRequest.getQuery()).find();
    }

    private void handleRequestLocally(String repository, String schemaId, GraphQlQueryRequest queryRequest, RequestConfig config, HttpServletResponse servletResponse, boolean isMutation) {
        Object graphQlResponse;
        try {
            LoadBalancedGraphQLServiceEndpoint.checkIntrospectionResponseType(queryRequest, config.getAcceptType());
        }
        catch (BadRequestException e) {
            this.incrementFailedQueryStatistics(repository, isMutation);
            throw e;
        }
        QueryService service = this.serviceEndpoint.getServiceManager().getQueryService(repository, schemaId);
        try {
            graphQlResponse = service.evaluateQuery(queryRequest, config);
        }
        catch (PlatformQueryExecutionException pqee) {
            HttpStatus responseStatus = HttpStatus.valueOf((int)pqee.getHttpStatus());
            LoadBalancedGraphQLServiceEndpoint.writeResponse(pqee.getResponse(), config, responseStatus, servletResponse);
            this.incrementFailedQueryStatistics(repository, isMutation);
            return;
        }
        if (graphQlResponse == null) {
            this.incrementFailedQueryStatistics(repository, isMutation);
            throw new PlatformConfigurationException("Unknown error! Failed to produce a response", ErrorCode.COULD_NOT_PRODUCE_RESPONSE);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("SPARQL Response for Query: \n{}", (Object)LoadBalancedGraphQLServiceEndpoint.responseAsString(graphQlResponse));
        }
        LoadBalancedGraphQLServiceEndpoint.writeResponse(graphQlResponse, config, HttpStatus.OK, servletResponse);
        this.incrementSuccessfulQueryStatistics(repository, isMutation);
    }

    private static void checkIntrospectionResponseType(GraphQlQueryRequest queryRequest, String acceptType) {
        if (queryRequest.isIntrospectionRequest() && !"application/json".equals(acceptType)) {
            throw new BadRequestException(String.format("Cannot produce '%s' introspection response. Use 'Accept: %s'", acceptType, "application/json"), ErrorCode.INVALID_INTROSPECTION_REQUEST);
        }
    }

    private static void writeResponse(Object graphQlResponse, RequestConfig config, HttpStatus responseStatus, HttpServletResponse servletResponse) {
        ServletOutputStream outputStream;
        LoadBalancedGraphQLServiceEndpoint.addHeadersToResponse(config, servletResponse);
        servletResponse.setStatus(responseStatus.value());
        Timer timer = Timer.start();
        try {
            outputStream = servletResponse.getOutputStream();
        }
        catch (IOException ioe) {
            logger.error("Response stream already used: {}", (Object)ioe.getMessage());
            return;
        }
        try {
            if (graphQlResponse instanceof String) {
                IOUtils.write((String)graphQlResponse.toString(), (OutputStream)outputStream, (Charset)StandardCharsets.UTF_8);
            } else {
                JsonUtils.write((Writer)new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8), (Object)graphQlResponse);
            }
        }
        catch (IOException ioe) {
            if (ioe.getCause() instanceof ClientAbortException) {
                logger.error("Request handling aborted by the client: {}", (Object)ioe.getCause().getMessage());
            }
            try {
                servletResponse.sendError(500, ioe.getMessage());
            }
            catch (IOException nestedEx) {
                ioe.addSuppressed(nestedEx);
                logger.error("Unable to write response to client", (Throwable)ioe);
            }
        }
        logger.debug("Response send to client in {} ms.", (Object)timer.getDuration());
    }

    private static void addHeadersToResponse(RequestConfig config, HttpServletResponse servletResponse) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)config.getAcceptType()));
        headers.forEach((header, values) -> values.forEach(value -> servletResponse.addHeader(header, value)));
    }

    private static String responseAsString(Object graphQlResponse) {
        String stringResponse = null;
        if (!(graphQlResponse instanceof String)) {
            try {
                stringResponse = JsonUtils.toString((Object)graphQlResponse);
            }
            catch (IOException ioe) {
                logger.warn("Could not print query response due to:", (Throwable)ioe);
            }
        } else {
            stringResponse = graphQlResponse.toString();
        }
        return stringResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(PropertyChangedEvent event) {
        if ("semantic.locations.initialized".equals(event.getKey())) {
            this.serverInitialized = true;
            this.initLatch.countDown();
            return;
        }
        if (this.serverInitialized) {
            LoadBalancedGraphQLServiceEndpoint loadBalancedGraphQLServiceEndpoint = this;
            synchronized (loadBalancedGraphQLServiceEndpoint) {
                if ("cluster.created".equals(event.getKey())) {
                    this.loadBalancer = this.createClusterLoadBalancer();
                    this.hasCluster = true;
                } else if ("cluster.deleted".equals(event.getKey())) {
                    try {
                        if (this.loadBalancer != null) {
                            this.loadBalancer.shutdown();
                        }
                    }
                    finally {
                        this.hasCluster = false;
                        this.loadBalancer = null;
                    }
                }
            }
        }
    }

    @NotNull
    private GraphQLLoadBalancer createClusterLoadBalancer() {
        RepositoryManager repositoryManager = this.semanticDataManagement.getCurrentLocationOrThrow().sesameManager();
        if (repositoryManager instanceof ClusterRepositoryManager) {
            ClusterRepositoryManager clusterRepositoryManager = (ClusterRepositoryManager)repositoryManager;
            GraphDBReplicationCluster replicationCluster = clusterRepositoryManager.getReplicationCluster();
            GraphQLLoadBalancer loadBalancer = new GraphQLLoadBalancer(replicationCluster.getClusterGroup(), repositoryManager);
            replicationCluster.addClusterObserver((RaftObserver)loadBalancer);
            loadBalancer.start();
            return loadBalancer;
        }
        throw new IllegalStateException("Cluster not initialized");
    }

    private void incrementSuccessfulQueryStatistics(String repository, boolean isMutation) {
        GraphQL graphQLStatistics = this.getGraphQlStatisticsPerRepo(repository);
        if (graphQLStatistics != null) {
            if (isMutation) {
                graphQLStatistics.incrementSuccessfulWrites();
            } else {
                graphQLStatistics.incrementSuccessfulReads();
            }
        }
    }

    private void incrementFailedQueryStatistics(String repository, boolean isMutation) {
        GraphQL graphQLStatistics = this.getGraphQlStatisticsPerRepo(repository);
        if (graphQLStatistics != null) {
            if (isMutation) {
                graphQLStatistics.incrementFailedWrites();
            } else {
                graphQLStatistics.incrementFailedReads();
            }
        }
    }

    private GraphQL getGraphQlStatisticsPerRepo(String repository) {
        SemanticLocation semanticLocation = this.semanticDataManagement.getCurrentLocationOrThrow();
        if (semanticLocation == null) {
            return null;
        }
        RepositoryManager repositoryManager = semanticLocation.sesameManager();
        Repository repo = repositoryManager.getRepository(repository);
        if (!(repo instanceof MonitorRepository)) {
            return null;
        }
        MonitorRepository monitorRepository = (MonitorRepository)repo;
        OwlimSchemaRepository owlim = monitorRepository.getOwlimSail();
        if (owlim == null) {
            return null;
        }
        StatisticsListener statistics = owlim.getStatistics();
        if (statistics == null || !statistics.areStatisticsEnabled()) {
            return null;
        }
        return statistics.getRepositoryStatistics().getOperations().getGraphQL();
    }
}

