/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.graphql;

import com.github.jsonldjava.utils.JsonUtils;
import com.google.common.annotations.VisibleForTesting;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.semantic.SemanticLocation;
import com.ontotext.forest.core.semantic.repository.SemanticRepository;
import com.ontotext.forest.core.util.PropertyChangedEvent;
import com.ontotext.forest.graphql.GraphDBGraphQLRequestContext;
import com.ontotext.forest.graphql.GraphQLPlugin;
import com.ontotext.forest.graphql.controller.requests.EndpointOptions;
import com.ontotext.forest.graphql.controller.requests.UpdateEndpointRequest;
import com.ontotext.forest.graphql.controller.responses.BaseResponse;
import com.ontotext.forest.graphql.controller.responses.ConfigOption;
import com.ontotext.forest.graphql.controller.responses.GraphQLEndpoint;
import com.ontotext.forest.graphql.controller.responses.GraphQLEndpointReport;
import com.ontotext.forest.graphql.controller.responses.ImportResponse;
import com.ontotext.forest.graphql.controller.responses.ResponseMapper;
import com.ontotext.forest.graphql.controller.responses.ValidationMessages;
import com.ontotext.forest.graphql.security.GraphQLAdminAwareSecurityConfigurer;
import com.ontotext.forest.security.SecurityConfig;
import com.ontotext.forest.security.utils.SecurityUtils;
import com.ontotext.forest.sparql.GraphQLSparqlConnectionFactory;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.GraphDBHTTPContext;
import com.ontotext.graphdb.ServerMaintenanceListener;
import com.ontotext.graphdb.graphql.GraphDB2SemanticObjectsConfigurationResolver;
import com.ontotext.graphdb.graphql.GraphQLModelNotifiable;
import com.ontotext.graphdb.graphql.GraphQLModelNotificationManager;
import com.ontotext.graphdb.graphql.GraphQLSecurityConfigurer;
import com.ontotext.graphdb.graphql.GraphQLServiceManager;
import com.ontotext.graphdb.graphql.RdfToSomlConversionManager;
import com.ontotext.graphdb.security.Role;
import com.ontotext.graphdb.statistics.models.enums.EndpointCreationType;
import com.ontotext.metamodel.storage.MalformedSomlException;
import com.ontotext.metamodel.storage.SchemaEntity;
import com.ontotext.metamodel.storage.SomlIdManager;
import com.ontotext.metamodel.storage.SomlNotFoundException;
import com.ontotext.metamodel.storage.SomlSchemaStorage;
import com.ontotext.metamodel.storage.SomlStoreException;
import com.ontotext.metamodel.storage.UnreachableStoreException;
import com.ontotext.models.Configs;
import com.ontotext.models.Rbac;
import com.ontotext.models.Roles;
import com.ontotext.models.SchemaLangConfig;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.SomlSchemaParser;
import com.ontotext.models.SparqlFederatedServicesPriority;
import com.ontotext.models.ValidatingException;
import com.ontotext.models.extensions.ConfigurationResolver;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.query.InputValueConverter;
import com.ontotext.models.yaml.YamlParseException;
import com.ontotext.platform.owl2soml.SomlOntology;
import com.ontotext.rbac.RbacOptions;
import com.ontotext.soaas.common.ErrorCode;
import com.ontotext.soaas.common.exceptions.BadRequestException;
import com.ontotext.soaas.common.exceptions.ResourceNotFoundException;
import com.ontotext.soaas.experimental.ExperimentalFeatures;
import com.ontotext.soaas.plugin.PluginsManager;
import com.ontotext.sparql.Rdf4jInputValueConverter;
import com.ontotext.sparql.SparqlConnectionFactory;
import com.ontotext.sparql.SparqlEndpointRequestContext;
import com.ontotext.trree.monitorRepository.MonitorRepository;
import com.ontotext.trree.sdk.Plugin;
import com.ontotext.validator.SomlSchemaValidator;
import com.ontotext.validator.data.ImmediateValidation;
import com.ontotext.validator.data.ValidationJob;
import com.ontotext.validator.data.ValidationSteps;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.manager.LocalRepositoryManager;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.helpers.SailWrapper;
import org.eclipse.rdf4j.sail.shacl.GraphDBShaclSail;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ResponseStatusException;
import org.yaml.snakeyaml.reader.ReaderException;

@Component
public class GraphQLService
implements ApplicationListener<PropertyChangedEvent>,
ApplicationContextAware,
ServerMaintenanceListener {
    public static final String GENERIC_GROUP = "generic";
    public static final String SECURITY_GROUP = "security";
    public static final String DATA_CLEANUP_GROUP = "dataCleanup";
    public static final String GRAPHQL_GROUP = "graphql";
    public static final String INTEGRATION_GROUP = "integration";
    public static final String ENDPOINT_CONFIGURATIONS = "Endpoint configurations";
    public static final String DEPLOYMENT_CONFIGURATIONS = "Deployment configurations";
    public static final String SUCCESSFUL_IMPORT_MESSAGE = "Successfully imported endpoint definition: %s";
    public static final String FAILED_PROCESSING_MESSAGE = "Failed to process file: %s";
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(ZoneId.of("Z"));
    private final SemanticDataManagement semanticDataManagement;
    private final SecurityConfig securityConfig;
    private GraphQLSparqlConnectionFactory readOnlyConnectionFactory;
    private GraphQLSparqlConnectionFactory writeableConnectionFactory;
    private GraphQLServiceManager serviceManager;
    private volatile boolean serverInitialized;
    private CountDownLatch initLatch = new CountDownLatch(1);
    private final SomlSchemaParser schemaParser = new SomlSchemaParser();
    public static final Map<String, ConfigOption> GENERATE_CONFIG_INFO_MAP;
    private static final Map<String, ConfigOption> ENDPOINT_CONFIG_INFO_MAP;
    private static final SparqlEndpointRequestContext.ThreadLocalStateCopier<String> TRACK_ALIAS;
    private static final SparqlEndpointRequestContext.ThreadLocalStateCopier<String> GRAPHQL_REQUEST;
    private static final SparqlEndpointRequestContext.ThreadLocalStateCopier<SecurityContext> SECURITY_CONTEXT;

    @Autowired
    public GraphQLService(SemanticDataManagement semanticDataManagement, SecurityConfig securityConfig) {
        this.semanticDataManagement = semanticDataManagement;
        this.securityConfig = securityConfig;
        this.configureExtensions();
    }

    public void onApplicationEvent(@NotNull PropertyChangedEvent event) {
        if (this.serverInitialized && "security.enabled".equals(event.getKey())) {
            boolean securityEnabled = Boolean.parseBoolean(event.getValue());
            LOGGER.info("{} security for GraphQL endpoint", (Object)(securityEnabled ? "Enable" : "Disable"));
            this.serviceManager.configureSecurity(securityEnabled);
            return;
        }
        if ("semantic.locations.initialized".equals(event.getKey())) {
            this.readOnlyConnectionFactory = GraphQLService.createConnectionFactory(this.semanticDataManagement);
            this.writeableConnectionFactory = GraphQLService.createConnectionFactory(this.semanticDataManagement);
            this.unlockAfterMaintenance();
            return;
        }
        if (this.serverInitialized && "repository.id.deleted".equals(event.getKey())) {
            this.serviceManager.unloadRepository(event.getValue());
            this.readOnlyConnectionFactory.reset();
            this.writeableConnectionFactory.reset();
            return;
        }
        if (this.serverInitialized) {
            if ("cluster.created".equals(event.getKey())) {
                this.serviceManager.clusterChanged(true);
                this.readOnlyConnectionFactory.reset();
                this.writeableConnectionFactory.reset();
            } else if ("cluster.deleted".equals(event.getKey())) {
                this.serviceManager.clusterChanged(false);
                this.readOnlyConnectionFactory.reset();
                this.writeableConnectionFactory.reset();
            }
        }
    }

    public List<GraphQLEndpoint> getActiveEndpoints(String repository) throws UnreachableStoreException {
        SomlSchemaStorage storage = this.getServiceManager().getStorage(repository);
        return storage.getAll().stream().filter(SchemaEntity::getActive).filter(entry -> entry.getErrors() == 0).map(entry -> this.createDetailedEndpoint(repository, (SchemaEntity)entry, GraphQLEndpoint::new)).toList();
    }

    public List<GraphQLEndpoint> getAllEndpoints(String repository) throws UnreachableStoreException {
        SomlSchemaStorage storage = this.getServiceManager().getStorage(repository);
        return storage.getAll().stream().map(entry -> this.createDetailedEndpoint(repository, (SchemaEntity)entry, GraphQLEndpoint::new)).toList();
    }

    public List<GraphQLEndpointReport> getAllEndpointsReport(String repository) throws UnreachableStoreException {
        SomlSchemaStorage storage = this.getServiceManager().getStorage(repository);
        return storage.getAll().stream().map(entry -> this.createDetailedEndpoint(repository, (SchemaEntity)entry, GraphQLEndpointReport::new)).toList();
    }

    public GraphQLEndpointReport getEndpointReport(String repository, String schemaId) throws SomlStoreException {
        SomlSchemaStorage storage = this.getServiceManager().getStorage(repository);
        String somlId = SomlIdManager.INSTANCE.referenceToSomlId(schemaId);
        SchemaEntity schemaEntity = (SchemaEntity)storage.getEntity(somlId).orElseThrow(() -> SomlNotFoundException.notFound((String)schemaId));
        return this.createDetailedEndpoint(repository, schemaEntity, GraphQLEndpointReport::new);
    }

    public void confirmEndpointReport(String repository, String schemaId) throws SomlStoreException {
        SomlSchemaStorage storage = this.getServiceManager().getStorage(repository);
        String somlId = SomlIdManager.INSTANCE.referenceToSomlId(schemaId);
        SchemaEntity schemaEntity = (SchemaEntity)storage.getEntity(somlId).orElseThrow(() -> SomlNotFoundException.notFound((String)schemaId));
        schemaEntity.setWarnings(0);
        schemaEntity.setErrors(0);
        schemaEntity.setWarningsMessage(null);
        schemaEntity.setErrorsMessage(null);
        storage.update(somlId, schemaEntity);
    }

    @VisibleForTesting
    public void applyConfiguration(SchemaEntity schemaEntity, EndpointOptions configOptions) {
        SomlSchema schema = this.schemaParser.parse(schemaEntity.getOriginalDefinition());
        schema.startTracking();
        this.applyEndpointOptions(schema.getConfig(), configOptions);
        schemaEntity.setOriginalDefinition(schema.toYaml());
        schemaEntity.setSomlSchema(schema);
    }

    public List<ConfigOption> getSchemaGenerationOptions() {
        return GENERATE_CONFIG_INFO_MAP.values().stream().toList();
    }

    public List<ConfigOption> getEndpointOptions(String repository, String schemaId) throws UnreachableStoreException, MalformedSomlException, SomlNotFoundException {
        SomlSchemaStorage storage = this.getServiceManager().getStorage(repository);
        SomlSchema schema = (SomlSchema)storage.getParsed(SomlIdManager.INSTANCE.referenceToSomlId(schemaId)).orElseThrow(() -> SomlNotFoundException.notFound((String)schemaId));
        Configs config = schema.getConfig();
        return this.mapConfigOptions(config, schema.getRbac()).toList();
    }

    private <T extends GraphQLEndpoint> T createDetailedEndpoint(String repository, SchemaEntity entity, Function<String, T> constructor) {
        GraphQLEndpoint endpoint = (GraphQLEndpoint)constructor.apply(entity.getSchemaId());
        endpoint.setActive(entity.getActive() != null && entity.getActive() != false);
        if (StringUtils.isNotEmpty((CharSequence)repository)) {
            endpoint.setDefault(this.isSchemaDefault(repository, entity.getSchemaId()));
        }
        endpoint.setLabel(entity.getLabel());
        endpoint.setDescription(entity.getDescription());
        long lastModified = entity.getLastModified() != null ? entity.getLastModified() : System.currentTimeMillis();
        endpoint.setLastModified(DATE_TIME_FORMATTER.format(Instant.ofEpochMilli(lastModified)));
        endpoint.setObjectsCount(entity.getObjectsCount());
        endpoint.setPropertiesCount(entity.getPropertiesCount());
        endpoint.setWarnings(entity.getWarnings());
        endpoint.setErrors(entity.getErrors());
        endpoint.setEndpointCreationType(entity.getEndpointCreationType());
        if (endpoint instanceof GraphQLEndpointReport) {
            OperationResponse opResponse;
            GraphQLEndpointReport report = (GraphQLEndpointReport)endpoint;
            Pair<SomlSchema, OperationResponse> pair = this.parseSchema(entity.getOriginalDefinition());
            SomlSchema schema = (SomlSchema)pair.getLeft();
            if (schema != null) {
                report.setOptions(this.mapConfigsToEndpointOptions(schema.getConfig()));
            }
            if ((opResponse = (OperationResponse)pair.getRight()) != null) {
                List err = entity.getErrorsMessage() != null ? entity.getErrorsMessage() : List.of();
                List<String> errors = Stream.concat(opResponse.getErrors().stream().map(Objects::toString), err.stream()).distinct().toList();
                report.setMessages(new ValidationMessages(entity.getWarningsMessage(), errors));
            } else {
                report.setMessages(new ValidationMessages(entity.getWarningsMessage(), entity.getErrorsMessage()));
            }
        }
        return (T)endpoint;
    }

    public RdfToSomlConversionManager getRdfToSomlConversionManager() {
        return new RdfToSomlConversionManager((SparqlConnectionFactory)this.writeableConnectionFactory);
    }

    public GraphQLServiceManager getServiceManager() {
        if (!this.serverInitialized) {
            try {
                LOGGER.warn("Waiting for the GraphQL server to be initialized..");
                this.initLatch.await(5L, TimeUnit.MINUTES);
            }
            catch (InterruptedException ie) {
                throw new IllegalStateException(ie);
            }
        }
        return this.serviceManager;
    }

    protected GraphQLServiceManager createServiceManager() {
        GraphQLServiceManager serviceManager = new GraphQLServiceManager(GraphQLService.getBaseDir(this.semanticDataManagement), (SparqlConnectionFactory)this.readOnlyConnectionFactory, (SparqlConnectionFactory)this.writeableConnectionFactory);
        serviceManager.setGraphQLSecurityConfigurer((GraphQLSecurityConfigurer)new GraphQLAdminAwareSecurityConfigurer());
        serviceManager.configureSecurity(this.securityConfig.isEnabledSecurity());
        serviceManager.setSecurityContext((com.ontotext.rbac.SecurityContext)new GraphDB2SemanticObjectsSecurityContext());
        this.configureGraphQLPlugin(serviceManager);
        return serviceManager;
    }

    private void configureGraphQLPlugin(GraphQLServiceManager serviceManager) {
        serviceManager.setModelNotifierManager(new GraphQLModelNotificationManager(){

            public void register(String repositoryId, GraphQLModelNotifiable notifiable) {
                MonitorRepository monitorRepository;
                Plugin plugin;
                Repository repository = GraphQLService.this.semanticDataManagement.getCurrentLocationOrThrow().sesameManager().getRepository(repositoryId);
                if (repository instanceof MonitorRepository && (plugin = (monitorRepository = (MonitorRepository)repository).getOwlimSail().getPlugin("GraphQL")) instanceof GraphQLPlugin) {
                    GraphQLPlugin graphQLPlugin = (GraphQLPlugin)plugin;
                    graphQLPlugin.registerForModelUpdates(notifiable);
                }
            }

            public void unregister(String repositoryId, GraphQLModelNotifiable notifiable) {
                MonitorRepository monitorRepository;
                Plugin plugin;
                Repository repository = GraphQLService.this.semanticDataManagement.getCurrentLocationOrThrow().sesameManager().getRepository(repositoryId);
                if (repository instanceof MonitorRepository && (plugin = (monitorRepository = (MonitorRepository)repository).getOwlimSail().getPlugin("GraphQL")) instanceof GraphQLPlugin) {
                    GraphQLPlugin graphQLPlugin = (GraphQLPlugin)plugin;
                    graphQLPlugin.unregisterForModelUpdates(notifiable);
                }
            }
        });
    }

    protected void configureExtensions() {
        PluginsManager.addConfig(ConfigurationResolver.class, () -> GraphDB2SemanticObjectsConfigurationResolver.INSTANCE);
        PluginsManager.addConfig(RbacOptions.class, () -> () -> Role.ROLE_REPO_MANAGER.name());
        PluginsManager.addConfig(InputValueConverter.class, Rdf4jInputValueConverter::new);
        ExperimentalFeatures.configureFeatures((key, type) -> GraphDB2SemanticObjectsConfigurationResolver.INSTANCE.resolve(key, type, null));
    }

    @NotNull
    private static GraphQLSparqlConnectionFactory createConnectionFactory(SemanticDataManagement semanticDataManagement) {
        return new GraphQLSparqlConnectionFactory(() -> ((SemanticLocation)semanticDataManagement.getCurrentLocationOrThrow()).sesameManager());
    }

    @NotNull
    private static File getBaseDir(SemanticDataManagement semanticDataManagement) {
        RepositoryManager manager = semanticDataManagement.getCurrentLocationOrThrow().sesameManager();
        if (manager instanceof LocalRepositoryManager) {
            LocalRepositoryManager repositoryManager = (LocalRepositoryManager)manager;
            return repositoryManager.getBaseDir();
        }
        return new File(Config.getDataDirectory());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        PluginsManager.setBeanResolver(beanType -> applicationContext.getBeansOfType(beanType).values());
    }

    public void lockForMaintenance() {
        if (this.serverInitialized) {
            this.initLatch = new CountDownLatch(1);
            this.serverInitialized = false;
            LOGGER.info("Shutting down GraphQL server before recovery");
            try {
                this.serviceManager.shutdown();
            }
            finally {
                this.serviceManager = null;
            }
        }
    }

    public void unlockAfterMaintenance() {
        this.serviceManager = this.createServiceManager();
        this.serverInitialized = true;
        this.initLatch.countDown();
        LOGGER.info("GraphQL server initialized");
    }

    public int getOrderIndex() {
        return 10000;
    }

    public String registerNewEndpoint(String repository, String schemaId, String label, String description, EndpointCreationType endpointCreationType) {
        String somlId = SomlIdManager.INSTANCE.referenceToSomlId(schemaId);
        String schema = "id: " + somlId + "\n";
        try {
            if (this.getServiceManager().getStorage(repository).contains(somlId)) {
                return somlId;
            }
            this.createOrUpdateSchema(repository, schema, schemaEntity -> {
                schemaEntity.setActive(Boolean.valueOf(false));
                if (StringUtils.isNotBlank((CharSequence)label)) {
                    schemaEntity.setLabel(label);
                }
                if (StringUtils.isNotBlank((CharSequence)description)) {
                    schemaEntity.setDescription(description);
                }
                schemaEntity.setWarningsMessage(null);
                schemaEntity.setErrorsMessage(null);
                schemaEntity.setWarnings(0);
                schemaEntity.setErrors(0);
            }, endpointCreationType);
        }
        catch (UnreachableStoreException e) {
            throw new RuntimeException(e);
        }
        return somlId;
    }

    public GraphQLEndpointReport createOrUpdateSchema(String repository, String schema, Consumer<SchemaEntity> entityProcessor, EndpointCreationType endpointCreationType) {
        Pair<SomlSchema, OperationResponse> schemaPair = this.validateSchema(schema);
        SomlSchema somlSchema = this.getNonNullSchema((SomlSchema)schemaPair.getLeft(), schema);
        OperationResponse validationResponse = (OperationResponse)schemaPair.getRight();
        SchemaEntity entity = SchemaEntity.createSchemaEntity((String)schema, (SomlSchema)somlSchema, (OperationResponse)validationResponse, (String)endpointCreationType.toLower());
        if (entityProcessor != null) {
            entityProcessor.accept(entity);
        }
        String id = entity.getSchemaId();
        try {
            SomlSchemaStorage storage = this.getServiceManager().getStorage(repository);
            if (storage.contains(id)) {
                storage.update(id, entity);
            } else {
                storage.store(entity);
            }
            return this.createDetailedEndpoint(repository, (SchemaEntity)storage.getEntity(id).orElseThrow(() -> SomlNotFoundException.notFound((String)id)), GraphQLEndpointReport::new);
        }
        catch (SomlStoreException e) {
            throw new RuntimeException(e);
        }
    }

    public Set<IRI> getShaclGraphsForRepository(String repository) {
        MonitorRepository monitorRepository;
        Sail sail;
        SemanticLocation currentLocation = this.semanticDataManagement.getCurrentLocationOrThrow();
        SemanticRepository repo = currentLocation.getRepository(repository);
        Repository repository2 = repo.getRepository();
        if (repository2 instanceof MonitorRepository && (sail = this.unwrapToShaclSail((monitorRepository = (MonitorRepository)repository2).getSail())) instanceof GraphDBShaclSail) {
            GraphDBShaclSail shaclSail = (GraphDBShaclSail)sail;
            return shaclSail.getShapesGraphs();
        }
        return Collections.emptySet();
    }

    public void storeErrors(String entityId, String repository, List<String> errors) throws SomlStoreException {
        SomlSchemaStorage storage = this.getServiceManager().getStorage(repository);
        SchemaEntity entity = (SchemaEntity)storage.getEntity(entityId).orElseThrow(() -> SomlNotFoundException.notFound((String)entityId));
        String id = entity.getSchemaId();
        entity.setErrors(entity.getErrors() + errors.size());
        ArrayList<String> mergedErrors = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)entity.getErrorsMessage())) {
            mergedErrors.addAll(entity.getErrorsMessage());
        }
        mergedErrors.addAll(errors);
        entity.setErrorsMessage(mergedErrors);
        if (storage.contains(id)) {
            storage.update(id, entity);
        } else {
            storage.store(entity);
        }
    }

    public void deleteSchema(String repository, String endpoint) throws UnreachableStoreException {
        String somlId;
        SomlSchemaStorage storage = this.getServiceManager().getStorage(repository);
        if (storage.contains(somlId = SomlIdManager.INSTANCE.referenceToSomlId(endpoint))) {
            this.serviceManager.unregisterSchema(repository, endpoint);
            storage.delete(somlId);
            if (this.isSchemaDefault(repository, somlId)) {
                this.getServiceManager().setDefaultSchema(repository, null);
            }
        }
    }

    private Sail unwrapToShaclSail(Sail sail) {
        while (sail instanceof SailWrapper) {
            SailWrapper wrapper = (SailWrapper)sail;
            if (sail instanceof GraphDBShaclSail) break;
            sail = wrapper.getBaseSail();
        }
        return sail;
    }

    private Pair<SomlSchema, OperationResponse> validateSchema(String schema) {
        OperationResponse operationResponse;
        Pair<SomlSchema, OperationResponse> pair = this.parseSchema(schema);
        if (pair.getLeft() == null) {
            return pair;
        }
        SomlSchema somlSchema = (SomlSchema)pair.getLeft();
        SomlSchemaValidator schemaValidator = new SomlSchemaValidator();
        try {
            operationResponse = schemaValidator.validateSchema(somlSchema);
        }
        catch (ValidatingException ve) {
            return Pair.of((Object)somlSchema, (Object)ve.getValidationReport());
        }
        catch (RuntimeException re) {
            LOGGER.error("Schema validation failed with unhandled exception", (Throwable)re);
            operationResponse = this.handleSchemaValidationErrors(re);
        }
        return Pair.of((Object)somlSchema, (Object)operationResponse);
    }

    private OperationResponse handleSchemaValidationErrors(Throwable error) {
        OperationResponse operationResponse = new OperationResponse();
        if (error.getMessage() != null) {
            operationResponse.addError(error.getMessage());
        } else {
            for (Throwable throwable = error.getCause(); throwable != null; throwable = throwable.getCause()) {
                if (throwable.getMessage() == null) continue;
                operationResponse.addError(throwable.getMessage());
                break;
            }
            if (operationResponse.isValid()) {
                operationResponse.addError("Schema validation failed with unhandled exception");
            }
        }
        return operationResponse;
    }

    private Pair<SomlSchema, OperationResponse> parseSchema(String schema) {
        SomlSchema somlSchema;
        try {
            somlSchema = this.schemaParser.parse(schema);
        }
        catch (ValidatingException ise) {
            if (this.hasReaderExceptionAsCause(ise) || this.hasParserExceptionAsCause(ise)) {
                throw ise;
            }
            LOGGER.error("Schema parsing failed: {}", (Object)ise.getMessage());
            return Pair.of(null, (Object)ise.getValidationReport());
        }
        catch (RuntimeException re) {
            LOGGER.error("Schema parsing failed with unhandled exception", (Throwable)re);
            return Pair.of(null, (Object)this.handleSchemaValidationErrors(re));
        }
        return Pair.of((Object)somlSchema, null);
    }

    private Stream<ConfigOption> mapConfigOptions(Configs schemaConfig, Rbac rbac) {
        if (schemaConfig == null) {
            return ENDPOINT_CONFIG_INFO_MAP.values().stream();
        }
        return ENDPOINT_CONFIG_INFO_MAP.entrySet().stream().map(entry -> {
            String key = (String)entry.getKey();
            ConfigOption value = (ConfigOption)entry.getValue();
            if (key.startsWith("lang.") && schemaConfig.containsKey((Object)"lang")) {
                Object lang = schemaConfig.get((Object)"lang");
                if (lang instanceof SchemaLangConfig) {
                    SchemaLangConfig langConfig = (SchemaLangConfig)lang;
                    value.setValue(this.getLangConfigValue(key, langConfig));
                }
            } else if ("sparqlFederatedServices".equals(key)) {
                schemaConfig.getSparqlFederatedServices().map(services -> this.serializeToJson(services, "Error while writing SPARQL Federated Service")).or(() -> Optional.ofNullable(this.serializeToJson(Map.of(), "Error while writing empty SPARQL Federated Service"))).ifPresent(value::setValue);
            } else if ("sparqlFederatedServicesPriority".equals(key)) {
                schemaConfig.getSparqlFederatedServicesPriority().map(this::writeFederatedServicesPriority).ifPresent(value::setValue);
            } else if ("defaultRole".equals(key) && rbac != null && rbac.getRoles() != null) {
                String defaultRole;
                List<String> list = rbac.getRoles().keySet().stream().filter(arg_0 -> ((Roles)rbac.getRoles()).isTracked(arg_0)).collect(Collectors.toList());
                if (!list.contains(defaultRole = schemaConfig.getDefaultRole().orElse(Objects.toString(value.getValue(), "Default")))) {
                    list.addFirst(defaultRole);
                }
                value.setValues(list);
                value.setValue(defaultRole);
            } else {
                value.setValue(schemaConfig.getOrDefault((Object)key, value.getValue()));
            }
            return value;
        });
    }

    private Object getLangConfigValue(String key, SchemaLangConfig langConfig) {
        return switch (key) {
            case "lang.fetch" -> langConfig.getFetch();
            case "lang.validate" -> langConfig.getValidate();
            case "lang.implicit" -> langConfig.getImplicit();
            case "lang.defaultNameFetch" -> langConfig.getDefaultNameFetch();
            case "lang.appendDefaultNameFetch" -> langConfig.isAppendDefaultNameFetch();
            default -> null;
        };
    }

    private EndpointOptions mapConfigsToEndpointOptions(Configs configs) {
        EndpointOptions options = new EndpointOptions();
        configs.forEach((key, value) -> {
            switch (key) {
                case "enable_mutations": {
                    options.setEnableMutations((Boolean)value);
                    break;
                }
                case "lang": {
                    if (!(value instanceof SchemaLangConfig)) break;
                    SchemaLangConfig langConfig = (SchemaLangConfig)value;
                    options.setLangFetch(langConfig.getFetch());
                    options.setLangValidate(langConfig.getValidate());
                    options.setLangImplicit(langConfig.getImplicit());
                    options.setLangDefaultNameFetch(langConfig.getDefaultNameFetch());
                    options.setLangAppendDefaultNameFetch(langConfig.isAppendDefaultNameFetch());
                    break;
                }
                case "queryPfx": {
                    options.setQueryPrefix((String)value);
                    break;
                }
                case "mutationPfx": {
                    options.setMutationPrefix((String)value);
                    break;
                }
                case "includeInferred": {
                    options.setIncludeInferred((Boolean)value);
                    break;
                }
                case "expandOwlSameAs": {
                    options.setExpandOwlSameAs((Boolean)value);
                    break;
                }
                case "disabledChecks": {
                    options.setDisabledChecks((Boolean)value);
                    break;
                }
                case "defaultRole": {
                    options.setDefaultRole((String)value);
                    break;
                }
                case "exposeSomlInGraphQL": {
                    options.setExposeSomlInGraphQL((Boolean)value);
                    break;
                }
                case "enableCollectionCount": {
                    options.setEnableCollectionCount((Boolean)value);
                    break;
                }
                case "enableTypeCount": {
                    options.setEnableTypeCount((Boolean)value);
                    break;
                }
                case "compactErrorMessages": {
                    options.setCompactErrorMessages((Boolean)value);
                    break;
                }
                case "enableGraphQlExplain": {
                    options.setEnableGraphQLExplain((Boolean)value);
                    break;
                }
                case "sparqlFederatedServices": {
                    options.setSparqlFederatedServices(this.writeSparqlFederatedServices(value));
                    break;
                }
                case "sparqlFederatedServicesPriority": {
                    options.setSparqlFederatedServicesPriority(this.writeFederatedServicesPriority(value));
                }
            }
        });
        return options;
    }

    private String writeSparqlFederatedServices(Object sparqlFederatedServices) {
        if (sparqlFederatedServices instanceof Map) {
            Map services = (Map)sparqlFederatedServices;
            try {
                return JsonUtils.toString((Object)services);
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException("Unable to serialize Sparql Federated Services", ioe);
            }
        }
        return null;
    }

    private Map<String, String> readSparqlFederatedServices(String sparqlFederatedServices) {
        if (StringUtils.isBlank((CharSequence)sparqlFederatedServices)) {
            return Map.of();
        }
        try {
            Object services = JsonUtils.fromString((String)sparqlFederatedServices);
            if (services instanceof Map) {
                return (Map)services;
            }
            throw new IllegalArgumentException("Sparql Federated Services is not a JSON Map");
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Unable to parse Sparql Federated Services", ioe);
        }
    }

    private String writeFederatedServicesPriority(Object value) {
        SparqlFederatedServicesPriority priority;
        if (value == null) {
            return null;
        }
        if (value instanceof SparqlFederatedServicesPriority) {
            SparqlFederatedServicesPriority enumType;
            priority = enumType = (SparqlFederatedServicesPriority)value;
        } else if (value instanceof String) {
            priority = SparqlFederatedServicesPriority.fromCode((String)value.toString());
        } else {
            throw new IllegalArgumentException("Sparql Federated Services priority format is not supported");
        }
        return switch (priority) {
            default -> throw new MatchException(null, null);
            case SparqlFederatedServicesPriority.MODEL_FIRST -> ENDPOINT_CONFIGURATIONS;
            case SparqlFederatedServicesPriority.CONFIG_FIRST -> DEPLOYMENT_CONFIGURATIONS;
        };
    }

    private Object readFederatedServicesPriority(String priority) {
        if (priority == null) {
            return null;
        }
        SparqlFederatedServicesPriority value = switch (priority) {
            case ENDPOINT_CONFIGURATIONS -> SparqlFederatedServicesPriority.MODEL_FIRST;
            case DEPLOYMENT_CONFIGURATIONS -> SparqlFederatedServicesPriority.CONFIG_FIRST;
            default -> SparqlFederatedServicesPriority.fromCode((String)priority);
        };
        return value.toString();
    }

    private void applyEndpointOptions(Configs currentConfig, EndpointOptions configOptions) {
        this.putIfNotNull("enable_mutations", configOptions.getEnableMutations(), currentConfig);
        this.applyLangOptions(currentConfig, configOptions);
        this.putIfNotNull("queryPfx", configOptions.getQueryPrefix(), currentConfig);
        this.putIfNotNull("mutationPfx", configOptions.getMutationPrefix(), currentConfig);
        this.putIfNotNull("includeInferred", configOptions.getIncludeInferred(), currentConfig);
        this.putIfNotNull("expandOwlSameAs", configOptions.getExpandOwlSameAs(), currentConfig);
        this.putIfNotNull("disabledChecks", configOptions.getDisabledChecks(), currentConfig);
        this.putIfNotNull("defaultRole", configOptions.getDefaultRole(), currentConfig);
        this.putIfNotNull("exposeSomlInGraphQL", configOptions.getExposeSomlInGraphQL(), currentConfig);
        this.putIfNotNull("enableCollectionCount", configOptions.getEnableCollectionCount(), currentConfig);
        this.putIfNotNull("enableTypeCount", configOptions.getEnableTypeCount(), currentConfig);
        this.putIfNotNull("compactErrorMessages", configOptions.getCompactErrorMessages(), currentConfig);
        this.putIfNotNull("enableGraphQlExplain", configOptions.getEnableGraphQLExplain(), currentConfig);
        this.putIfNotNull("sparqlFederatedServices", this.readSparqlFederatedServices(configOptions.getSparqlFederatedServices()), currentConfig);
        this.putIfNotNull("sparqlFederatedServicesPriority", this.readFederatedServicesPriority(configOptions.getSparqlFederatedServicesPriority()), currentConfig);
    }

    public GraphQLEndpointReport editEndpoint(String targetRepo, String endpointId, UpdateEndpointRequest updateRequest) throws SomlStoreException {
        EndpointOptions endpointOptions;
        boolean isChangeIdRequested;
        SomlSchemaStorage storage = this.getServiceManager().getStorage(targetRepo);
        String somlId = SomlIdManager.INSTANCE.referenceToSomlId(endpointId);
        SchemaEntity schemaEntity = (SchemaEntity)storage.getEntity(somlId).orElseThrow(() -> SomlNotFoundException.notFound((String)somlId));
        boolean bl = isChangeIdRequested = updateRequest.getId() != null && !updateRequest.getId().equals(endpointId);
        if (isChangeIdRequested) {
            String referencedId = SomlIdManager.INSTANCE.referenceToSomlId(updateRequest.getId()).replaceAll("\\s+", "_");
            schemaEntity.overrideSchemaId(referencedId);
            endpointId = updateRequest.getId();
        }
        if (updateRequest.isActive() != null) {
            if (schemaEntity.getErrors() > 0 && Boolean.TRUE.equals(updateRequest.isActive())) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, String.format("Endpoint '%s' contains errors and cannot be activated", endpointId));
            }
            schemaEntity.setActive(updateRequest.isActive());
        }
        if (updateRequest.getLabel() != null) {
            schemaEntity.setLabel(StringUtils.trimToNull((String)updateRequest.getLabel()));
        }
        if (updateRequest.getDescription() != null) {
            schemaEntity.setDescription(StringUtils.trimToNull((String)updateRequest.getDescription()));
        }
        if ((endpointOptions = updateRequest.getOptions()) != null && !endpointOptions.isEmpty()) {
            this.applyConfiguration(schemaEntity, updateRequest.getOptions());
        }
        storage.update(somlId, schemaEntity);
        boolean isSchemaDefault = this.isSchemaDefault(targetRepo, somlId);
        if (isChangeIdRequested && isSchemaDefault) {
            this.getServiceManager().setDefaultSchema(targetRepo, updateRequest.getId());
        }
        if (updateRequest.isDefault() != null) {
            if (Boolean.TRUE.equals(updateRequest.isDefault())) {
                this.getServiceManager().setDefaultSchema(targetRepo, endpointId);
            } else if (isSchemaDefault) {
                this.getServiceManager().setDefaultSchema(targetRepo, null);
            }
        }
        return this.createDetailedEndpoint(targetRepo, (SchemaEntity)storage.getEntity(schemaEntity.getSchemaId()).orElseThrow(() -> SomlNotFoundException.notFound((String)schemaEntity.getSchemaId())), GraphQLEndpointReport::new);
    }

    public byte[] exportAllSchemasAsZip(String targetRepo) throws UnreachableStoreException {
        Map<String, byte[]> schemas = this.getAllSchemas(targetRepo);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);){
            for (Map.Entry<String, byte[]> entry : schemas.entrySet()) {
                ZipEntry zipEntry = new ZipEntry(GraphQLService.toYamlFilename(entry.getKey()));
                zipOutputStream.putNextEntry(zipEntry);
                zipOutputStream.write(entry.getValue());
                zipOutputStream.closeEntry();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create ZIP file", e);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private Map<String, byte[]> getAllSchemas(String targetRepo) throws UnreachableStoreException {
        HashMap<String, byte[]> schemasAsYaml = new HashMap<String, byte[]>();
        SomlSchemaStorage storage = this.getServiceManager().getStorage(targetRepo);
        storage.getAll().forEach(schemaEntity -> {
            String endpointId = SomlIdManager.INSTANCE.somlIdToReference(schemaEntity.getSchemaId());
            schemasAsYaml.put(endpointId, schemaEntity.getOriginalDefinition().getBytes(StandardCharsets.UTF_8));
        });
        return schemasAsYaml;
    }

    public byte[] exportSchemaAsYaml(String targetRepo, String endpointId) throws IOException {
        SomlSchemaStorage storage = this.getServiceManager().getStorage(targetRepo);
        return ((SchemaEntity)storage.getEntity(SomlIdManager.INSTANCE.referenceToSomlId(endpointId)).orElseThrow(() -> SomlNotFoundException.notFound((String)endpointId))).getOriginalDefinition().getBytes(StandardCharsets.UTF_8);
    }

    public static String toYamlFilename(String endpointId) {
        return endpointId + ".yaml";
    }

    private void applyLangOptions(Configs currentConfig, EndpointOptions configOptions) {
        if (StringUtils.isNotEmpty((CharSequence)configOptions.getLangFetch()) || StringUtils.isNotEmpty((CharSequence)configOptions.getLangValidate()) || StringUtils.isNotEmpty((CharSequence)configOptions.getLangImplicit()) || StringUtils.isNotEmpty((CharSequence)configOptions.getLangDefaultNameFetch()) || configOptions.getLangAppendDefaultNameFetch() != null) {
            SchemaLangConfig lang = (SchemaLangConfig)currentConfig.computeIfAbsent("lang", k -> new SchemaLangConfig());
            if (StringUtils.isNotEmpty((CharSequence)configOptions.getLangFetch())) {
                lang.setFetch(configOptions.getLangFetch());
            }
            if (StringUtils.isNotEmpty((CharSequence)configOptions.getLangValidate())) {
                lang.setValidate(configOptions.getLangValidate());
            }
            if (StringUtils.isNotEmpty((CharSequence)configOptions.getLangImplicit())) {
                lang.setImplicit(configOptions.getLangImplicit());
            }
            if (StringUtils.isNotEmpty((CharSequence)configOptions.getLangDefaultNameFetch())) {
                lang.setDefaultNameFetch(configOptions.getLangDefaultNameFetch());
            }
            if (configOptions.getLangAppendDefaultNameFetch() != null) {
                lang.setAppendDefaultNameFetch(String.valueOf(configOptions.getLangAppendDefaultNameFetch()));
            }
        }
    }

    private void putIfNotNull(String key, Object value, Configs currentConfig) {
        String str;
        if (value != null && (!(value instanceof String) || StringUtils.isNotEmpty((CharSequence)(str = (String)value)))) {
            currentConfig.put(key, value);
        }
    }

    public ImportResponse importYamlSchema(String targetRepo, String fileName, String schemaAsString, Consumer<SchemaEntity> entityUpdater) {
        ImportResponse importResponse = new ImportResponse();
        importResponse.setFilename(fileName);
        try {
            GraphQLEndpointReport createReport = this.createOrUpdateSchema(targetRepo, schemaAsString, entityUpdater, EndpointCreationType.UPLOAD);
            importResponse.setId(createReport.getId());
            importResponse.setStatus(ImportResponse.ImportStatus.SUCCESS);
            importResponse.setStatusMessage(String.format(SUCCESSFUL_IMPORT_MESSAGE, createReport.getId()));
            importResponse.setMessages(createReport.getMessages());
        }
        catch (ValidatingException ex) {
            if (this.hasReaderExceptionAsCause(ex)) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ex.getMessage());
            }
            importResponse.setStatus(ImportResponse.ImportStatus.FAIL);
            importResponse.setStatusMessage(String.format(FAILED_PROCESSING_MESSAGE, fileName));
            List<String> warnings = ex.getWarningMessages(ResponseMapper.toWarningResponse()).stream().map(BaseResponse::getMessage).toList();
            List<String> errors = ex.getErrorMessages(ResponseMapper.toErrorResponse()).stream().map(BaseResponse::getMessage).toList();
            importResponse.setMessages(new ValidationMessages(warnings, errors));
        }
        return importResponse;
    }

    public GraphQLEndpointReport validateGraphQLSchema(String schema) {
        Pair<SomlSchema, OperationResponse> responsePair = this.validateSchema(schema);
        if (responsePair.getLeft() != null) {
            this.getServiceManager().validateSchemaBinding((SomlSchema)responsePair.getLeft());
        }
        SomlSchema somlSchema = this.getNonNullSchema((SomlSchema)responsePair.getLeft(), schema);
        SchemaEntity schemaEntity = SchemaEntity.createSchemaEntity((String)schema, (SomlSchema)somlSchema, (OperationResponse)((OperationResponse)responsePair.getRight()), null);
        return this.createDetailedEndpoint(null, schemaEntity, GraphQLEndpointReport::new);
    }

    private SomlSchema getNonNullSchema(SomlSchema expected, String schema) {
        if (expected != null) {
            return expected;
        }
        Object id = SomlSchemaParser.getId((String)schema);
        if (id == null) {
            id = "/soml/" + String.valueOf(UUID.randomUUID());
        }
        return this.schemaParser.parse("id: " + (String)id);
    }

    public ValidationJob validateSchema(String repository, Set<String> validations, String endpointId, String fetchTasks, Set<String> types, Set<String> properties, Long limit, Long offset, Integer timeout) throws UnreachableStoreException {
        this.validateValidationSteps(validations);
        String schemaId = SomlIdManager.INSTANCE.referenceToSomlId(endpointId);
        String foundSchema = (String)this.getServiceManager().getStorage(repository).get(schemaId).orElseThrow(() -> ResourceNotFoundException.somlNotFound((String)endpointId));
        ImmediateValidation immediateValidation = new ImmediateValidation(this.getServiceManager().getValidationManager(repository));
        boolean failedOnly = "failed".equals(fetchTasks);
        return immediateValidation.validateBlocking(this.schemaParser.parse(foundSchema), types, properties, validations, failedOnly, Objects.requireNonNullElse(limit, 1000L).longValue(), Objects.requireNonNullElse(offset, 0L).longValue(), repository, TimeUnit.SECONDS.toMillis(Objects.requireNonNullElse(timeout, 300).intValue()));
    }

    public void ensureEndpointIsActive(String repository, String schemaId) {
        String somlId;
        String string = somlId = StringUtils.isNotEmpty((CharSequence)schemaId) ? SomlIdManager.INSTANCE.referenceToSomlId(schemaId) : (String)this.getServiceManager().getDefaultSchemaId(repository).orElseThrow(() -> new ResourceNotFoundException(repository, "Default endpoint for repository", ErrorCode.MISSING_SOML));
        if (!this.getServiceManager().isEndpointActive(repository, somlId)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Endpoint '%s' is not active", somlId));
        }
    }

    private boolean isSchemaDefault(String targetRepo, String somlId) {
        return this.getServiceManager().getDefaultSchemaId(targetRepo).filter(Predicate.isEqual(somlId)).isPresent();
    }

    private void validateValidationSteps(Set<String> validations) {
        String invalidValidationSteps;
        if (CollectionUtils.isNotEmpty(validations) && !"''".equals(invalidValidationSteps = validations.stream().filter(validation -> ValidationSteps.getStep((String)validation) == null).collect(Collectors.joining("', '", "'", "'")))) {
            throw new BadRequestException("Unknown validation step/s: " + invalidValidationSteps + ". Supported validations are: " + String.join((CharSequence)", ", ValidationSteps.getAvailable()), ErrorCode.INVALID_HEADER_VALUE);
        }
    }

    private boolean hasReaderExceptionAsCause(Throwable throwable) {
        while (throwable != null) {
            if (throwable instanceof ReaderException) {
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }

    private boolean hasParserExceptionAsCause(Throwable throwable) {
        while (throwable != null) {
            if (throwable instanceof YamlParseException) {
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }

    private String serializeToJson(Object data, String errorMessage) {
        try {
            return JsonUtils.toString((Object)data);
        }
        catch (IOException e) {
            LOGGER.warn(errorMessage, (Throwable)e);
            return null;
        }
    }

    static {
        LinkedHashMap<String, ConfigOption> map = new LinkedHashMap<String, ConfigOption>();
        map.put("stringMode", new ConfigOption("stringMode", "stringOrLangString", "stringMode", "Specifies the default string mode for data properties without a range definition", "string", false, List.of("string", "langString", "stringOrLangString"), true, null, GENERIC_GROUP, false));
        map.put("useUnions", new ConfigOption("useUnions", Boolean.TRUE, "useUnions", "Should GraphQL Unions be used in the result model", "boolean", false, null, false, null, GENERIC_GROUP, false));
        map.put("forceInterfaceTypes", new ConfigOption("forceInterfaceTypes", Boolean.FALSE, "forceInterfaceTypes", "Decide if parent types are always interfaces or split with interface and subclass", "boolean", false, null, false, null, GENERIC_GROUP, false));
        map.put("defaultMaxCardinality", new ConfigOption("defaultMaxCardinality", "inf", "defaultMaxCardinality", "The default maximum cardinality for all values. This defines if properties without explicit cardinality configuration are by default multi or single valued.", "string", false, null, false, "^\\d+|inf$", GENERIC_GROUP, false));
        map.put("readShaclPropertyLabels", new ConfigOption("readShaclPropertyLabels", Boolean.TRUE, "readShaclPropertyLabels", "If the labels and description for the sh:PropertyShape should be used over the sh:path label and description", "boolean", false, null, false, null, GENERIC_GROUP, true));
        map.put("removeUnknownRanges", new ConfigOption("removeUnknownRanges", Boolean.TRUE, "removeUnknownRanges", "Should remove the invalid and undefined ranges ", "boolean", false, null, false, null, DATA_CLEANUP_GROUP, true));
        map.put("cleanInvalidInverseOf", new ConfigOption("cleanInvalidInverseOf", Boolean.TRUE, "cleanInvalidInverseOf", "Try to fix invalid owl:inverseOf relations", "boolean", false, null, false, null, DATA_CLEANUP_GROUP, true));
        map.put("includeDeactivatedShapes", new ConfigOption("includeDeactivatedShapes", Boolean.FALSE, "includeDeactivatedShapes", "Include the sh:deactivated shapes in the model", "boolean", false, null, false, null, DATA_CLEANUP_GROUP, true));
        map.put(SomlOntology.READ_RBAC_RULES.getLocalName(), new ConfigOption(SomlOntology.READ_RBAC_RULES.getLocalName(), Boolean.TRUE, SomlOntology.READ_RBAC_RULES.getLocalName(), "Read RBAC rules from the models", "boolean", false, null, false, null, "enterprise", true));
        GENERATE_CONFIG_INFO_MAP = Collections.unmodifiableMap(map);
        map = new LinkedHashMap();
        map.put("enableTypeCount", new ConfigOption("enableTypeCount", Boolean.FALSE, "enableTypeCount", "Controls whether new counting queries should be generated for all queryable types.", "boolean", false, null, false, null, GRAPHQL_GROUP, false));
        map.put("enableCollectionCount", new ConfigOption("enableCollectionCount", Boolean.FALSE, "enableCollectionCount", "Controls whether the collections should have a companion property that provides counting of the collection properties.", "boolean", false, null, false, null, GRAPHQL_GROUP, false));
        map.put("compactErrorMessages", new ConfigOption("compactErrorMessages", Boolean.FALSE, "compactErrorMessages", "Controls the default behavior of the GraphQL Responder how to process the errors that are returned to the client.", "boolean", false, null, false, null, GRAPHQL_GROUP, false));
        map.put("lang.fetch", new ConfigOption("langFetch", null, "fetch", "Default language fetch configuration", "string", false, null, false, "^(?:ALL:?)?(?:(?:-?[\\w]{2}(?:-[\\w]*)?~?|-?NONE|ANY|BROWSER)?(?:,(?:-?[\\w]{2}(?:-[\\w]*)?~?|-?NONE|ANY|BROWSER))*)$", GRAPHQL_GROUP, false));
        map.put("lang.validate", new ConfigOption("langValidate", null, "validate", "Default language validation configuration", "string", false, null, false, "^(?:[\\w]{2}~?|NONE|ANY|ALL)?(?:,(?:[\\w]{2}~?|NONE|ANY|ALL))*(?:;?UNIQ)?$", GRAPHQL_GROUP, false));
        map.put("lang.implicit", new ConfigOption("langImplicit", "en", "implicit", "Default language to use when inserting rdf:langString values.", "string", false, null, false, "[\\w]{2}(?:-[\\w]*)?", GRAPHQL_GROUP, false));
        map.put("lang.defaultNameFetch", new ConfigOption("langDefaultNameFetch", "ANY", "defaultNameFetch", "Default language spec to apply when loading values for the name property", "string", false, null, false, "^(?:(?:-?[\\w]{2}(?:-[\\w]*)?~?|-?NONE|ANY|BROWSER)?(?:,(?:-?[\\w]{2}(?:-[\\w]*)?~?|-?NONE|ANY|BROWSER))*)$", GRAPHQL_GROUP, true));
        map.put("lang.appendDefaultNameFetch", new ConfigOption("langAppendDefaultNameFetch", Boolean.TRUE, "appendDefaultNameFetch", "Specifies whether the default spec, if any, should be appended or not to any user-defined name fetch spec", "boolean", false, null, false, null, GRAPHQL_GROUP, true));
        map.put("includeInferred", new ConfigOption("includeInferred", Boolean.TRUE, "includeInferred", "Controls whether query inference is enabled or disabled by default for all queries and mutations.", "boolean", false, null, false, null, GRAPHQL_GROUP, false));
        map.put("expandOwlSameAs", new ConfigOption("expandOwlSameAs", Boolean.TRUE, "expandOwlSameAs", "Controls whether owl:sameAs expansion is enabled or disabled by default for all queries and mutations.", "boolean", false, null, false, null, GRAPHQL_GROUP, false));
        map.put("enable_mutations", new ConfigOption("enableMutations", Boolean.TRUE, "enableMutations", "Controls whether the generated GraphQL schema should include object mutations or not.", "boolean", false, null, false, null, SECURITY_GROUP, false));
        map.put("defaultRole", new ConfigOption("defaultRole", "Default", "defaultRole", "The default RBAC role the user will receive if no roles are found in the security JWT token or none of the roles match any in the rbac section of the current SOML schema.", "string", false, null, false, "[\\w]*", SECURITY_GROUP, true));
        map.put("enableGraphQlExplain", new ConfigOption("enableGraphQLExplain", Boolean.TRUE, "enableGraphQLExplain", "Controls whether SemanticObjects should provide the generated SPARQL query or its explain plan.", "boolean", false, null, false, null, SECURITY_GROUP, true));
        map.put("exposeSomlInGraphQL", new ConfigOption("exposeSomlInGraphQL", Boolean.FALSE, "exposeSomlInGraphQL", "Controls whether the collections should have a companion property that provides counting of the collection properties.", "boolean", false, null, false, null, SECURITY_GROUP, true));
        map.put("disabledChecks", new ConfigOption("disabledChecks", null, "disabledChecks", "Specifies which checks could be disabled during the schema validation.", "[string]", true, List.of("regexInheritanceCheck", "rangeCheck"), false, null, SECURITY_GROUP, true));
        map.put("sparqlFederatedServices", new ConfigOption("sparqlFederatedServices", Map.of(), "sparqlFederatedServices", "Allows configuring the endpoint's SPARQL federated service endpoints.", "json", false, null, false, null, INTEGRATION_GROUP, false));
        map.put("sparqlFederatedServicesPriority", new ConfigOption("sparqlFederatedServicesPriority", DEPLOYMENT_CONFIGURATIONS, "sparqlFederatedServicesPriority", "Allows setting the priority of the SPARQL federated service endpoints configurations. This controls which configuration has higher priority current deployment options or the specific endpoint configurations.", "string", false, List.of(DEPLOYMENT_CONFIGURATIONS, ENDPOINT_CONFIGURATIONS), false, null, INTEGRATION_GROUP, true));
        map.put("queryPfx", new ConfigOption("queryPrefix", null, "queryPrefix", "Allows setting a prefix that will be put in all queries in the GraphQL schema.", "string", false, null, false, "[\\w]*", INTEGRATION_GROUP, true));
        map.put("mutationPfx", new ConfigOption("mutationPrefix", null, "mutationPrefix", "Allows setting a prefix that will be put in all mutations in the GraphQL schema.", "string", false, null, false, "[\\w]*", INTEGRATION_GROUP, true));
        ENDPOINT_CONFIG_INFO_MAP = Collections.unmodifiableMap(map);
        TRACK_ALIAS = SparqlEndpointRequestContext.addCopyConfig(GraphDBHTTPContext::getTrackAlias, GraphDBHTTPContext::setTrackAlias);
        GRAPHQL_REQUEST = SparqlEndpointRequestContext.addCopyConfig(GraphDBGraphQLRequestContext::getGraphqlRequest, GraphDBGraphQLRequestContext::setGraphqlRequest);
        SECURITY_CONTEXT = SparqlEndpointRequestContext.addCopyConfig(SecurityContextHolder::getContext, SecurityContextHolder::setContext);
    }

    private static class GraphDB2SemanticObjectsSecurityContext
    implements com.ontotext.rbac.SecurityContext {
        private GraphDB2SemanticObjectsSecurityContext() {
        }

        @Nullable
        public String getUsername() {
            return GraphDBHTTPContext.getAuthenticatedUser().getUsername();
        }

        @Nullable
        public <T> T getClaimValue(String claim, Class<T> valueType) {
            return null;
        }

        @Nonnull
        public Stream<String> getAuthorities() {
            return GraphDBHTTPContext.getAuthenticatedUser().getRoles();
        }

        public boolean isAdmin() {
            return SecurityUtils.hasGraphQLAdminAccess();
        }
    }
}

