/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.similarity.iterators;

import com.ontotext.trree.plugin.similarity.SimilarityIndex;
import com.ontotext.trree.plugin.similarity.SimilarityRequestContext;
import com.ontotext.trree.plugin.similarity.iterators.AbstractResultIterator;
import com.ontotext.trree.sdk.Entities;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;

public class MasterResultIterator
extends AbstractResultIterator {
    private String queryString;
    private Long queryEntity;
    private Long psiQueryPredicate;
    private String searchOptions = "";
    private long entitySubjectFilter;
    private boolean done = false;
    private SimilarityRequestContext context;
    private SimilarityIndex similarityIndex;
    boolean shouldSearchByTerm;
    private Long querySubject;
    private Long queryObject;
    private Long searchSubject;

    public MasterResultIterator(Entities entities, SimilarityRequestContext context) {
        this.setEntities(entities);
        BNode node = SimpleValueFactory.getInstance().createBNode();
        this.subject = entities.put((Value)node, Entities.Scope.REQUEST);
        this.context = context;
    }

    public boolean next() {
        if (this.closed) {
            return false;
        }
        if (this.done) {
            this.context.unregisterIterator(this);
            return false;
        }
        this.done = true;
        return true;
    }

    public void setEntitySubjectFilter(long entitySubjectFilter) {
        this.entitySubjectFilter = entitySubjectFilter;
    }

    public long getEntitySubjectFilter() {
        return this.entitySubjectFilter;
    }

    public void unregisterIterator(AbstractResultIterator itty) {
        this.context.unregisterIterator(itty);
    }

    public void setSimilarityIndex(SimilarityIndex similarityIndex) {
        this.similarityIndex = similarityIndex;
    }

    public SimilarityIndex getSimilarityIndex() {
        return this.similarityIndex;
    }

    public void setQueryString(String queryString) {
        this.shouldSearchByTerm = true;
        this.queryString = queryString;
    }

    public void setPsiQueryPredicate(Long psiQueryPredicate) {
        this.psiQueryPredicate = psiQueryPredicate;
    }

    public Long getPsiQueryPredicate() {
        return this.psiQueryPredicate;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public Long getQueryEntity() {
        return this.queryEntity;
    }

    public void setQueryEntity(Long queryEntity) {
        this.queryEntity = queryEntity;
    }

    public boolean shouldSearchByTerm() {
        return this.shouldSearchByTerm;
    }

    @Override
    public void close() {
        super.close();
    }

    public String getSearchOptions() {
        return this.searchOptions;
    }

    public void setSearchOptions(String searchOptions) {
        this.searchOptions = searchOptions;
    }

    public Long getQuerySubject() {
        return this.querySubject;
    }

    public void setQuerySubject(Long querySubject) {
        this.querySubject = querySubject;
    }

    public Long getQueryObject() {
        return this.queryObject;
    }

    public void setQueryObject(Long queryObject) {
        this.queryObject = queryObject;
    }

    public Long getSearchSubject() {
        return this.searchSubject;
    }

    public void setSearchSubject(Long searchSubject) {
        this.searchSubject = searchSubject;
    }
}

