/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.similarity;

import com.ontotext.trree.plugin.similarity.SimilarityIndex;
import com.ontotext.trree.plugin.similarity.SimilarityIndexes;
import com.ontotext.trree.plugin.similarity.SimilarityPlugin;
import com.ontotext.trree.sdk.PluginConnection;
import com.ontotext.trree.sdk.PluginException;
import com.ontotext.trree.sdk.PluginTransactionListener;
import com.ontotext.trree.sdk.StatementListener;
import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.rdf4j.query.QueryInterruptedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateIndexListener
implements PluginTransactionListener,
StatementListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateIndexListener.class);
    private SimilarityPlugin similarityPlugin;
    Future<Boolean> future;
    private ExecutorService exec = Executors.newCachedThreadPool();

    public CreateIndexListener(SimilarityPlugin similarityPlugin) {
        this.similarityPlugin = similarityPlugin;
    }

    public void transactionCompleted(PluginConnection pluginConnection) {
    }

    public boolean statementAdded(long l, long l1, long l2, long l3, boolean b, PluginConnection pluginConnection) {
        this.outdateIndexes();
        return false;
    }

    private void outdateIndexes() {
        this.similarityPlugin.similarityIndexes.values().stream().filter(SimilarityIndex::outdate).forEach(index -> {
            try {
                SimilarityIndexes.serialize(index);
            }
            catch (IOException e) {
                LOGGER.warn("Could not serialize index " + this.similarityPlugin.createIndexName, (Throwable)e);
            }
        });
    }

    public boolean statementRemoved(long l, long l1, long l2, long l3, boolean b, PluginConnection pluginConnection) {
        this.outdateIndexes();
        return false;
    }

    public void transactionStarted(PluginConnection pluginConnection) {
        this.similarityPlugin.data = new LinkedList<Pair<Long, String>>();
        this.similarityPlugin.createEntityCurrentId = null;
        this.similarityPlugin.createIndexName = null;
        this.similarityPlugin.createPSCurrentPredicateId = null;
        this.similarityPlugin.createPSCurrentSubjectId = null;
    }

    public void transactionCommit(PluginConnection pluginConnection) {
        if (StringUtils.isNotEmpty((CharSequence)this.similarityPlugin.createIndexName)) {
            SimilarityIndex index = this.similarityPlugin.similarityIndexes.get(this.similarityPlugin.createIndexURI);
            try {
                this.future = this.exec.submit(index::buildIndex);
                if (Boolean.FALSE.equals(this.future.get())) {
                    throw new PluginException("Query used to collect data returns no results");
                }
            }
            catch (CancellationException e) {
                throw new QueryInterruptedException("Transaction was aborted by the user");
            }
            catch (Exception e) {
                throw new PluginException("Failed to build index", (Throwable)e);
            }
            finally {
                if (!index.interruptIndexCreation.get()) {
                    this.future = null;
                }
                if (index.getStatus() != SimilarityIndex.Status.REBUILDING) {
                    this.serializeIndex(index);
                } else {
                    this.returnPrevStatusIfNeeded(index);
                }
            }
        }
    }

    public void transactionAborted(PluginConnection pluginConnection) {
        SimilarityIndex failedIndex;
        if (StringUtils.isNotEmpty((CharSequence)this.similarityPlugin.createIndexName) && (failedIndex = this.similarityPlugin.similarityIndexes.get(this.similarityPlugin.createIndexURI)) != null && failedIndex.getStatus() != SimilarityIndex.Status.BUILT) {
            if (this.future == null) {
                if (failedIndex.getStatus() != SimilarityIndex.Status.REBUILDING) {
                    if (failedIndex.interruptIndexCreation.compareAndSet(true, false)) {
                        failedIndex.setStatus(SimilarityIndex.Status.INTERRUPTED);
                    } else {
                        failedIndex.setStatus(SimilarityIndex.Status.FAILED);
                    }
                    this.serializeIndex(failedIndex);
                } else {
                    this.returnPrevStatusIfNeeded(failedIndex);
                }
            } else if (!this.future.isCancelled() && !failedIndex.interruptIndexCreation.get()) {
                this.future.cancel(true);
            }
            failedIndex.clearIndexData();
            this.future = null;
        }
    }

    public void transactionAbortedByUser(PluginConnection pluginConnection) {
        SimilarityIndex currentIndex;
        if (StringUtils.isNotEmpty((CharSequence)this.similarityPlugin.createIndexName) && (currentIndex = this.similarityPlugin.similarityIndexes.get(this.similarityPlugin.createIndexURI)) != null && currentIndex.getStatus() != SimilarityIndex.Status.BUILT) {
            if (currentIndex.interruptIndexCreation.compareAndSet(false, true) && this.future != null && !this.future.isCancelled()) {
                this.future.cancel(true);
            }
            LOGGER.warn("{} index creation aborted!", (Object)this.similarityPlugin.createIndexName);
        }
    }

    private void serializeIndex(SimilarityIndex index) {
        try {
            if (this.similarityPlugin.similarityIndexes.containsKey(this.similarityPlugin.createIndexURI)) {
                SimilarityIndexes.serialize(index);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void returnPrevStatusIfNeeded(SimilarityIndex index) {
        if (index.getStatus() != SimilarityIndex.Status.BUILDING) {
            try {
                index = SimilarityIndexes.deserialize(index.getHomeDir().toPath().resolve(index.getName() + ".json").toFile());
                this.similarityPlugin.similarityIndexes.put(this.similarityPlugin.createIndexURI, index);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

