/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.injection.impl;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Injector;
import it.unibz.inf.ontop.exception.InvalidOntopConfigurationException;
import it.unibz.inf.ontop.exception.OBDASpecificationException;
import it.unibz.inf.ontop.injection.OntopMappingSQLAllOWLAPIConfiguration;
import it.unibz.inf.ontop.injection.OntopMappingSQLAllSettings;
import it.unibz.inf.ontop.injection.OntopMappingSettings;
import it.unibz.inf.ontop.injection.impl.OntopMappingOntologyBuilders;
import it.unibz.inf.ontop.injection.impl.OntopMappingOntologyConfigurationImpl;
import it.unibz.inf.ontop.injection.impl.OntopMappingSQLAllConfigurationImpl;
import it.unibz.inf.ontop.injection.impl.OntopMappingSQLAllSettingsImpl;
import it.unibz.inf.ontop.spec.OBDASpecification;
import it.unibz.inf.ontop.spec.ontology.RDFFact;
import java.io.File;
import java.io.Reader;
import java.net.URL;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;

public class OntopMappingSQLAllOWLAPIConfigurationImpl
extends OntopMappingSQLAllConfigurationImpl
implements OntopMappingSQLAllOWLAPIConfiguration {
    private final OntopMappingOntologyConfigurationImpl mappingOWLConfiguration;

    OntopMappingSQLAllOWLAPIConfigurationImpl(OntopMappingSQLAllSettings settings, OntopMappingSQLAllOWLAPIOptions options) {
        super(settings, options.sqlOptions);
        this.mappingOWLConfiguration = new OntopMappingOntologyConfigurationImpl((OntopMappingSettings)settings, options.ontologyOptions, () -> ((OntopMappingSQLAllOWLAPIConfigurationImpl)this).getInjector());
    }

    OntopMappingSQLAllOWLAPIConfigurationImpl(OntopMappingSQLAllSettings settings, OntopMappingSQLAllOWLAPIOptions options, Supplier<Injector> injectorSupplier) {
        super(settings, options.sqlOptions);
        this.mappingOWLConfiguration = new OntopMappingOntologyConfigurationImpl((OntopMappingSettings)settings, options.ontologyOptions, injectorSupplier);
    }

    protected OBDASpecification loadOBDASpecification() throws OBDASpecificationException {
        return this.loadSpecification(() -> ((OntopMappingOntologyConfigurationImpl)this.mappingOWLConfiguration).loadOntology(), () -> ((OntopMappingOntologyConfigurationImpl)this.mappingOWLConfiguration).loadInputFacts());
    }

    public Optional<OWLOntology> loadInputOntology() throws OWLOntologyCreationException {
        return this.mappingOWLConfiguration.loadInputOntology();
    }

    public Optional<ImmutableSet<RDFFact>> loadInputFacts() throws OBDASpecificationException {
        return this.mappingOWLConfiguration.loadInputFacts();
    }

    public static class BuilderImpl
    extends OntopMappingSQLAllOWLAPIBuilderMixin<BuilderImpl> {
        @Override
        public OntopMappingSQLAllOWLAPIConfiguration build() {
            OntopMappingSQLAllSettingsImpl settings = new OntopMappingSQLAllSettingsImpl(this.generateProperties(), this.isR2rml());
            OntopMappingSQLAllOWLAPIOptions options = this.generateSQLAllOWLAPIOptions();
            return new OntopMappingSQLAllOWLAPIConfigurationImpl((OntopMappingSQLAllSettings)settings, options);
        }

        protected BuilderImpl self() {
            return this;
        }
    }

    protected static abstract class OntopMappingSQLAllOWLAPIBuilderMixin<B extends OntopMappingSQLAllOWLAPIConfiguration.Builder<B>>
    extends OntopMappingSQLAllConfigurationImpl.OntopMappingSQLAllBuilderMixin<B>
    implements OntopMappingSQLAllOWLAPIConfiguration.Builder<B> {
        private final OntopMappingOntologyBuilders.StandardMappingOntologyBuilderFragment<B> ontologyBuilderFragment = new OntopMappingOntologyBuilders.StandardMappingOntologyBuilderFragment<B>(){

            protected B self() {
                return (OntopMappingSQLAllOWLAPIConfiguration.Builder)this.self();
            }

            protected void declareOntologyDefined() {
                this.declareOntologyDefined();
            }
        };
        private boolean isOntologyDefined = false;

        OntopMappingSQLAllOWLAPIBuilderMixin() {
        }

        public B ontologyFile(@Nonnull String urlOrPath) {
            return (B)((OntopMappingSQLAllOWLAPIConfiguration.Builder)this.ontologyBuilderFragment.ontologyFile(urlOrPath));
        }

        public B ontologyFile(@Nonnull URL url) {
            return (B)((OntopMappingSQLAllOWLAPIConfiguration.Builder)this.ontologyBuilderFragment.ontologyFile(url));
        }

        public B ontologyFile(@Nonnull File owlFile) {
            return (B)((OntopMappingSQLAllOWLAPIConfiguration.Builder)this.ontologyBuilderFragment.ontologyFile(owlFile));
        }

        public B ontologyReader(@Nonnull Reader reader) {
            return (B)((OntopMappingSQLAllOWLAPIConfiguration.Builder)this.ontologyBuilderFragment.ontologyReader(reader));
        }

        public B xmlCatalogFile(@Nonnull String file) {
            return (B)((OntopMappingSQLAllOWLAPIConfiguration.Builder)this.ontologyBuilderFragment.xmlCatalogFile(file));
        }

        public B factsFile(@Nonnull String urlOrPath) {
            return (B)((OntopMappingSQLAllOWLAPIConfiguration.Builder)this.ontologyBuilderFragment.factsFile(urlOrPath));
        }

        public B factFormat(@Nonnull String factFormat) {
            return (B)((OntopMappingSQLAllOWLAPIConfiguration.Builder)this.ontologyBuilderFragment.factFormat(factFormat));
        }

        public B factsBaseIRI(@Nonnull String factsBaseIRI) {
            return (B)((OntopMappingSQLAllOWLAPIConfiguration.Builder)this.ontologyBuilderFragment.factsBaseIRI(factsBaseIRI));
        }

        public B factsFile(@Nonnull URL url) {
            return (B)((OntopMappingSQLAllOWLAPIConfiguration.Builder)this.ontologyBuilderFragment.factsFile(url));
        }

        public B factsFile(@Nonnull File owlFile) {
            return (B)((OntopMappingSQLAllOWLAPIConfiguration.Builder)this.ontologyBuilderFragment.factsFile(owlFile));
        }

        public B factsReader(@Nonnull Reader reader) {
            return (B)((OntopMappingSQLAllOWLAPIConfiguration.Builder)this.ontologyBuilderFragment.factsReader(reader));
        }

        protected final void declareOntologyDefined() {
            if (this.isOBDASpecificationAssigned()) {
                throw new InvalidOntopConfigurationException("The OBDA specification has already been assigned");
            }
            if (this.isOntologyDefined) {
                throw new InvalidOntopConfigurationException("Ontology already defined!");
            }
            this.isOntologyDefined = true;
        }

        protected final OntopMappingSQLAllOWLAPIOptions generateSQLAllOWLAPIOptions() {
            OntopMappingSQLAllConfigurationImpl.OntopMappingSQLAllOptions sqlOptions = this.generateMappingSQLAllOptions();
            OntopMappingOntologyBuilders.OntopMappingOntologyOptions mappingOntologyOptions = this.ontologyBuilderFragment.generateMappingOntologyOptions(sqlOptions.mappingSQLOptions.mappingOptions);
            return new OntopMappingSQLAllOWLAPIOptions(sqlOptions, mappingOntologyOptions);
        }
    }

    static class OntopMappingSQLAllOWLAPIOptions {
        final OntopMappingSQLAllConfigurationImpl.OntopMappingSQLAllOptions sqlOptions;
        final OntopMappingOntologyBuilders.OntopMappingOntologyOptions ontologyOptions;

        OntopMappingSQLAllOWLAPIOptions(OntopMappingSQLAllConfigurationImpl.OntopMappingSQLAllOptions sqlOptions, OntopMappingOntologyBuilders.OntopMappingOntologyOptions ontologyOptions) {
            this.sqlOptions = sqlOptions;
            this.ontologyOptions = ontologyOptions;
        }
    }
}

