/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.util;

import com.ontotext.trree.plugin.externalsync.api.ConnectorUserException;
import com.ontotext.trree.plugin.externalsync.impl.Property;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PropertyUtil {
    public static List<Property> sortPropertiesForFiltering(List<Property> properties) {
        Stream<Property> independentStream = properties.stream().filter(p -> !p.hasFilterDependency());
        Property[] dependentProperties = (Property[])properties.stream().filter(Property::hasFilterDependency).toArray(Property[]::new);
        PropertyUtil.checkCyclic(dependentProperties);
        PropertyUtil.sortDependentProperties(dependentProperties);
        Stream<Property> dependentStream = Arrays.stream(dependentProperties);
        return Stream.concat(independentStream, dependentStream).collect(Collectors.toUnmodifiableList());
    }

    private static void checkCyclic(Property[] dependentProperties) {
        for (Property p1 : dependentProperties) {
            for (Property p2 : dependentProperties) {
                if (!p1.filterDependsOn(p2) || !p2.filterDependsOn(p1)) continue;
                throw new ConnectorUserException(String.format("Cyclic dependency in filters: `%s' and `%s' both define a filter that depends on the other property being indexed first", p1.getFieldName().fullyQualifiedNameWithSuffix, p2.getFieldName().fullyQualifiedNameWithSuffix));
            }
        }
    }

    private static void sortDependentProperties(Property[] properties) {
        int n = properties.length;
        for (int i = 1; i < n; ++i) {
            Property key = properties[i];
            for (int j = i - 1; j >= 0 && !key.filterDependsOn(properties[j]); --j) {
                properties[j + 1] = properties[j];
            }
            properties[j + 1] = key;
        }
    }
}

