/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core.web;

import com.ontotext.graphdb.Config;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.springframework.core.io.Resource;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.servlet.resource.ResourceTransformer;
import org.springframework.web.servlet.resource.ResourceTransformerChain;
import org.springframework.web.servlet.resource.TransformedResource;

public class BaserefTransformer
implements ResourceTransformer {
    public Resource transform(HttpServletRequest request, Resource resource, ResourceTransformerChain transformerChain) throws IOException {
        if ("index.html".equals(resource.getFilename())) {
            URI externalUrl = Config.lookupVirtualHost((String)request.getHeader("Referer"));
            if (externalUrl == null && request.getHeader("x-forwarded-prefix") != null) {
                externalUrl = Config.lookupVirtualHost((String)(request.getHeader("Referer") + request.getHeader("x-forwarded-prefix").replace("/", "")));
            }
            if (externalUrl != null) {
                try (InputStream is = resource.getInputStream();){
                    String href = externalUrl.getPath();
                    TransformedResource transformedResource = new TransformedResource(resource, new String(FileCopyUtils.copyToByteArray((InputStream)is), StandardCharsets.UTF_8).replaceFirst("<base href=\"/\"", "<base href=\"" + href + "/\"").getBytes(StandardCharsets.UTF_8));
                    return transformedResource;
                }
            }
        }
        return resource;
    }
}

