/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core.serialization;

import com.ontotext.forest.core.error.ErrorMessage;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class ErrorMessageConverter
implements HttpMessageConverter<ErrorMessage> {
    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        return false;
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return ErrorMessage.class.isAssignableFrom(clazz) && (mediaType == null || mediaType.isCompatibleWith(MediaType.TEXT_PLAIN));
    }

    public List<MediaType> getSupportedMediaTypes() {
        return List.of(MediaType.TEXT_PLAIN);
    }

    public ErrorMessage read(Class<? extends ErrorMessage> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        throw new IllegalStateException();
    }

    public void write(ErrorMessage errorMessage, MediaType contentType, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        Charset charset;
        Charset charset2 = charset = contentType != null ? contentType.getCharset() : null;
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        byte[] bytesToWrite = errorMessage.toPlainText().getBytes(charset);
        outputMessage.getHeaders().setContentLength((long)bytesToWrite.length);
        outputMessage.getBody().write(bytesToWrite);
    }
}

