/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core.semantic.location;

import com.ontotext.forest.core.semantic.LocationType;
import com.ontotext.forest.core.semantic.SemanticLocationPersisted;
import com.ontotext.graphdb.security.AuthType;
import com.ontotext.graphdb.security.TokenManager;
import jakarta.annotation.Nullable;
import org.apache.http.HttpRequestInterceptor;

public class SemanticLocationAuth
extends SemanticLocationPersisted {
    protected transient HttpRequestInterceptor requestAuthenticator;
    private String errorMsg;

    public SemanticLocationAuth(String location, AuthType authType, LocationType locationType, @Nullable String username, @Nullable String password, @Nullable String defaultRepository) {
        super(location, authType, locationType, username, password, defaultRepository);
    }

    public void updateRequestAuthenticator() {
        this.requestAuthenticator = TokenManager.getInstance().getRequestAuthenticator(this.getAuthType(), this.getUsername(), this.getPassword());
    }

    public boolean isLocal() {
        return false;
    }

    public void close() {
    }

    public HttpRequestInterceptor getRequestAuthenticator() {
        return this.requestAuthenticator;
    }

    public boolean isSystem() {
        return this.getLocation().isEmpty();
    }

    public boolean initializeAsNeeded() {
        return true;
    }

    public String getLabel() {
        return "Remote (" + this.getLocation() + ")";
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }
}

