/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core.semantic.location;

import com.ontotext.raft.update.SystemUpdate;
import com.ontotext.raft.update.SystemUpdateProcessor;
import java.nio.charset.StandardCharsets;

public class LocationUpdate
implements SystemUpdate {
    private final String location;
    private final String authType;
    private final String locationType;
    private final String password;
    private final String username;
    private final String defaultRepository;
    private final String fingerprint;
    private final OperationType operationType;

    public LocationUpdate(String location, String authType, String locationType, String username, String password, String defaultRepo, OperationType operationType) {
        this.operationType = operationType;
        this.location = location;
        this.authType = authType;
        this.locationType = locationType;
        this.username = username != null ? username : "";
        this.password = password != null ? password : "";
        this.defaultRepository = defaultRepo != null ? defaultRepo : "";
        this.fingerprint = String.valueOf(location.hashCode());
    }

    public byte[] getBytes() {
        byte[][] components;
        byte[] fingerprintBytes = this.fingerprint.getBytes(StandardCharsets.UTF_8);
        byte[] locationBytes = this.location.getBytes(StandardCharsets.UTF_8);
        byte[] operationTypeBytes = this.operationType.name().getBytes(StandardCharsets.UTF_8);
        if (this.operationType == OperationType.DELETE) {
            components = new byte[][]{fingerprintBytes, locationBytes, operationTypeBytes};
        } else {
            byte[] authTypeBytes = this.authType.getBytes(StandardCharsets.UTF_8);
            byte[] locationTypeBytes = this.locationType.getBytes(StandardCharsets.UTF_8);
            byte[] usernameBytes = this.username.getBytes(StandardCharsets.UTF_8);
            byte[] passwordBytes = this.password.getBytes(StandardCharsets.UTF_8);
            byte[] defaultRepoBytes = this.defaultRepository.getBytes(StandardCharsets.UTF_8);
            components = new byte[][]{fingerprintBytes, locationBytes, operationTypeBytes, authTypeBytes, locationTypeBytes, usernameBytes, passwordBytes, defaultRepoBytes};
        }
        return this.serializeComponents(components);
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public SystemUpdateProcessor.Type getType() {
        return SystemUpdateProcessor.Type.LOCATION_UPDATE;
    }

    public static enum OperationType {
        ADD,
        UPDATE,
        DELETE;

    }
}

