/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core.semantic.location;

import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.forest.core.semantic.LocationType;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.semantic.SemanticLocation;
import com.ontotext.forest.core.semantic.SemanticLocationManagement;
import com.ontotext.forest.core.semantic.location.LocationUpdate;
import com.ontotext.forest.core.semantic.location.SemanticLocationAuth;
import com.ontotext.graphdb.security.AuthType;
import com.ontotext.raft.GraphDBReplicationCluster;
import com.ontotext.raft.update.SystemUpdate;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LocationService {
    private static final Logger LOG = LoggerFactory.getLogger(LocationService.class);
    @Autowired
    private SemanticLocationManagement locationManagement;
    @Autowired
    private SemanticDataManagement semanticDataManagement;

    @NotNull
    public SemanticLocation getCurrentLocationOrThrow() {
        return this.semanticDataManagement.getCurrentLocationOrThrow();
    }

    public SemanticLocation getCurrentLocation() {
        return this.semanticDataManagement.getCurrentLocation();
    }

    public String getUniqueLocationId() {
        return this.locationManagement.getUniqueLocationId();
    }

    public Collection<SemanticLocationAuth> getLocations() {
        return this.locationManagement.getLocations();
    }

    public boolean addLocation(String locUri, AuthType authType, LocationType locationType, String username, String password, String defaultRepo) {
        if (this.locationManagement.getExistingLocation(locUri) != null) {
            return false;
        }
        GraphDBReplicationCluster replicationCluster = this.getReplicationCluster();
        if (replicationCluster != null) {
            if (replicationCluster.getClusterGroup().getNodes().stream().map(n -> this.processLocationUri(n.getHttpAddress(), LocationType.GDB)).collect(Collectors.toSet()).contains(authType == AuthType.BASIC ? this.processLocationUri(locUri, locationType, username, password) : this.processLocationUri(locUri, locationType))) {
                throw new GraphDBWorkbenchException("Location " + locUri + " should not be one of the cluster nodes. " + String.valueOf(replicationCluster.getClusterGroup().getNodeIds()));
            }
            replicationCluster.validateLeadership();
        }
        try {
            SemanticLocationAuth semanticLocationAuth = this.locationManagement.addLocation(locUri, authType, locationType, username, password, defaultRepo);
            if (replicationCluster != null && !this.replicateLocationOperation(semanticLocationAuth, replicationCluster, LocationUpdate.OperationType.ADD)) {
                this.locationManagement.removeLocation(locUri);
                throw new GraphDBWorkbenchException("Unable to add location \"" + semanticLocationAuth.getLocation() + "\". Rolling back operation.");
            }
            if (this.semanticDataManagement.getCurrentLocation() == null) {
                if (!(semanticLocationAuth instanceof SemanticLocation)) {
                    throw new GraphDBWorkbenchException("Trying to change current location to one that is not repository location but " + locUri);
                }
                SemanticLocation semanticLocation = (SemanticLocation)semanticLocationAuth;
                if (!this.semanticDataManagement.changeLocation(semanticLocation)) {
                    throw new GraphDBWorkbenchException(semanticLocation.getErrorMsg());
                }
            }
        }
        catch (URISyntaxException | RepositoryException e) {
            throw new GraphDBWorkbenchException(ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        this.semanticDataManagement.publishLocationEvent(locUri, "semantic.location.changed");
        return true;
    }

    public boolean updateLocation(String locUri, AuthType authType, LocationType locationType, String username, String password, String defaultRepo) {
        SemanticLocationAuth existingLocation = this.locationManagement.getExistingLocation(locUri);
        if (existingLocation == null) {
            return false;
        }
        SemanticLocationAuth existingLocationBackup = new SemanticLocationAuth(locUri, existingLocation.getAuthType(), existingLocation.getLocationType(), existingLocation.getUsername(), existingLocation.getPassword(), existingLocation.getDefaultRepository());
        existingLocation.setUsername(username);
        if (password != null) {
            existingLocation.setPassword(password);
        }
        existingLocation.setAuthType(authType);
        existingLocation.setLocationType(locationType);
        existingLocation.setDefaultRepository(defaultRepo);
        existingLocation.updateRequestAuthenticator();
        GraphDBReplicationCluster replicationCluster = this.getReplicationCluster();
        if (replicationCluster != null) {
            replicationCluster.validateLeadership();
        }
        if (replicationCluster != null && !this.replicateLocationOperation(existingLocation, replicationCluster, LocationUpdate.OperationType.UPDATE)) {
            existingLocation.setUsername(existingLocationBackup.getUsername());
            existingLocation.setPassword(existingLocationBackup.getPassword());
            existingLocation.setAuthType(existingLocationBackup.getAuthType());
            existingLocation.setLocationType(existingLocationBackup.getLocationType());
            existingLocation.setDefaultRepository(existingLocationBackup.getDefaultRepository());
            existingLocation.updateRequestAuthenticator();
            throw new GraphDBWorkbenchException("Unable to update location \"" + locUri + "\". Rolling back operation.");
        }
        this.semanticDataManagement.publishLocationEvent(locUri, "semantic.location.changed");
        return true;
    }

    private boolean replicateLocationOperation(SemanticLocationAuth semanticLocationAuth, GraphDBReplicationCluster replicationCluster, LocationUpdate.OperationType operationType) {
        try {
            boolean replicationStatus = replicationCluster.replicateSystemUpdate((SystemUpdate)new LocationUpdate(semanticLocationAuth.getLocation(), semanticLocationAuth.getAuthType().name(), semanticLocationAuth.getLocationType().name(), semanticLocationAuth.getUsername(), semanticLocationAuth.getPassword(), semanticLocationAuth.getDefaultRepository(), operationType)) >= 1L;
            return replicationStatus;
        }
        catch (Exception e) {
            LOG.error("Unsuccessful replication for location: " + semanticLocationAuth.getLocation(), (Throwable)e);
            return false;
        }
    }

    public boolean deleteLocation(String location) {
        SemanticLocationAuth existingLocation = this.locationManagement.getExistingLocation(location);
        if (existingLocation == null) {
            return false;
        }
        if (existingLocation.isSystem()) {
            return false;
        }
        GraphDBReplicationCluster replicationCluster = this.getReplicationCluster();
        if (replicationCluster != null) {
            replicationCluster.validateLeadership();
        }
        try {
            this.semanticDataManagement.publishLocationEvent(existingLocation.getLocation(), "semantic.location.removed");
            this.locationManagement.removeLocation(location);
            if (replicationCluster != null && !this.replicateLocationOperation(existingLocation, replicationCluster, LocationUpdate.OperationType.DELETE)) {
                this.locationManagement.addLocation(existingLocation.getLocation(), existingLocation.getAuthType(), existingLocation.getLocationType(), existingLocation.getUsername(), existingLocation.getPassword(), existingLocation.getDefaultRepository());
                throw new GraphDBWorkbenchException("Unable to delete location \"" + existingLocation.getLocation() + "\". Rolling back operation.");
            }
        }
        catch (RuntimeException | URISyntaxException e) {
            throw new GraphDBWorkbenchException("Unsuccessful Location delete replication.", e);
        }
        return true;
    }

    @Nullable
    private GraphDBReplicationCluster getReplicationCluster() {
        return this.semanticDataManagement.getCurrentLocationOrThrow().getReplicationCluster();
    }

    private String processLocationUri(String locUri, LocationType locationType) {
        return this.processLocationUri(locUri, locationType, null, null);
    }

    private String processLocationUri(String locUri, LocationType locationType, String username, String password) {
        if (locationType == LocationType.GDB) {
            if (StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)password)) {
                return this.semanticDataManagement.fetchInstallationIdFromLocation(locUri, username, password);
            }
            return this.semanticDataManagement.fetchInstallationIdFromLocation(locUri);
        }
        return locUri.toLowerCase(Locale.ROOT);
    }
}

