/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core.semantic;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.forest.core.semantic.LocationPingResult;
import com.ontotext.forest.core.semantic.LocationType;
import com.ontotext.forest.core.semantic.StringSemanticRepositoryCacheLoader;
import com.ontotext.forest.core.semantic.location.SemanticLocationAuth;
import com.ontotext.forest.core.semantic.location.SemanticUpdateProcessor;
import com.ontotext.forest.core.semantic.remote.CustomRemoteRepositoryManager;
import com.ontotext.forest.core.semantic.repository.SemanticRepository;
import com.ontotext.forest.core.semantic.repository.SemanticRepositoryFactory;
import com.ontotext.forest.core.util.BeanServerRecoveryListener;
import com.ontotext.forest.core.util.RequestUtils;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.FederatedServiceAuthenticationResolver;
import com.ontotext.graphdb.GraphDBRepositoryAccessChecker;
import com.ontotext.graphdb.GraphDBRepositoryManager;
import com.ontotext.graphdb.GraphDBRepositoryManagerHolder;
import com.ontotext.graphdb.ServerMaintenanceListener;
import com.ontotext.graphdb.raft.ClusterGroup;
import com.ontotext.graphdb.raft.grpc.RpcServer;
import com.ontotext.graphdb.security.AuthType;
import com.ontotext.raft.GraphDBReplicationCluster;
import com.ontotext.raft.config.ClusterConfig;
import com.ontotext.raft.config.ClusterConfigService;
import com.ontotext.raft.config.DisabledClusterConfigService;
import com.ontotext.raft.repository.ClusterRepositoryManager;
import com.ontotext.raft.update.ExternalUpdateProcessor;
import com.ontotext.trree.OwlimSchemaRepository;
import com.ontotext.trree.monitorRepository.MonitorRepository;
import com.ontotext.trree.repository.RenameRepoService;
import com.ontotext.trree.util.ErrorUtil;
import com.ontotext.trree.util.HttpClientUtil;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.impl.TreeModel;
import org.eclipse.rdf4j.model.util.Configurations;
import org.eclipse.rdf4j.model.vocabulary.CONFIG;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.config.RepositoryConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.config.RepositoryConfigSchema;
import org.eclipse.rdf4j.repository.manager.RemoteRepositoryManager;
import org.eclipse.rdf4j.repository.manager.RepositoryInfo;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SemanticLocation
extends SemanticLocationAuth
implements Serializable {
    public static String HAS_ACTIVE_LOCATION_HEADER = "X-GraphDB-Has-Active";
    private static final long serialVersionUID = 3578139731700288201L;
    private static final Logger LOG = LoggerFactory.getLogger(SemanticLocation.class);
    public static final String REST_LOCATIONS_PING_LOCATION = "/rest/locations/ping-location";
    private final ServerMaintenanceListener serverRecoveryListener;
    private final FederatedServiceAuthenticationResolver serviceAuthenticationResolver;
    private ExternalUpdateProcessor updateProcessor;
    private final Map<String, Thread> restartingRepositoryThreads = new ConcurrentSkipListMap<String, Thread>();
    private final ReadWriteLock stateLock;
    @JsonIgnore
    private final transient SemanticRepositoryFactory repositoryFactory;
    private transient LoadingCache<String, SemanticRepository> repositories;
    private final transient String effectiveLocation;
    private int maxConnections;
    private transient CloseableHttpClient httpClient;
    private final transient GraphDBRepositoryAccessChecker repositoryAccessChecker;
    private transient RenameRepoService renameRepoService;
    private transient RepositoryManager repositoryManager;
    private transient ClusterConfigService clusterConfigService;
    private final transient Supplier<RpcServer> rpcServerSupplier;
    private transient String systemLocationId;
    private final transient File dataDir;
    private final transient boolean local;
    private String id;
    private volatile boolean initialized;
    private String errorMsg;

    @VisibleForTesting
    SemanticLocation(File dataDir, SemanticRepositoryFactory repositoryFactory) {
        super(dataDir.getAbsolutePath() + "/", AuthType.NONE, LocationType.GDB, null, null, null);
        this.dataDir = dataDir;
        this.effectiveLocation = dataDir.getAbsolutePath();
        this.repositoryFactory = repositoryFactory;
        this.repositoryAccessChecker = null;
        this.clusterConfigService = ClusterConfigService.defaultService();
        this.rpcServerSupplier = () -> new RpcServer(new LinkedList(), "localhost", Config.getRPCPort());
        this.id = UUID.randomUUID().toString();
        this.local = true;
        this.stateLock = new ReentrantReadWriteLock();
        this.serverRecoveryListener = new ServerRecoveryListenerDecorator(new BeanServerRecoveryListener(Collections.emptyList()));
        this.serviceAuthenticationResolver = FederatedServiceAuthenticationResolver.getNoOpInstance();
        this.updateProcessor = null;
    }

    public SemanticLocation(SemanticRepositoryFactory repositoryFactory, String location, AuthType authType, LocationType locationType, @Nullable String username, @Nullable String password, @Nullable String defaultRepository, String systemLocationId, @Nullable GraphDBRepositoryAccessChecker repositoryAccessChecker, Supplier<RpcServer> rpcServerSupplier, ClusterConfigService clusterConfigService, ServerMaintenanceListener serverRecoveryListener, FederatedServiceAuthenticationResolver serviceAuthenticationResolver, SemanticUpdateProcessor updateProcessor) throws URISyntaxException, RepositoryException, GraphDBWorkbenchException {
        super(location, authType, locationType, username, password, defaultRepository);
        this.serverRecoveryListener = new ServerRecoveryListenerDecorator(serverRecoveryListener);
        this.serviceAuthenticationResolver = serviceAuthenticationResolver;
        this.updateProcessor = updateProcessor;
        this.effectiveLocation = this.getLocation().isEmpty() ? Config.getDataDirectory() : this.getLocation();
        if (this.effectiveLocation.startsWith("http")) {
            this.local = false;
            this.dataDir = null;
            this.repositoryManager = this.createRemoteManager();
            this.clusterConfigService = DisabledClusterConfigService.INSTANCE;
        } else {
            this.clusterConfigService = clusterConfigService;
            this.local = true;
            this.dataDir = this.effectiveLocation.startsWith("file:/") ? new File(new URI(this.effectiveLocation)) : new File(this.effectiveLocation);
        }
        this.rpcServerSupplier = rpcServerSupplier;
        this.repositoryAccessChecker = repositoryAccessChecker;
        this.repositoryFactory = repositoryFactory;
        this.systemLocationId = systemLocationId;
        this.stateLock = new ReentrantReadWriteLock();
        this.renameRepoService = RenameRepoService.getInstance();
    }

    @Nullable
    public GraphDBReplicationCluster getReplicationCluster() {
        this.stateLock.readLock().lock();
        try {
            RepositoryManager repositoryManager = this.repositoryManager;
            if (repositoryManager instanceof ClusterRepositoryManager) {
                ClusterRepositoryManager clusterRepositoryManager = (ClusterRepositoryManager)repositoryManager;
                repositoryManager = clusterRepositoryManager.getReplicationCluster();
                return repositoryManager;
            }
            GraphDBReplicationCluster graphDBReplicationCluster = null;
            return graphDBReplicationCluster;
        }
        finally {
            this.stateLock.readLock().unlock();
        }
    }

    @Nonnull
    public GraphDBReplicationCluster getReplicationClusterOrThrow() {
        GraphDBReplicationCluster replicationCluster = this.getReplicationCluster();
        if (replicationCluster == null) {
            throw new IllegalStateException("Cluster does not exist.");
        }
        return replicationCluster;
    }

    public void createReplicationCluster(ClusterConfig clusterConfig) {
        this.stateLock.writeLock().lock();
        try {
            this.shutdown();
            try {
                this.getClusterConfigService().recordClusterGroup(clusterConfig);
            }
            finally {
                this.initializeAsNeeded();
            }
        }
        finally {
            this.stateLock.writeLock().unlock();
        }
    }

    public void updateReplicationCluster(ClusterConfig clusterConfig) {
        this.stateLock.writeLock().lock();
        try {
            this.getClusterConfigService().recordClusterGroup(clusterConfig);
        }
        finally {
            this.stateLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteReplicationCluster(boolean deleteRaftDirectories) {
        this.stateLock.writeLock().lock();
        try {
            ClusterGroup clusterGroup = null;
            GraphDBReplicationCluster replicationCluster = this.getReplicationCluster();
            if (replicationCluster != null) {
                clusterGroup = replicationCluster.getClusterGroup();
            }
            this.shutdown();
            try {
                this.getClusterConfigService().removeClusterGroup();
                if (deleteRaftDirectories && clusterGroup != null) {
                    clusterGroup.deleteRaftDirectories();
                }
            }
            finally {
                this.initializeAsNeeded();
            }
        }
        finally {
            this.stateLock.writeLock().unlock();
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void ensureLocationIsReachable() throws GraphDBWorkbenchException {
        block16: {
            try {
                if (this.isLocal()) break block16;
                try (CloseableHttpClient httpClient = this.createHttpClientForRemoteLocation(true);){
                    Object url = this.getLocation();
                    if (!((String)url).endsWith("/")) {
                        url = (String)url + "/";
                    }
                    HttpGet getVersionMethod = new HttpGet(new URI((String)url + "rest/locations/id"));
                    try (CloseableHttpResponse locationResponse = this.executeRequest(httpClient, getVersionMethod);){
                        String locationUniqueId = IOUtils.toString((InputStream)locationResponse.getEntity().getContent()).replaceAll("\"", "");
                        if (this.systemLocationId.equals(locationUniqueId)) {
                            throw new GraphDBWorkbenchException("Recursive location detected");
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new GraphDBWorkbenchException("Cannot connect to location " + e.getMessage(), e);
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public LocationPingResult pingLocationWithSigningHttpClient(String nodeSemanticLocation, boolean sendURL) {
        try {
            if (this.isLocal()) {
                try (CloseableHttpClient httpClient = this.createSigningHttpClientWithShortTimeout();){
                    LocationPingResult locationPingResult;
                    block28: {
                        URIBuilder builder = new URIBuilder(nodeSemanticLocation + REST_LOCATIONS_PING_LOCATION);
                        if (sendURL) {
                            builder.setParameter("url", this.getCanonicalExternalUrl());
                        }
                        HttpGet get = new HttpGet(builder.build());
                        CloseableHttpResponse locationResponse = httpClient.execute((HttpUriRequest)get);
                        try {
                            locationPingResult = this.pingResultFromResponse(!sendURL, (HttpResponse)locationResponse, "Authentication signature mismatch, check shared secret");
                            if (locationResponse == null) break block28;
                        }
                        catch (Throwable throwable) {
                            if (locationResponse != null) {
                                try {
                                    locationResponse.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        locationResponse.close();
                    }
                    return locationPingResult;
                }
            }
            try (CloseableHttpClient httpClient = this.createHttpClientForRemoteLocation(true);){
                LocationPingResult locationPingResult;
                block29: {
                    URIBuilder builder = new URIBuilder(this.getCanonicalExternalUrl() + REST_LOCATIONS_PING_LOCATION);
                    builder.setParameter("url", nodeSemanticLocation);
                    builder.setParameter("sendURL", "true");
                    HttpGet get = new HttpGet(builder.build());
                    CloseableHttpResponse locationResponse = httpClient.execute((HttpUriRequest)get);
                    try {
                        locationPingResult = this.pingResultFromResponse(false, (HttpResponse)locationResponse, "Authentication failed, check remote location credentials");
                        if (locationResponse == null) break block29;
                    }
                    catch (Throwable throwable) {
                        if (locationResponse != null) {
                            try {
                                locationResponse.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throw throwable;
                    }
                    locationResponse.close();
                }
                return locationPingResult;
            }
        }
        catch (Exception e) {
            LOG.warn("Cannot connect to remote location to verify connectivity", (Throwable)e);
            return new LocationPingResult(417, this.appendReverseMessage(!sendURL, ErrorUtil.getSaneExtraMessage((Throwable)e)));
        }
    }

    private LocationPingResult pingResultFromResponse(boolean isReverse, HttpResponse locationResponse, String authenticationFailureMessage) throws IOException {
        Object message;
        int status = locationResponse.getStatusLine().getStatusCode();
        if (status == 200) {
            message = "";
        } else if (status == 401) {
            message = authenticationFailureMessage;
            status = 417;
        } else if (status == 417) {
            message = IOUtils.toString((InputStream)locationResponse.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            status = 417;
        } else {
            message = "Generic error (HTTP status " + status + ")";
            status = 417;
        }
        return new LocationPingResult(status, this.appendReverseMessage(isReverse, (String)message));
    }

    private String appendReverseMessage(boolean isReverse, String message) {
        if (isReverse && !((String)message).isEmpty()) {
            message = (String)message + " (reverse direction)";
        }
        return message;
    }

    @VisibleForTesting
    public CloseableHttpClient createHttpClientForRemoteLocation(boolean forPing) {
        HttpClientBuilder builder = HttpClientUtil.createHttpClientBuilder((int)(forPing ? 4000 : -1), (int)(forPing ? 4000 : -1), (int)(forPing ? 1 : this.maxConnections), (int)(forPing ? 1 : this.maxConnections));
        this.updateRequestAuthenticator();
        builder.addInterceptorLast((httpRequest, httpContext) -> this.requestAuthenticator.process(httpRequest, httpContext));
        return builder.build();
    }

    @VisibleForTesting
    public CloseableHttpClient createSigningHttpClientWithShortTimeout() {
        return HttpClientUtil.createClusterSigningHttpClientWithShortTimeout();
    }

    private RemoteRepositoryManager createRemoteManager() throws GraphDBWorkbenchException {
        try {
            URL url = new URL(this.getLocation());
            if (StringUtils.isBlank((CharSequence)url.getHost())) {
                throw new GraphDBWorkbenchException("Remote location URL must have a hostname");
            }
        }
        catch (MalformedURLException e) {
            throw new GraphDBWorkbenchException("Invalid URL", e);
        }
        this.httpClient = this.createHttpClientForRemoteLocation(false);
        return new CustomRemoteRepositoryManager(this.getLocation(), (HttpClient)this.httpClient);
    }

    @Nonnull
    public SemanticRepository getRepository(String repositoryID) {
        SemanticRepository repository = (SemanticRepository)this.repositories.getUnchecked((Object)repositoryID);
        try {
            if (!this.repositoryManager.hasRepositoryConfig(repositoryID)) {
                LOG.debug("Repository '{}' was deleted, removing it from the cache and throwing and exception", (Object)repositoryID);
                repository.shutdown();
                this.repositories.invalidate((Object)repository);
                throw new IllegalArgumentException("Repository '" + repositoryID + "' doesn't exist");
            }
        }
        catch (RepositoryException | RepositoryConfigException e) {
            throw new IllegalArgumentException("Couldn't get repository configuration for " + repositoryID, e);
        }
        return repository;
    }

    @Nonnull
    public RepositoryManager sesameManager() {
        this.stateLock.readLock().lock();
        try {
            RepositoryManager repositoryManager = this.repositoryManager;
            return repositoryManager;
        }
        finally {
            this.stateLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iterateRepositories(BiConsumer<String, OwlimSchemaRepository> repoConsumer) {
        this.stateLock.readLock().lock();
        try {
            if (!(this.repositoryManager instanceof GraphDBRepositoryManager)) {
                throw new IllegalStateException("Cannot iterate repositories of repository manager type: " + String.valueOf(this.repositoryManager.getClass()));
            }
            for (RepositoryInfo repoInfo : this.repositoryManager.getAllRepositoryInfos()) {
                OwlimSchemaRepository sail = null;
                if (this.isGraphDBRepository(this.repositoryManager, repoInfo.getId())) {
                    sail = ((MonitorRepository)this.repositoryManager.getRepository(repoInfo.getId())).getOwlimSail();
                }
                repoConsumer.accept(repoInfo.getId(), sail);
            }
        }
        finally {
            this.stateLock.readLock().unlock();
        }
    }

    private boolean isGraphDBRepository(RepositoryManager repositoryManager, String repositoryId) {
        RepositoryConfig repositoryConfig = repositoryManager.getRepositoryConfig(repositoryId);
        return repositoryConfig.getRepositoryImplConfig().getType().equals("graphdb:SailRepository");
    }

    public String createRepository(ByteArrayInputStream config) throws RDFParseException, IOException, RDFHandlerException, RepositoryConfigException, RepositoryException, GraphDBWorkbenchException {
        RepositoryConfig repositoryConfig = this.getRepositoryConfig(config);
        return this.createRepository(repositoryConfig);
    }

    public RepositoryConfig getRepositoryConfig(ByteArrayInputStream config) throws IOException {
        TreeModel graph = new TreeModel();
        RDFParser rdfParser = Rio.createParser((RDFFormat)RDFFormat.TURTLE);
        rdfParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)graph));
        rdfParser.parse((InputStream)config, "tag:rdf4j.org,2023:config/");
        return RepositoryConfig.create((Model)graph, (Resource)this.getAndValidateRepositoryNode((Model)graph));
    }

    private Resource getAndValidateRepositoryNode(Model graph) {
        Resource repositoryNode = (Resource)Configurations.getSubjectByType((Model)graph, (IRI)CONFIG.Rep.Repository, (IRI)RepositoryConfigSchema.REPOSITORY).orElseThrow(() -> new RepositoryConfigException("Repository node is not defined correctly."));
        Literal repositoryID = (Literal)Configurations.getLiteralValue((Model)graph, (Resource)repositoryNode, (IRI)CONFIG.Rep.id, (IRI)RepositoryConfigSchema.REPOSITORYID).orElseThrow(() -> new RepositoryConfigException("No repositoryID found in configuration file."));
        if (!repositoryID.stringValue().matches("^[a-zA-Z0-9-_]+$")) {
            throw new RepositoryConfigException("Invalid repository ID " + repositoryID.stringValue());
        }
        Resource repoImpl = (Resource)Configurations.getResourceValue((Model)graph, (Resource)repositoryNode, (IRI)CONFIG.Rep.impl, (IRI)RepositoryConfigSchema.REPOSITORYIMPL).orElseThrow(() -> new RepositoryConfigException("No repositoryImpl found in configuration file."));
        Configurations.getValue((Model)graph, (Resource)repoImpl, (IRI)CONFIG.Rep.type, (IRI)RepositoryConfigSchema.REPOSITORYTYPE).orElseThrow(() -> new RepositoryConfigException("No repositoryType found in configuration file."));
        return repositoryNode;
    }

    public RepositoryConfig getRepositoryConfiguration(String repositoryID) throws RepositoryException, RepositoryConfigException {
        return this.sesameManager().getRepositoryConfig(repositoryID);
    }

    public void editRepositoryConfiguration(RepositoryConfig config, String newRepoID) throws RepositoryException, RepositoryConfigException {
        RepositoryManager repositoryManager = this.sesameManager();
        RepositoryConfig oldConfiguration = repositoryManager.getRepositoryConfig(config.getID());
        try {
            this.editRepositoryConfigurationInternal(config, repositoryManager);
            this.changeRepositoryName(config, repositoryManager, newRepoID);
        }
        catch (RepositoryException e) {
            this.editRepositoryConfigurationInternal(oldConfiguration, repositoryManager);
            throw e;
        }
    }

    private void editRepositoryConfigurationInternal(RepositoryConfig config, RepositoryManager repositoryManager) throws RepositoryException, RepositoryConfigException {
        this.validateClusterLeader(ClusterOperation.EDIT);
        this.repositories.invalidate((Object)config.getID());
        repositoryManager.addRepositoryConfig(config);
    }

    private void changeRepositoryName(RepositoryConfig config, RepositoryManager repositoryManager, String newRepoID) throws RepositoryException {
        try {
            if (!config.getID().equals(newRepoID)) {
                this.renameRepoService.updateRepoId(config.getID(), newRepoID, repositoryManager);
                if (repositoryManager instanceof ClusterRepositoryManager) {
                    ((ClusterRepositoryManager)repositoryManager).changeRepositoryID(config.getID(), newRepoID);
                }
            }
        }
        catch (RepositoryException | RepositoryConfigException e) {
            repositoryManager.removeRepository(newRepoID);
            throw new RepositoryException(e);
        }
    }

    public String createRepository(RepositoryConfig config) throws RepositoryConfigException, RepositoryException, GraphDBWorkbenchException {
        this.validateClusterLeader(ClusterOperation.CREATE);
        RepositoryManager repositoryManager = this.sesameManager();
        if (repositoryManager.getRepositoryIDs().stream().anyMatch(s -> s.equalsIgnoreCase(config.getID()))) {
            throw new GraphDBWorkbenchException("Repository " + config.getID() + " already exists.");
        }
        repositoryManager.addRepositoryConfig(config);
        return config.getID();
    }

    public boolean containsRepository(String repositoryID) {
        try {
            return this.sesameManager().hasRepositoryConfig(repositoryID);
        }
        catch (RepositoryException e) {
            throw new IllegalStateException("Couldn't connect to the SYSTEM repository while getting info for " + repositoryID, e);
        }
        catch (RepositoryConfigException e) {
            throw new IllegalStateException("There was a configuration error for " + repositoryID, e);
        }
    }

    @Override
    public String getLabel() {
        if (this.isSystem()) {
            return "Local";
        }
        if (this.isLocal()) {
            return "Local legacy (" + this.getLocation() + ")";
        }
        return "Remote (" + this.getLocation() + ")";
    }

    public GraphDBRepositoryAccessChecker getRepositoryAccessChecker() {
        return this.repositoryAccessChecker;
    }

    @Override
    public boolean isLocal() {
        return this.local;
    }

    public Set<String> getRepositoryIDs() throws RepositoryException {
        return this.sesameManager().getRepositoryIDs();
    }

    public String getRepositoryLocation(String repositoryID) {
        return this.effectiveLocation + (this.effectiveLocation.endsWith("/") ? "" : "/") + "repositories/" + repositoryID;
    }

    public String getRepositoryLocation(SemanticRepository repository) {
        return this.getRepositoryLocation(repository.getRepositoryID());
    }

    public Set<String> getCurrentLocationRepositoryIds() throws GraphDBWorkbenchException {
        return (Set)new WithManagerInitalization<Set<String>>(this){

            @Override
            protected Set<String> doWithManager(RepositoryManager manager) throws Exception {
                return manager.getRepositoryIDs();
            }
        }.run();
    }

    public String getCanonicalExternalRepositoryUrl(String repositoryId) {
        return this.getCanonicalExternalUrl() + "/repositories/" + repositoryId;
    }

    public String getWorkbenchExternalRepositoryURL(String repositoryId) {
        return this.getWorkbenchExternalURL() + "/repositories/" + repositoryId;
    }

    public String getWorkbenchExternalURL() {
        if (this.isLocal()) {
            HttpServletRequest request = RequestUtils.getRequest();
            return Config.getInternalUrl((String)request.getHeader("Referer"), (String)request.getScheme(), (String)request.getServerName(), (int)request.getServerPort());
        }
        return this.effectiveLocation;
    }

    public String getCanonicalExternalUrl() {
        if (this.isLocal()) {
            HttpServletRequest request = RequestUtils.getRequest();
            return Config.getExternalUrl((String)request.getHeader("Referer"), (String)request.getScheme(), (String)request.getServerName(), (int)request.getServerPort());
        }
        return this.effectiveLocation;
    }

    public boolean removeRepository(String repositoryID) throws RepositoryConfigException, RepositoryException {
        this.validateClusterLeader(ClusterOperation.DELETE);
        SemanticRepository repo = (SemanticRepository)this.repositories.getIfPresent((Object)repositoryID);
        if (repo != null) {
            repo.shutdown();
        }
        this.repositories.invalidate((Object)repositoryID);
        boolean success = this.repositoryManager.removeRepository(repositoryID);
        if (success && repositoryID.equals(this.getDefaultRepository())) {
            this.setDefaultRepository(null);
        }
        return success;
    }

    public void shutdown() throws RepositoryException {
        if (!this.initialized) {
            return;
        }
        if (this.isLocal()) {
            this.sesameManager().shutDown();
            this.initialized = false;
        }
    }

    @Override
    public void close() {
        this.shutdown();
        if (!this.isLocal()) {
            if (this.repositoryManager != null) {
                this.repositoryManager.shutDown();
            }
            if (this.httpClient != null) {
                try {
                    this.httpClient.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.httpClient = null;
        }
    }

    @Override
    public String getErrorMsg() {
        return this.errorMsg;
    }

    @Override
    public final boolean initializeAsNeeded() {
        this.stateLock.writeLock().lock();
        try {
            this.errorMsg = null;
            try {
                if (!this.initialized) {
                    if (this.isLocal()) {
                        this.repositoryManager = this.createRepositoryManager();
                        this.repositoryManager.init();
                        this.ensureLocationIsReachable();
                        new GraphDBRepositoryManagerHolder().setRepositoryManager((GraphDBRepositoryManager)this.repositoryManager);
                    }
                } else if (!this.isLocal()) {
                    this.ensureLocationIsReachable();
                }
            }
            catch (GraphDBWorkbenchException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Cannot establish connection to location.", (Throwable)e);
                } else {
                    LOG.warn("Cannot establish connection to location: {}", (Object)e.getMessage());
                }
                this.errorMsg = e.getMessage();
            }
            catch (Exception e) {
                LOG.warn("Cannot init repository manager.", (Throwable)e);
                this.errorMsg = e.getMessage();
            }
            if (this.initialized) {
                boolean bl = false;
                return bl;
            }
            this.loadRepositoriesFromCache();
            this.initialized = true;
            boolean bl = true;
            return bl;
        }
        finally {
            this.stateLock.writeLock().unlock();
        }
    }

    protected void onClusterRepositoryChange() {
        if (this.initialized) {
            this.loadRepositoriesFromCache();
        }
    }

    private void loadRepositoriesFromCache() {
        this.repositories = CacheBuilder.newBuilder().build((CacheLoader)new StringSemanticRepositoryCacheLoader(this.sesameManager(), this.repositoryFactory, this.isLocal()));
    }

    private RepositoryManager createRepositoryManager() {
        if (this.clusterConfigService.isClusterEnabled()) {
            return new ClusterRepositoryManager(this.dataDir, this.clusterConfigService, this.rpcServerSupplier.get(), this.repositoryAccessChecker, this.serverRecoveryListener, this.serviceAuthenticationResolver, this.updateProcessor, this::onClusterRepositoryChange);
        }
        return new GraphDBRepositoryManager(this.dataDir, this.repositoryAccessChecker, this.serverRecoveryListener, this.serviceAuthenticationResolver);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Thread restartRepository(String repositoryID) {
        if (!this.isLocal()) {
            throw new IllegalStateException("Only local locations may invoke restartRepository() directly");
        }
        this.validateClusterLeader(ClusterOperation.RESTART);
        GraphDBRepositoryManager graphDBRepositoryManager = (GraphDBRepositoryManager)this.repositoryManager;
        if (graphDBRepositoryManager instanceof ClusterRepositoryManager) {
            ClusterRepositoryManager clusterRepositoryManager = (ClusterRepositoryManager)graphDBRepositoryManager;
            clusterRepositoryManager.restartRepo(repositoryID);
        }
        return this.getRestartingThread(repositoryID, graphDBRepositoryManager);
    }

    @NotNull
    public Thread getRestartingThread(String repositoryID, GraphDBRepositoryManager graphDBRepositoryManager) {
        return this.restartingRepositoryThreads.computeIfAbsent(repositoryID, id -> {
            Thread restartThread = new Thread(() -> {
                try {
                    LOG.info("Restarting repository {}", (Object)repositoryID);
                    this.repositories.invalidate((Object)repositoryID);
                    graphDBRepositoryManager.restartRepository(repositoryID);
                    LOG.info("Repository {} was restarted successfully", (Object)repositoryID);
                }
                catch (Exception e) {
                    LOG.error("Could not restart repository " + repositoryID, (Throwable)e);
                }
                finally {
                    this.restartingRepositoryThreads.remove(repositoryID);
                }
            });
            restartThread.setDaemon(true);
            restartThread.setName("restart-repository-" + repositoryID);
            restartThread.start();
            return restartThread;
        });
    }

    private CloseableHttpResponse executeRequest(CloseableHttpClient httpClient, HttpGet httpGet) throws IOException {
        CloseableHttpResponse locationResponse = httpClient.execute((HttpUriRequest)httpGet);
        if (locationResponse.getStatusLine().getStatusCode() == 401) {
            throw new GraphDBWorkbenchException("Authentication required");
        }
        if (locationResponse.getStatusLine().getStatusCode() == 403) {
            throw new GraphDBWorkbenchException("Not a valid GraphDB instance or the provided user for authentication is not an admin");
        }
        if (locationResponse.getStatusLine().getStatusCode() != 200) {
            throw new GraphDBWorkbenchException("Not a valid GraphDB instance");
        }
        Header hasActiveLocationHeader = locationResponse.getFirstHeader(HAS_ACTIVE_LOCATION_HEADER);
        if (hasActiveLocationHeader != null && "false".equalsIgnoreCase(hasActiveLocationHeader.getValue())) {
            throw new GraphDBWorkbenchException("There is no active location!");
        }
        return locationResponse;
    }

    @VisibleForTesting
    public String getEffectiveLocation() {
        return this.effectiveLocation;
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public ClusterConfigService getClusterConfigService() {
        return this.clusterConfigService;
    }

    @VisibleForTesting
    public void setRenameRepoService(RenameRepoService renameRepoService) {
        this.renameRepoService = renameRepoService;
    }

    @VisibleForTesting
    public void setUpdateProcessor(ExternalUpdateProcessor externalUpdateProcessor) {
        this.updateProcessor = externalUpdateProcessor;
    }

    @VisibleForTesting
    protected void setClusterConfigService(ClusterConfigService config) {
        this.clusterConfigService = config;
    }

    public void notifyReposOfClusterCreation(boolean createInProgress) {
        this.repositories.asMap().values().forEach(semanticRepository -> {
            Repository repository = semanticRepository.getRepository();
            if (repository instanceof MonitorRepository) {
                MonitorRepository monitorRepository = (MonitorRepository)repository;
                monitorRepository.getOwlimSail().setIsClusterBeingCreated(createInProgress);
            }
        });
    }

    private void validateClusterLeader(ClusterOperation operation) {
        GraphDBReplicationCluster replicationCluster = this.getReplicationCluster();
        if (replicationCluster != null && replicationCluster.getClusterGroup().isSecondary()) {
            throw new GraphDBWorkbenchException("Secondary cluster nodes cannot directly " + operation.getOperation() + " repositories");
        }
    }

    private class ServerRecoveryListenerDecorator
    implements ServerMaintenanceListener {
        private final ServerMaintenanceListener serverRecoveryListener;

        public ServerRecoveryListenerDecorator(ServerMaintenanceListener serverRecoveryListener) {
            this.serverRecoveryListener = serverRecoveryListener;
        }

        public void lockForMaintenance() {
            this.serverRecoveryListener.lockForMaintenance();
        }

        public int getOrderIndex() {
            return this.serverRecoveryListener.getOrderIndex();
        }

        public void unlockAfterMaintenance() {
            try {
                this.serverRecoveryListener.unlockAfterMaintenance();
            }
            finally {
                if (SemanticLocation.this.repositories != null) {
                    SemanticLocation.this.repositories.invalidateAll();
                }
            }
        }
    }

    private static enum ClusterOperation {
        EDIT("edit"),
        CREATE("create"),
        DELETE("delete"),
        RESTART("restart");

        private final String operation;

        private ClusterOperation(String operation) {
            this.operation = operation;
        }

        public String getOperation() {
            return this.operation;
        }
    }

    public abstract class WithManagerInitalization<T> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public T run() throws GraphDBWorkbenchException {
            boolean didInit = false;
            RepositoryManager manager = SemanticLocation.this.sesameManager();
            try {
                try {
                    didInit = SemanticLocation.this.initializeAsNeeded();
                    T t = this.doWithManager(manager);
                    return t;
                }
                finally {
                    if (didInit) {
                        SemanticLocation.this.shutdown();
                    }
                }
            }
            catch (Exception e) {
                if (!(e instanceof GraphDBWorkbenchException)) throw new GraphDBWorkbenchException("Error processing request", e);
                throw (GraphDBWorkbenchException)e;
            }
        }

        protected abstract T doWithManager(RepositoryManager var1) throws Exception;
    }
}

