/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core.semantic;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.forest.core.semantic.LastRunSemanticStateHelper;
import com.ontotext.forest.core.semantic.LocationType;
import com.ontotext.forest.core.semantic.SemanticLocation;
import com.ontotext.forest.core.semantic.location.SemanticLocationAuth;
import com.ontotext.forest.core.semantic.repository.SemanticRepository;
import com.ontotext.forest.core.util.PropertyChangedEvent;
import com.ontotext.forest.core.util.RequestUtils;
import com.ontotext.graphdb.GraphDBRepositoryManager;
import com.ontotext.graphdb.GraphDBRepositoryManagerHolder;
import com.ontotext.raft.config.ClusterConfig;
import com.ontotext.raft.repository.ClusterRepositoryManager;
import com.ontotext.trree.util.HttpClientUtil;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.annotation.PreDestroy;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URISyntaxException;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class SemanticDataManagement
implements ApplicationEventPublisherAware {
    public static final String GRAPHDB_REPOSITORY_LOCATION_HEADER = "X-GraphDB-Repository-Location";
    private ApplicationEventPublisher publisher;
    @Nullable
    private SemanticLocation currentLocation;
    private static final Logger LOG = LoggerFactory.getLogger(SemanticDataManagement.class);
    private final LastRunSemanticStateHelper lastRunSemanticStateHelper;
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Autowired
    public SemanticDataManagement(@Lazy LastRunSemanticStateHelper lastRunSemanticStateHelper) {
        this.lastRunSemanticStateHelper = lastRunSemanticStateHelper;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    public boolean changeLocation(@Nullable SemanticLocation semanticLocation) throws RepositoryException {
        return this.changeLocation(semanticLocation, false);
    }

    @VisibleForTesting
    public boolean changeLocation(@Nullable SemanticLocation semanticLocation, boolean forceChange) throws RepositoryException {
        if (this.currentLocation == semanticLocation) {
            return true;
        }
        SemanticLocation previousLocation = this.currentLocation;
        if (semanticLocation != null) {
            if (semanticLocation.getLocationType() == LocationType.ONTOPIC) {
                return false;
            }
            semanticLocation.initializeAsNeeded();
            if (!forceChange && !StringUtils.isEmpty((CharSequence)semanticLocation.getErrorMsg())) {
                return false;
            }
            this.currentLocation = semanticLocation;
            this.publishLocationProperties(semanticLocation.getLocation());
            RepositoryManager repositoryManager = this.currentLocation.sesameManager();
            if (this.currentLocation.isLocal()) {
                new GraphDBRepositoryManagerHolder().setRepositoryManager((GraphDBRepositoryManager)repositoryManager);
            } else {
                new GraphDBRepositoryManagerHolder().setRepositoryManager(null);
            }
        } else {
            this.currentLocation = null;
            this.publishLocationProperties("");
        }
        if (previousLocation != null) {
            previousLocation.shutdown();
        }
        return true;
    }

    @PreDestroy
    public void shutdownCurrentLocation() throws RepositoryException {
        LOG.info("Shutting down current semantic location");
        if (this.currentLocation != null) {
            this.currentLocation.close();
        }
    }

    private void publishLocationProperties(String location) {
        this.publisher.publishEvent((ApplicationEvent)new PropertyChangedEvent(this, "current.location", location));
    }

    public void publishLocationEvent(String location, String event) {
        this.publisher.publishEvent((ApplicationEvent)new PropertyChangedEvent(this, event, location));
    }

    public void publishRepositoryChangedEvent(String oldRepoId, String newRepoId) {
        this.publisher.publishEvent((ApplicationEvent)new PropertyChangedEvent(oldRepoId, "repository.id.changed", newRepoId));
    }

    public void publishRepositoryDeletionEvent(String repoId) {
        this.publisher.publishEvent((ApplicationEvent)new PropertyChangedEvent(repoId, "repository.id.deleted", ""));
    }

    @Deprecated
    @Nonnull
    public RepositoryConnection getConnection() {
        SemanticRepository currentRepository = this.getCurrentRepository();
        if (currentRepository == null) {
            throw new IllegalStateException("You are not connected to any repository at the moment.");
        }
        return currentRepository.getConnection();
    }

    @Nullable
    public SemanticRepository getCurrentRepository() {
        HttpServletRequest request = RequestUtils.getRequest();
        if (request == null) {
            throw new IllegalStateException("No request was set by the requestFilter");
        }
        return this.getCurrentRepository(request);
    }

    @Nullable
    public SemanticRepository getCurrentRepository(HttpServletRequest request) {
        String locationHeader = request.getHeader(GRAPHDB_REPOSITORY_LOCATION_HEADER);
        SemanticLocation semanticLocation = this.lastRunSemanticStateHelper.getExplicitOrCurrentRepositoryLocation(locationHeader);
        String repositoryName = request.getHeader("X-GraphDB-Repository");
        if (StringUtils.isNotBlank((CharSequence)repositoryName)) {
            if (semanticLocation != null) {
                if (semanticLocation.containsRepository(repositoryName)) {
                    return this.getRepositoryFromLocation(semanticLocation, repositoryName);
                }
                LOG.warn("You have a non existing repository '{}' in the headers. Continuing anyways...", (Object)repositoryName);
            }
        } else if (semanticLocation != null && StringUtils.isNotBlank((CharSequence)(repositoryName = semanticLocation.getDefaultRepository()))) {
            if (semanticLocation.containsRepository(repositoryName)) {
                return this.getRepositoryFromLocation(semanticLocation, repositoryName);
            }
            semanticLocation.setDefaultRepository(null);
        }
        return null;
    }

    private SemanticRepository getRepositoryFromLocation(SemanticLocation currentLocation, String repositoryName) {
        return currentLocation.getRepository(repositoryName);
    }

    @Nonnull
    public SemanticRepository getCurrentRepositoryOrThrow() throws GraphDBWorkbenchException {
        return this.getCurrentRepositoryOrThrow("There is no active repository.");
    }

    @Nonnull
    public SemanticRepository getCurrentRepositoryOrThrow(String errorMessage) throws GraphDBWorkbenchException {
        SemanticRepository currentRepository = this.getCurrentRepository();
        if (currentRepository == null) {
            throw new GraphDBWorkbenchException(errorMessage);
        }
        return currentRepository;
    }

    public String getUniqueRepositoryId(SemanticRepository repository) {
        return this.getUniqueRepositoryId(repository.getRepositoryID());
    }

    public String getUniqueRepositoryId(String repositoryId) {
        String repoSeed = this.getLocationFromHeaderOrThrow().getLabel() + repositoryId;
        return DigestUtils.sha1Hex((String)repoSeed);
    }

    public String getUniqueLocationId() {
        String locationSeed = this.getCurrentLocationOrThrow().getLocation();
        return DigestUtils.sha1Hex((String)locationSeed);
    }

    public SemanticLocation getCurrentLocation() {
        return this.getCurrentLocation(RequestUtils.getRequest());
    }

    @Nullable
    public SemanticLocation getCurrentLocation(HttpServletRequest request) {
        this.lastRunSemanticStateHelper.initLocationAndRepositoryOnce(request);
        return this.currentLocation;
    }

    public void locationRemoved(SemanticLocationAuth semanticLocation) throws RepositoryException {
        SemanticLocation location = this.getCurrentLocation();
        if (location != null && location.getLocation().equals(semanticLocation.getLocation())) {
            this.changeLocation(null);
        }
    }

    @Nonnull
    public SemanticLocation getCurrentLocationOrThrow() {
        SemanticLocation location = this.getCurrentLocation();
        if (location == null) {
            throw new IllegalStateException("There is no active location.");
        }
        return location;
    }

    public String getCurrentRepositoryLocation() throws GraphDBWorkbenchException {
        return this.getCurrentLocationOrThrow().getRepositoryLocation(this.getCurrentRepositoryOrThrow());
    }

    public boolean isClusterExisting() {
        try {
            return this.getCurrentLocationOrThrow().sesameManager() instanceof ClusterRepositoryManager;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getDefaultRepository() {
        SemanticLocation currentLocation = this.getCurrentLocation();
        if (currentLocation != null) {
            return currentLocation.getDefaultRepository();
        }
        return null;
    }

    public boolean removeRepositoryFromLocation(SemanticLocation semanticLocation, String repositoryID) {
        if (semanticLocation.removeRepository(repositoryID)) {
            this.publishRepositoryDeletionEvent(repositoryID);
            this.publishLocationEvent(semanticLocation.getLocation(), "semantic.location.changed");
            return true;
        }
        return false;
    }

    public SemanticLocation getLocationFromHeaderOrThrow(String locationHeader) {
        return this.lastRunSemanticStateHelper.getExplicitOrCurrentRepositoryLocation(locationHeader);
    }

    public SemanticLocation getLocationFromHeaderOrThrow() {
        HttpServletRequest request = RequestUtils.getRequest();
        String location = "";
        if (request != null && StringUtils.isEmpty((CharSequence)(location = request.getHeader(GRAPHDB_REPOSITORY_LOCATION_HEADER)))) {
            location = request.getParameter("location");
        }
        return this.getLocationFromHeaderOrThrow(location);
    }

    public void removeObsoleteClusterLocations(ClusterConfig clusterConfig) {
        this.lastRunSemanticStateHelper.removeObsoleteClusterLocations(clusterConfig);
    }

    public List<String> getGDBLocationsInstallationIds() {
        return this.lastRunSemanticStateHelper.getLocations().stream().filter(location -> location.getLocationType() == LocationType.GDB && StringUtils.isNotBlank((CharSequence)location.getLocation())).map(location -> this.fetchInstallationIdFromLocation(location.getLocation())).collect(Collectors.toList());
    }

    public String fetchInstallationIdFromLocation(String locationAddress) {
        return this.fetchInstallationIdFromLocation(locationAddress, null, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String fetchInstallationIdFromLocation(String locationAddress, String username, String password) {
        try (CloseableHttpClient httpClient = HttpClientUtil.createClusterSigningHttpClientWithShortTimeout();){
            URIBuilder builder = new URIBuilder(locationAddress + "/rest/graphdb-settings/license");
            HttpGet get = new HttpGet(builder.build());
            Object authorizationHeader = null;
            if (username != null && password != null) {
                String auth = username + ":" + password;
                String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes());
                authorizationHeader = "Basic " + encodedAuth;
            } else {
                HttpServletRequest request = RequestUtils.getRequest();
                if (request != null) {
                    authorizationHeader = request.getHeader("Authorization");
                }
            }
            if (StringUtils.isNotEmpty(authorizationHeader)) {
                get.setHeader("Authorization", (String)authorizationHeader);
            }
            try (CloseableHttpResponse licenseResponse = httpClient.execute((HttpUriRequest)get);){
                int status = licenseResponse.getStatusLine().getStatusCode();
                if (status == 200) {
                    JsonNode licenseNode = this.objectMapper.readTree(licenseResponse.getEntity().getContent());
                    JsonNode installationId = licenseNode.get("installationId");
                    if (installationId.isMissingNode()) {
                        throw new IllegalStateException("Installation ID missing in response. Ensure that the requested GraphDB instance is up-to-date.");
                    }
                    String string = installationId.asText();
                    return string;
                }
                throw new HttpResponseException(status, String.format("Failed to fetch installation ID from '%s': Received status code %d", locationAddress, status));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("I/O error while trying to fetch installation ID from '%s'. Check if the location is reachable.", locationAddress), e);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("Invalid URI syntax for location address '%s'", locationAddress), e);
        }
    }
}

