/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core.semantic;

import com.google.common.annotations.VisibleForTesting;
import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.forest.core.semantic.LocationType;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.semantic.SemanticLocation;
import com.ontotext.forest.core.semantic.SemanticLocationManagement;
import com.ontotext.forest.core.semantic.SemanticProperties;
import com.ontotext.forest.core.semantic.location.SemanticLocationAuth;
import com.ontotext.forest.core.util.ResourceUtils;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.raft.grpc.NodeInfo;
import com.ontotext.raft.config.ClusterConfig;
import com.ontotext.raft.config.ClusterConfigService;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class LastRunSemanticStateHelper {
    private static final Logger LOG = LoggerFactory.getLogger(LastRunSemanticStateHelper.class);
    @Autowired
    private SemanticDataManagement dataManagement;
    @Autowired
    private SemanticLocationManagement locationManagement;
    @Autowired
    private ResourceUtils resourceUtils;
    @Autowired
    private SemanticProperties semanticProperties;
    private AtomicBoolean initialized = new AtomicBoolean();

    @VisibleForTesting
    void setInitialized(boolean initialized) {
        this.initialized.set(initialized);
    }

    @VisibleForTesting
    void setLocationManagement(SemanticLocationManagement locationManagement) {
        this.locationManagement = locationManagement;
    }

    @VisibleForTesting
    void setSemanticDataManagement(SemanticDataManagement dataManagement) {
        this.dataManagement = dataManagement;
    }

    public boolean isInitialized() {
        return this.initialized.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initLocationAndRepositoryOnce(HttpServletRequest request) {
        if (!this.initialized.compareAndSet(false, true)) {
            return;
        }
        LastRunSemanticStateHelper lastRunSemanticStateHelper = this;
        synchronized (lastRunSemanticStateHelper) {
            this.initState();
            SemanticLocation systemLocation = null;
            try {
                systemLocation = this.locationManagement.getSystemLocation();
            }
            catch (GraphDBWorkbenchException | URISyntaxException | RepositoryException e) {
                LOG.error("Couldn't init system location", e);
            }
            if (this.dataManagement.getCurrentLocation(request) == null && systemLocation != null) {
                try {
                    this.dataManagement.changeLocation(systemLocation);
                }
                catch (RepositoryException e) {
                    LOG.error("Couldn't activate system location", (Throwable)e);
                }
            }
        }
        this.dataManagement.publishLocationEvent("", "semantic.locations.initialized");
        this.removeObsoleteClusterLocations();
    }

    private void initState() {
        String location = this.semanticProperties.getLocation();
        this.checkDeprecated();
        try {
            if (StringUtils.isNotBlank((CharSequence)location)) {
                SemanticLocationAuth semanticLocation = this.locationManagement.getExistingLocation(location);
                if (!(semanticLocation instanceof SemanticLocation)) {
                    LOG.error("The active location should be {} but it was {}", SemanticLocation.class, semanticLocation.getClass());
                    return;
                }
                LOG.info("Connecting to location {}", (Object)location);
                this.dataManagement.changeLocation((SemanticLocation)semanticLocation, true);
            }
        }
        catch (Exception ex) {
            LOG.error("Couldn't init location from last time", (Throwable)ex);
        }
    }

    private void checkDeprecated() {
        String oldRepoData = (String)this.resourceUtils.getProperty("repo.data");
        if (StringUtils.isNotBlank((CharSequence)oldRepoData)) {
            LOG.error("Found system property 'repo.data'. This property has been deprecated, see the documentation.");
        }
    }

    public SemanticLocation getExplicitOrCurrentRepositoryLocation(@Nullable String location) throws GraphDBWorkbenchException {
        if (StringUtils.isEmpty((CharSequence)location)) {
            return this.dataManagement.getCurrentLocationOrThrow();
        }
        SemanticLocationAuth semanticLocationAuth = this.locationManagement.getExistingLocationOrThrow(location);
        if (!(semanticLocationAuth instanceof SemanticLocation)) {
            throw new GraphDBWorkbenchException("The required location " + location + " should always be a " + String.valueOf(SemanticLocation.class) + ", but it was: " + String.valueOf(semanticLocationAuth.getClass()));
        }
        return (SemanticLocation)semanticLocationAuth;
    }

    private void removeObsoleteClusterLocations() {
        ClusterConfig clusterConfig;
        ClusterConfigService clusterConfigService = this.locationManagement.getClusterConfigService();
        if (clusterConfigService.isClusterEnabled() && (clusterConfig = clusterConfigService.fetchClusterConfig()) != null) {
            List clusterMembers = clusterConfig.getNodes().stream().map(NodeInfo::getHttpAddress).map(httpAddress -> httpAddress.toLowerCase(Locale.ROOT)).collect(Collectors.toList());
            clusterMembers.retainAll(this.locationManagement.getLocationURIs().stream().map(uri -> uri.toLowerCase(Locale.ROOT)).collect(Collectors.toList()));
            if (!clusterMembers.isEmpty()) {
                LOG.info("Detected outdated cluster configuration. Removing obsolete remote locations to align with the current cluster state.");
                for (String location : this.locationManagement.getLocationURIs()) {
                    if (!StringUtils.isNotBlank((CharSequence)location)) continue;
                    this.dataManagement.publishLocationEvent(location, "semantic.location.removed");
                    this.locationManagement.removeLocation(location);
                }
            }
        }
    }

    public void removeObsoleteClusterLocations(ClusterConfig clusterConfig) {
        String currentNodeUrl = Config.getExternalUrl(null);
        Set clusterMembers = clusterConfig.getNodes().stream().filter(nodeInfo -> !nodeInfo.getHttpAddress().equals(currentNodeUrl)).map(nodeInfo -> this.dataManagement.fetchInstallationIdFromLocation(nodeInfo.getHttpAddress())).collect(Collectors.toSet());
        for (SemanticLocationAuth location : this.locationManagement.getLocations()) {
            if (!StringUtils.isNotBlank((CharSequence)location.getLocation()) || location.getLocationType() != LocationType.GDB || !clusterMembers.contains(this.dataManagement.fetchInstallationIdFromLocation(location.getLocation()))) continue;
            this.dataManagement.publishLocationEvent(location.getLocation(), "semantic.location.removed");
            this.locationManagement.removeLocation(location.getLocation());
        }
    }

    public Collection<SemanticLocationAuth> getLocations() {
        return this.locationManagement.getLocations();
    }
}

