/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core.proxy;

import com.ontotext.forest.core.proxy.AltBodyHttpServletRequest;
import com.ontotext.forest.core.semantic.LocationType;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.semantic.SemanticLocation;
import com.ontotext.graphdb.http.ServletProxy;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProxyToRemoteSesame {
    public static final String UNSUPPORTED_LOCATION_TYPE_ERROR_MSG = "This feature is supported only for attached remote locations of GraphDB type";
    public static final String REPOSITORY_NOT_FOUND_ERROR_MSG = "The specified repository does not exist";
    private final ServletProxy servletProxy;

    @Autowired
    public ProxyToRemoteSesame(ServletProxy servletProxy) {
        this.servletProxy = servletProxy;
    }

    public <T> T proxyToRemoteIfNeeded(HttpServletRequest request, HttpServletResponse response, SemanticLocation location, Callable<T> localProcessor) throws Exception {
        return this.proxyWithBodyToRemoteIfNeeded(null, request, response, location, localProcessor);
    }

    public <T> T proxyToRemoteIfNeeded(HttpServletRequest request, HttpServletResponse response, String repository, SemanticDataManagement semanticDataManagement, Callable<T> localProcessor) throws Exception {
        SemanticLocation semanticLocation = semanticDataManagement.getLocationFromHeaderOrThrow();
        if (semanticLocation.getLocationType() == LocationType.GDB) {
            if (semanticLocation.sesameManager().hasRepositoryConfig(repository)) {
                return this.proxyToRemoteIfNeeded(request, response, semanticLocation, localProcessor);
            }
            response.sendError(404, REPOSITORY_NOT_FOUND_ERROR_MSG);
        } else {
            response.sendError(400, UNSUPPORTED_LOCATION_TYPE_ERROR_MSG);
        }
        return null;
    }

    public <T> T proxyWithBodyToRemoteIfNeeded(Object altBody, HttpServletRequest request, HttpServletResponse response, SemanticLocation location, Callable<T> localProcessor) throws Exception {
        if (location.isLocal()) {
            return localProcessor.call();
        }
        if (altBody != null) {
            request = new AltBodyHttpServletRequest(request, altBody);
        }
        this.proxyRequest(request, response, location);
        return null;
    }

    public <T> T proxyWithBodyToRemoteIfNeeded(Object altBody, HttpServletRequest request, HttpServletResponse response, String repository, SemanticDataManagement semanticDataManagement, Callable<T> localProcessor) throws Exception {
        SemanticLocation semanticLocation = semanticDataManagement.getLocationFromHeaderOrThrow();
        if (semanticLocation.getLocationType() == LocationType.GDB) {
            if (semanticLocation.sesameManager().hasRepositoryConfig(repository)) {
                return this.proxyWithBodyToRemoteIfNeeded(altBody, request, response, semanticLocation, localProcessor);
            }
            response.sendError(404, REPOSITORY_NOT_FOUND_ERROR_MSG);
        } else {
            response.sendError(400, UNSUPPORTED_LOCATION_TYPE_ERROR_MSG);
        }
        return null;
    }

    public void proxyRequest(HttpServletRequest request, HttpServletResponse response, SemanticLocation location) throws IOException {
        String pathInfo = request.getPathInfo();
        String uri = location.getLocation() + request.getServletPath() + (pathInfo != null ? pathInfo : "");
        this.servletProxy.proxyRequest(request, response, uri, location.getHttpClient());
    }

    public CloseableHttpResponse executeGetRequest(SemanticLocation location, String getPath) throws IOException {
        RequestBuilder rb = RequestBuilder.create((String)"GET");
        Object uri = location.getLocation();
        uri = ((String)uri).endsWith("/") ? (String)uri + getPath.substring(1) : (String)uri + getPath;
        rb.setUri((String)uri);
        return location.getHttpClient().execute(rb.build());
    }
}

