/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core.properties;

import com.ontotext.forest.core.properties.AbstractResource;
import com.ontotext.forest.core.properties.ExtendedPropertyPlaceholderConfigurer;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceEditor;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.ResourceUtils;

public class PropertyResource
extends AbstractResource {
    private ExtendedPropertyPlaceholderConfigurer eppc;
    private final Log logger = LogFactory.getLog(this.getClass());
    private Resource[] resources;

    public PropertyResource() {
        this.setOrder(Integer.MIN_VALUE);
    }

    public Object getProperty(String key) {
        return this.eppc.getProperty(key);
    }

    public void setLocation(String location) {
        ResourceEditor editor = (ResourceEditor)BeanUtils.findEditorByConvention(Resource.class);
        this.resources = new Resource[]{this.locationStringToResource(location, editor)};
    }

    public void setLocations(String[] locations) {
        ResourceEditor editor = (ResourceEditor)BeanUtils.findEditorByConvention(Resource.class);
        Resource[] resources = new Resource[locations.length];
        for (int i = 0; i < locations.length; ++i) {
            resources[i] = this.locationStringToResource(locations[i], editor);
        }
        this.resources = resources;
    }

    public void setLocations(List<String> locations) {
        this.setLocations(locations.toArray(new String[locations.size()]));
    }

    private Resource locationStringToResource(String location, ResourceEditor editor) {
        editor.setAsText(location);
        return (Resource)editor.getValue();
    }

    public void setEppc(ExtendedPropertyPlaceholderConfigurer eppc) {
        this.eppc = eppc;
    }

    public void setWildcardLocations(String[] locations) {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        ArrayList<Resource[]> resourceLocations = new ArrayList<Resource[]>();
        ArrayList<Object> fileResources = new ArrayList<Object>();
        ArrayList<Resource> jarResources = new ArrayList<Resource>();
        for (String string : locations) {
            try {
                Resource[] wildcard = resolver.getResources(string);
                if (wildcard == null || wildcard.length <= 0) continue;
                resourceLocations.add(wildcard);
            }
            catch (IOException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        int i = 0;
        boolean entries = true;
        while (entries) {
            entries = false;
            for (Resource[] resourceArray : resourceLocations) {
                if (resourceArray.length <= i) continue;
                try {
                    boolean isJar = ResourceUtils.isJarURL((URL)resourceArray[i].getURL());
                    if (isJar) {
                        jarResources.add(resourceArray[i]);
                    } else {
                        fileResources.add(resourceArray[i]);
                    }
                }
                catch (IOException e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
                entries = true;
            }
            ++i;
        }
        fileResources.addAll(jarResources);
        Collections.reverse(fileResources);
        this.resources = fileResources.toArray(new Resource[fileResources.size()]);
    }

    protected void reloadPropertyPlaceholderConfigurer() {
        this.eppc.refresh();
    }

    public Resource[] getResources() {
        return this.resources;
    }
}

