/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core.monitor.common;

import java.lang.management.ManagementFactory;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class MonitoringMBeanUtils {
    public static Object invokeMethodWithMBean(String repoId, String methodName) throws MalformedObjectNameException, ReflectionException, AttributeNotFoundException, InstanceNotFoundException, MBeanException {
        return ManagementFactory.getPlatformMBeanServer().getAttribute(MonitoringMBeanUtils.getMBeanForRepo(repoId), methodName);
    }

    public static Object invokeMethodWithMBean(String repoId, String methodName, String params) throws MalformedObjectNameException, ReflectionException, AttributeNotFoundException, InstanceNotFoundException, MBeanException {
        return ManagementFactory.getPlatformMBeanServer().invoke(MonitoringMBeanUtils.getMBeanForRepo(repoId), methodName, new String[]{params}, new String[]{String.class.getName()});
    }

    public static Object getCountAttributeFromMBean(String repoId, String attributeName) throws MalformedObjectNameException, ReflectionException, AttributeNotFoundException, InstanceNotFoundException, MBeanException {
        return ManagementFactory.getPlatformMBeanServer().getAttribute(MonitoringMBeanUtils.getMBeanForStructures(repoId, attributeName), "Count");
    }

    public static Object getCountAttributeFromMBean(String attributeName) throws MalformedObjectNameException, ReflectionException, AttributeNotFoundException, InstanceNotFoundException, MBeanException {
        return MonitoringMBeanUtils.getCountAttributeFromMBean(null, attributeName);
    }

    private static ObjectName getMBeanForRepo(String repoId) throws MalformedObjectNameException {
        return new ObjectName("com.ontotext:type=RepositoryMonitor,name=" + ObjectName.quote(repoId));
    }

    private static ObjectName getMBeanForStructures(String repoId, String name) throws MalformedObjectNameException {
        Object domain = "com.ontotext.metrics";
        if (repoId != null) {
            domain = (String)domain + "." + repoId;
        }
        return new ObjectName((String)domain + ":name=" + name);
    }
}

