/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core.healthcheck;

import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.graphdb.raft.ClusterGroup;
import com.ontotext.graphdb.raft.grpc.AbstractRpcClient;
import com.ontotext.graphdb.raft.grpc.RpcNodeClient;
import com.ontotext.graphdb.raft.grpc.StatusResponse;
import com.ontotext.raft.GraphDBReplicationCluster;
import com.ontotext.raft.repository.ClusterRepositoryManager;
import com.ontotext.trree.health.SingleHealthCheck;
import com.ontotext.trree.sdk.HealthResult;
import jakarta.inject.Provider;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class WriteAvailabilityCheck
extends SingleHealthCheck {
    public static final String WRITE_AVAILABILITY_NAME = "write-availability";
    public static final String NOT_IN_CLUSTER = "Not in a cluster";
    public static final String ALL_NODES_IN_SYNC = "All nodes are in sync";
    public static final String MAJORITY_NODES_IN_SYNC = "Majority of nodes are in sync. ";
    public static final String MAJORITY_NODES_NOT_IN_SYNC = "Majority of nodes are not in sync. ";
    public static final String NODE_STATUS_IS = "The node status is ";
    public static final String DELIMITER = ", ";
    public static final String NODE_NOT_IN_SYNC = "Node %s is out of sync.";
    public static final String NODES_NOT_IN_SYNC = "Nodes %s are out of sync.";
    private final Provider<SemanticDataManagement> semanticDataManagementProvider;

    public WriteAvailabilityCheck(Provider<SemanticDataManagement> semanticDataManagementProvider) {
        super(WRITE_AVAILABILITY_NAME);
        this.semanticDataManagementProvider = semanticDataManagementProvider;
    }

    public HealthResult check() throws Exception {
        HealthResult result = ((SemanticDataManagement)this.semanticDataManagementProvider.get()).isClusterExisting() ? this.clusterCheck() : new HealthResult(this.name, HealthResult.Status.GREEN, NOT_IN_CLUSTER);
        return result;
    }

    private HealthResult clusterCheck() {
        HealthResult result;
        GraphDBReplicationCluster cluster = this.getGraphDBReplicationCluster();
        StatusResponse.Status nodeStatus = cluster.getNodeStatus().getStatus();
        if (nodeStatus.equals((Object)StatusResponse.Status.LEADER)) {
            ClusterGroup clusterGroup = cluster.getClusterGroup();
            List<RpcNodeClient> nodesNotInSync = this.collectNodesNotInSync(clusterGroup);
            result = nodesNotInSync.isEmpty() ? new HealthResult(this.name, HealthResult.Status.GREEN, ALL_NODES_IN_SYNC) : (nodesNotInSync.size() < clusterGroup.size() / 2 + 1 ? new HealthResult(this.name, HealthResult.Status.YELLOW, MAJORITY_NODES_IN_SYNC + this.listNodesNotInSync(nodesNotInSync)) : new HealthResult(this.name, HealthResult.Status.RED, MAJORITY_NODES_NOT_IN_SYNC + this.listNodesNotInSync(nodesNotInSync)));
        } else {
            return new HealthResult(this.name, HealthResult.Status.RED, NODE_STATUS_IS + nodeStatus.name());
        }
        return result;
    }

    private GraphDBReplicationCluster getGraphDBReplicationCluster() {
        ClusterRepositoryManager manager = (ClusterRepositoryManager)((SemanticDataManagement)this.semanticDataManagementProvider.get()).getCurrentLocationOrThrow().sesameManager();
        return manager.getReplicationCluster();
    }

    private List<RpcNodeClient> collectNodesNotInSync(ClusterGroup clusterGroup) {
        ArrayList<RpcNodeClient> result = new ArrayList<RpcNodeClient>();
        clusterGroup.forEach(client -> {
            if (client.getStatus() != RpcNodeClient.Status.IN_SYNC) {
                result.add((RpcNodeClient)client);
            }
        });
        return result;
    }

    private String listNodesNotInSync(List<RpcNodeClient> nodesNotInSync) {
        String string = nodesNotInSync.stream().map(AbstractRpcClient::getAddress).collect(Collectors.joining(DELIMITER));
        return nodesNotInSync.size() == 1 ? String.format(NODE_NOT_IN_SYNC, string) : String.format(NODES_NOT_IN_SYNC, string);
    }
}

