/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core.error;

import com.ontotext.trree.util.ErrorUtil;

public class GraphDBWorkbenchException
extends RuntimeException {
    private String extraMessage;

    public GraphDBWorkbenchException(String message) {
        super(message);
    }

    public GraphDBWorkbenchException(String message, Throwable cause) {
        super(message, cause);
        if (cause != null) {
            this.extraMessage = ErrorUtil.getSaneExtraMessage((Throwable)cause);
            String lowercaseExtra = this.extraMessage.toLowerCase();
            int indexOfHTML = Math.min(lowercaseExtra.indexOf("<!doctype"), lowercaseExtra.indexOf("<html"));
            if (indexOfHTML > 0) {
                while (!Character.isAlphabetic(lowercaseExtra.charAt(indexOfHTML - 1)) && !Character.isDigit(lowercaseExtra.charAt(indexOfHTML - 1))) {
                    --indexOfHTML;
                }
                this.extraMessage = this.extraMessage.substring(0, indexOfHTML);
            }
            this.extraMessage = ErrorUtil.getSimpleMessage((String)this.extraMessage);
        }
    }

    @Override
    public String getMessage() {
        String originalMessage = super.getMessage();
        boolean alreadyHasDot = originalMessage.endsWith(".");
        if (this.extraMessage != null) {
            return String.format("%s (%s).", alreadyHasDot ? originalMessage.substring(0, originalMessage.length() - 1) : originalMessage, this.extraMessage);
        }
        return originalMessage + (alreadyHasDot ? "" : ".");
    }
}

