/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.springframework.web.multipart.MultipartFile;

public class GraphDBMultipartFile
implements MultipartFile {
    private final MultipartFile delegate;

    public GraphDBMultipartFile(MultipartFile multipartFile) {
        this.delegate = multipartFile;
    }

    public String getName() {
        return this.delegate.getName();
    }

    public String getOriginalFilename() {
        return this.delegate.getOriginalFilename();
    }

    public String getContentType() {
        return this.delegate.getContentType();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public long getSize() {
        return this.delegate.getSize();
    }

    public byte[] getBytes() throws IOException {
        return this.delegate.getBytes();
    }

    public InputStream getInputStream() throws IOException {
        return this.delegate.getInputStream();
    }

    public void transferTo(File dest) throws IOException, IllegalStateException {
        this.delegate.transferTo(dest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveTo(File location) throws IOException {
        File tempFile = File.createTempFile("upload_", "_" + this.getOriginalFilename());
        try {
            this.transferTo(tempFile);
            try {
                Files.move(tempFile.toPath(), location.toPath(), StandardCopyOption.ATOMIC_MOVE);
            }
            catch (AtomicMoveNotSupportedException amnse) {
                Files.move(tempFile.toPath(), location.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
            }
        }
        finally {
            if (tempFile.exists() && !tempFile.equals(location)) {
                tempFile.delete();
            }
        }
    }
}

