/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core;

import java.util.LinkedHashSet;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.ConversionServiceFactoryBean;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.ConversionServiceFactory;

public class ConversionDiscoveryFactoryBean
extends ConversionServiceFactoryBean
implements ApplicationContextAware {
    private Map<String, Converter> cachedConverters;
    private ApplicationContext applicationContext;

    public ConversionService getObject() {
        ConversionService conversionService = super.getObject();
        if (conversionService instanceof ConverterRegistry) {
            ConverterRegistry registry = (ConverterRegistry)conversionService;
            if (this.cachedConverters == null) {
                this.cachedConverters = this.applicationContext.getBeansOfType(Converter.class);
                ConversionServiceFactory.registerConverters(new LinkedHashSet<Converter>(this.cachedConverters.values()), (ConverterRegistry)registry);
            }
        }
        return conversionService;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

