/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core;

import com.ontotext.forest.core.Account;
import com.ontotext.forest.security.AuthenticatedUser;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.context.ApplicationEvent;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public interface AccountsService
extends UserDetailsService {
    public Collection<Account> getAll();

    @Nullable
    public Account getAccount(String var1);

    public Account getDefaultAdminAccount();

    default public Account getAccountOrThrow(String username) {
        Account account = this.getAccount(username);
        if (account == null) {
            throw new UsernameNotFoundException("User could not be found");
        }
        return account;
    }

    public void editUserAccount(Account var1, boolean var2);

    public void saveUser(Account var1);

    public void addNewUser(Account var1);

    public void delete(String var1);

    public boolean isLocal();

    default public AuthenticatedUser loadUserByUsername(String username) {
        return this.loadUserByUsername(username, null);
    }

    public AuthenticatedUser loadUserByUsername(String var1, Collection<GrantedAuthority> var2);

    public String getImplementationName();

    default public Class<? extends AccountsService> getImplementationClass() {
        return this.getClass();
    }

    public AuthenticationProvider getAuthenticationProvider();

    default public Object getServiceConfig() {
        return null;
    }

    default public void handleEventInCluster(ApplicationEvent event) {
    }

    default public void changeSecurityConfig(String key, Object value) {
    }

    default public void editUserAccountInCluster(Account user, boolean updatePassword) {
        this.editUserAccount(user, updatePassword);
    }

    default public void addNewUserInCluster(Account user) {
        this.addNewUser(user);
    }

    default public void deleteInCluster(String username) {
        this.delete(username);
    }

    default public Map<String, Object> getDefaultSettings() {
        HashMap<String, Object> defaultSettings = new HashMap<String, Object>();
        defaultSettings.put("DEFAULT_SAMEAS", true);
        defaultSettings.put("DEFAULT_INFERENCE", true);
        defaultSettings.put("EXECUTE_COUNT", true);
        defaultSettings.put("IGNORE_SHARED_QUERIES", false);
        defaultSettings.put("DEFAULT_VIS_GRAPH_SCHEMA", true);
        return defaultSettings;
    }
}

