/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.ontotext.graphdb.security.Role;
import jakarta.validation.constraints.Size;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Account
implements Cloneable,
Serializable {
    @Size(min=3)
    private @Size(min=3) String username;
    private String password;
    private Collection<String> grantedAuthorities = new LinkedList<String>();
    private Map<String, Object> appSettings;
    private Date dateCreated = new Date();
    private Set<String> gptThreads = new HashSet<String>();

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Collection<String> getGrantedAuthorities() {
        return this.grantedAuthorities;
    }

    public void setGrantedAuthorities(Collection<String> grantedAuthorities) {
        this.grantedAuthorities = grantedAuthorities != null ? (Collection)grantedAuthorities.stream().map(role -> Role.normalizeRole((String)role, (boolean)false)).distinct().collect(Collectors.toList()) : null;
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public Map<String, Object> getAppSettings() {
        return this.appSettings;
    }

    public void setAppSettings(Map<String, Object> appSettings) {
        this.appSettings = appSettings;
    }

    public Set<String> getGptThreads() {
        return this.gptThreads;
    }

    public void setGptThreads(Set<String> gptThreads) {
        this.gptThreads = gptThreads;
    }

    @JsonIgnore
    public Account clonePasswordless() {
        try {
            Account account = (Account)this.clone();
            account.setPassword("");
            if (this.appSettings != null) {
                account.setAppSettings(new LinkedHashMap<String, Object>(this.appSettings));
            }
            if (this.grantedAuthorities != null) {
                account.setGrantedAuthorities(new ArrayList<String>(this.grantedAuthorities));
            }
            if (this.gptThreads != null) {
                account.setGptThreads(new HashSet<String>(this.gptThreads));
            }
            return account;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public byte[] asBytes() {
        try (ByteArrayOutputStream bytes = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream outputStream = new ObjectOutputStream(bytes);){
                outputStream.writeObject(this);
                outputStream.flush();
                byArray = bytes.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

