/*
 * Decompiled with CFR 0.152.
 */
package de.escalon.hypermedia;

import de.escalon.hypermedia.AnnotationUtils;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;

public class PropertyUtils {
    private PropertyUtils() {
    }

    public static Object getPropertyValue(Object currentCallValue, PropertyDescriptor propertyDescriptor) {
        Object propertyValue = null;
        if (currentCallValue != null && propertyDescriptor.getReadMethod() != null) {
            try {
                propertyValue = propertyDescriptor.getReadMethod().invoke(currentCallValue, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("failed to read property from call value", e);
            }
        }
        return propertyValue;
    }

    public static Map<String, PropertyDescriptor> getPropertyDescriptors(Object bean) {
        return PropertyUtils.getPropertyDescriptors(bean.getClass());
    }

    public static Map<String, PropertyDescriptor> getPropertyDescriptors(Class<?> clazz) {
        try {
            PropertyDescriptor[] propertyDescriptors = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
            LinkedHashMap<String, PropertyDescriptor> ret = new LinkedHashMap<String, PropertyDescriptor>();
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
                ret.put(propertyDescriptor.getName(), propertyDescriptor);
            }
            return ret;
        }
        catch (IntrospectionException e) {
            throw new RuntimeException("failed to get property descriptors of class " + clazz.getSimpleName(), e);
        }
    }

    public static Constructor findDefaultCtor(Constructor[] constructors) {
        Constructor constructor = null;
        for (Constructor ctor : constructors) {
            if (ctor.getParameterTypes().length != 0) continue;
            constructor = ctor;
        }
        return constructor;
    }

    public static Constructor findJsonCreator(Constructor[] constructors, Class creatorAnnotation) {
        Constructor constructor = null;
        for (Constructor ctor : constructors) {
            if (AnnotationUtils.findAnnotation(ctor, creatorAnnotation) == null) continue;
            constructor = ctor;
            break;
        }
        return constructor;
    }

    public static Object getPropertyOrFieldValue(Object currentCallValue, String propertyOrFieldName) {
        if (currentCallValue == null) {
            return null;
        }
        Object propertyValue = PropertyUtils.getBeanPropertyValue(currentCallValue, propertyOrFieldName);
        if (propertyValue == null) {
            propertyValue = PropertyUtils.getFieldValue(currentCallValue, propertyOrFieldName);
        }
        return propertyValue;
    }

    public static Object getFieldValue(Object currentCallValue, String fieldName) {
        try {
            Field[] fields;
            Class<?> beanType = currentCallValue.getClass();
            Object propertyValue = null;
            for (Field field : fields = beanType.getFields()) {
                if (!fieldName.equals(field.getName())) continue;
                propertyValue = field.get(currentCallValue);
                break;
            }
            return propertyValue;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read field " + fieldName + " from " + currentCallValue.toString(), e);
        }
    }

    public static Object getBeanPropertyValue(Object currentCallValue, String paramName) {
        if (currentCallValue == null) {
            return null;
        }
        try {
            PropertyDescriptor[] pds;
            Object propertyValue = null;
            BeanInfo info = Introspector.getBeanInfo(currentCallValue.getClass());
            for (PropertyDescriptor pd : pds = info.getPropertyDescriptors()) {
                if (!paramName.equals(pd.getName())) continue;
                Method readMethod = pd.getReadMethod();
                if (readMethod == null) break;
                propertyValue = readMethod.invoke(currentCallValue, new Object[0]);
                break;
            }
            return propertyValue;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read property " + paramName + " from " + currentCallValue.toString(), e);
        }
    }
}

