/*
 * Decompiled with CFR 0.152.
 */
package com.github.tkurz.sparqlmm.utils;

import com.github.tkurz.media.fragments.ParseException;
import com.github.tkurz.media.fragments.base.MediaFragment;
import com.github.tkurz.media.fragments.base.MediaFragmentURI;
import com.github.tkurz.media.fragments.exceptions.MediaFragmentURISyntaxException;
import com.github.tkurz.media.ontology.type.SpatialEntity;
import com.github.tkurz.media.ontology.type.SpatialTemporalEntity;
import com.github.tkurz.media.ontology.type.TemporalEntity;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;

public class FunctionHelper {
    public static final Literal BOOL_LITERAL_FALSE = SimpleValueFactory.getInstance().createLiteral(false);
    public static final Literal BOOL_LITERAL_TRUE = SimpleValueFactory.getInstance().createLiteral(true);

    public static TemporalEntity toTemporalEntity(Value v) {
        if (v instanceof IRI) {
            try {
                MediaFragmentURI uri = new MediaFragmentURI(v.stringValue());
                return uri.getMediaFragment().hasTemporalFragment() ? uri.getMediaFragment().getTemporalFragment() : null;
            }
            catch (MediaFragmentURISyntaxException e) {
                return null;
            }
        }
        if (v instanceof Literal) {
            try {
                MediaFragment fragment = MediaFragment.create((String)v.stringValue());
                return fragment.hasTemporalFragment() ? fragment.getTemporalFragment() : null;
            }
            catch (ParseException e) {
                return null;
            }
        }
        return null;
    }

    public static SpatialEntity[] toSpatialEntities(Value ... values) {
        SpatialEntity[] entities = new SpatialEntity[values.length];
        for (int i = 0; i < values.length; ++i) {
            SpatialEntity entity = FunctionHelper.toSpatialEntity(values[i]);
            if (entity == null) {
                throw new IllegalArgumentException();
            }
            entities[i] = entity;
        }
        return entities;
    }

    public static SpatialEntity toSpatialEntity(Value v) {
        if (v instanceof IRI) {
            try {
                MediaFragmentURI uri = new MediaFragmentURI(v.stringValue());
                return uri.getMediaFragment().hasSpatialFragment() ? uri.getMediaFragment().getSpatialFragment() : null;
            }
            catch (MediaFragmentURISyntaxException e) {
                return null;
            }
        }
        if (v instanceof Literal) {
            try {
                MediaFragment fragment = MediaFragment.create((String)v.stringValue());
                return fragment.hasSpatialFragment() ? fragment.getSpatialFragment() : null;
            }
            catch (ParseException e) {
                return null;
            }
        }
        return null;
    }

    public static MediaFragmentURI toMediaFragmentURI(Value v) {
        if (v instanceof IRI) {
            try {
                return new MediaFragmentURI(v.stringValue());
            }
            catch (MediaFragmentURISyntaxException e) {
                return null;
            }
        }
        return null;
    }

    public static MediaFragment toMediaFragment(Value v) {
        if (v instanceof IRI) {
            try {
                return new MediaFragmentURI(v.stringValue()).getMediaFragment();
            }
            catch (MediaFragmentURISyntaxException e) {
                return null;
            }
        }
        return null;
    }

    public static SpatialTemporalEntity toSpatialTemporalEntity(Value v) {
        if (v instanceof IRI) {
            try {
                MediaFragmentURI uri = new MediaFragmentURI(v.stringValue());
                return uri.getMediaFragment() != null ? uri.getMediaFragment() : null;
            }
            catch (MediaFragmentURISyntaxException e) {
                return null;
            }
        }
        if (v instanceof Literal) {
            try {
                return MediaFragment.create((String)v.stringValue());
            }
            catch (ParseException e) {
                return null;
            }
        }
        return null;
    }

    public static TemporalEntity[] toTemporalEntities(Value ... values) {
        TemporalEntity[] entities = new TemporalEntity[values.length];
        for (int i = 0; i < values.length; ++i) {
            TemporalEntity entity = FunctionHelper.toTemporalEntity(values[i]);
            if (entity == null) {
                throw new IllegalArgumentException();
            }
            entities[i] = entity;
        }
        return entities;
    }

    public static boolean isMediaFragmentURI(Value value) {
        if (value instanceof IRI) {
            try {
                new MediaFragmentURI(value.stringValue());
                return true;
            }
            catch (MediaFragmentURISyntaxException e) {
                return false;
            }
        }
        return false;
    }

    public static boolean isMediaFragment(Value value) {
        if (value instanceof IRI) {
            return false;
        }
        try {
            MediaFragment.create((String)value.stringValue());
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean isComparable(Value ... values) {
        Class<?> clazz = null;
        String baseURI = null;
        for (Value v : values) {
            if (clazz == null) {
                clazz = v.getClass();
                baseURI = FunctionHelper.getCleanURI(v);
                continue;
            }
            if (v.getClass().equals(clazz)) {
                if (!(v instanceof IRI) || baseURI.equals(FunctionHelper.getCleanURI(v))) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static String getCleanURI(Value v) {
        return v.stringValue().replaceAll("\\?.*", "").replaceAll("#.*", "");
    }
}

