/*
 * Decompiled with CFR 0.152.
 */
package com.github.tkurz.sparqlmm.function.temporal.relation;

import com.github.tkurz.media.ontology.exception.NotComparableException;
import com.github.tkurz.media.ontology.function.TemporalFunction;
import com.github.tkurz.media.ontology.type.TemporalEntity;
import com.github.tkurz.sparqlmm.doc.FunctionDoc;
import com.github.tkurz.sparqlmm.utils.FunctionHelper;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;

@FunctionDoc(title="meets", properties={TemporalEntity.class, TemporalEntity.class}, reference=FunctionDoc.Reference.temporal, description="returns true if resource1.start = resource2.end or resource1.end = resource2.start, else false.")
public class MeetsFunction
implements Function {
    public String getURI() {
        return "http://linkedmultimedia.org/sparql-mm/ns/2.0.0/function#temporalMeets";
    }

    public Value evaluate(ValueFactory valueFactory, Value ... values) throws ValueExprEvaluationException {
        try {
            if (values.length != 2 || !FunctionHelper.isComparable(values)) {
                return FunctionHelper.BOOL_LITERAL_FALSE;
            }
            TemporalEntity[] entities = FunctionHelper.toTemporalEntities(values);
            return valueFactory.createLiteral(TemporalFunction.meets((TemporalEntity)entities[0], (TemporalEntity)entities[1]));
        }
        catch (NotComparableException | IllegalArgumentException e) {
            return FunctionHelper.BOOL_LITERAL_FALSE;
        }
    }
}

